/*
 * Decompiled with CFR 0.152.
 */
package se.kodapan.osm.parser.xml.instantiated;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import org.apache.commons.io.input.ReaderInputStream;
import se.kodapan.osm.domain.Node;
import se.kodapan.osm.domain.OsmObject;
import se.kodapan.osm.domain.Relation;
import se.kodapan.osm.domain.RelationMembership;
import se.kodapan.osm.domain.Way;
import se.kodapan.osm.parser.xml.OsmXmlParserException;
import se.kodapan.osm.parser.xml.instantiated.InstantiatedOsmXmlParser;
import se.kodapan.osm.parser.xml.instantiated.InstantiatedOsmXmlParserDelta;

public abstract class AbstractStreamingInstantiatedOsmXmlParser
extends InstantiatedOsmXmlParser {
    public Stream readerFactory(Reader reader) throws StreamException {
        return this.readerFactory((InputStream)new ReaderInputStream(reader, "utf8"));
    }

    public Stream readerFactory(InputStream inputStream) throws StreamException {
        try {
            return this.readerFactory(new InputStreamReader(inputStream, "utf8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new StreamException(unsupportedEncodingException);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InstantiatedOsmXmlParserDelta parse(Reader reader) throws OsmXmlParserException {
        long l = System.currentTimeMillis();
        InstantiatedOsmXmlParserDelta instantiatedOsmXmlParserDelta = new InstantiatedOsmXmlParserDelta();
        try {
            Stream stream = this.readerFactory(reader);
            OsmObject osmObject = null;
            Node node = null;
            Relation relation = null;
            Way way = null;
            boolean bl = false;
            InstantiatedOsmXmlParser.State state = InstantiatedOsmXmlParser.State.none;
            int n = stream.getEventType();
            while (!stream.isEndDocument(n = stream.next())) {
                if (stream.isStartElement(n)) {
                    Object object2;
                    Object object3;
                    Object object4;
                    if ("create".equals(stream.getLocalName())) {
                        state = InstantiatedOsmXmlParser.State.create;
                        continue;
                    }
                    if ("modify".equals(stream.getLocalName())) {
                        state = InstantiatedOsmXmlParser.State.modify;
                        continue;
                    }
                    if ("delete".equals(stream.getLocalName())) {
                        state = InstantiatedOsmXmlParser.State.delete;
                        continue;
                    }
                    if ("node".equals(stream.getLocalName())) {
                        object4 = Long.valueOf(stream.getAttributeValue(null, "id"));
                        if (state == InstantiatedOsmXmlParser.State.none || state == InstantiatedOsmXmlParser.State.create) {
                            node = this.root.getNode((Long)object4);
                            if (node != null && node.isLoaded() && node.getVersion() != null) {
                                object3 = Integer.valueOf(stream.getAttributeValue(null, "version"));
                                if ((Integer)object3 <= node.getVersion()) {
                                    bl = true;
                                    continue;
                                }
                                throw new OsmXmlParserException("Inconsistency, node " + object4 + " already exists.");
                            }
                            if (node == null) {
                                node = new Node();
                                node.setId((Long)object4);
                            }
                            node.setLatitude(Double.valueOf(stream.getAttributeValue(null, "lat")));
                            node.setLongitude(Double.valueOf(stream.getAttributeValue(null, "lon")));
                            this.parseObjectAttributes(stream, node, "id", "lat", "lon");
                            node.setLoaded(true);
                            osmObject = node;
                            instantiatedOsmXmlParserDelta.getCreatedNodes().add(node);
                            this.root.add(node);
                            continue;
                        }
                        if (state == InstantiatedOsmXmlParser.State.modify) {
                            node = this.root.getNode((Long)object4);
                            if (node == null) {
                                throw new OsmXmlParserException("Inconsistency, node " + object4 + " does not exists.");
                            }
                            object3 = Integer.valueOf(stream.getAttributeValue(null, "version"));
                            if ((Integer)object3 <= node.getVersion()) {
                                bl = true;
                                continue;
                            }
                            if ((Integer)object3 > node.getVersion() + 1 && !this.isAllowingMissingVersions()) {
                                throw new OsmXmlParserException("Inconsistency, version " + object3 + " too great to modify node " + node.getId() + " with version " + node.getVersion());
                            }
                            if (((Integer)object3).equals(node.getVersion())) {
                                throw new OsmXmlParserException("Inconsistency, found same version in new data during modify node.");
                            }
                            node.setTags(null);
                            node.setAttributes(null);
                            node.setLatitude(Double.valueOf(stream.getAttributeValue(null, "lat")));
                            node.setLongitude(Double.valueOf(stream.getAttributeValue(null, "lon")));
                            this.parseObjectAttributes(stream, node, "id", "lat", "lon");
                            osmObject = node;
                            instantiatedOsmXmlParserDelta.getModifiedNodes().add(node);
                            this.root.add(node);
                            continue;
                        }
                        if (state != InstantiatedOsmXmlParser.State.delete) continue;
                        object3 = this.root.getNode((Long)object4);
                        if (object3 == null) {
                            bl = true;
                            continue;
                        }
                        object2 = Integer.valueOf(stream.getAttributeValue(null, "version"));
                        if ((Integer)object2 < ((OsmObject)object3).getVersion()) {
                            bl = true;
                            continue;
                        }
                        if ((Integer)object2 > ((OsmObject)object3).getVersion() + 1 && !this.isAllowingMissingVersions()) {
                            throw new OsmXmlParserException("Inconsistency, too great version found during delete node.");
                        }
                        this.root.remove((OsmObject)object3);
                        instantiatedOsmXmlParserDelta.getDeletedNodes().add((Node)object3);
                        continue;
                    }
                    if ("way".equals(stream.getLocalName())) {
                        long l2 = Long.valueOf(stream.getAttributeValue(null, "id"));
                        if (state == InstantiatedOsmXmlParser.State.none || state == InstantiatedOsmXmlParser.State.create) {
                            way = this.root.getWay(l2);
                            if (way != null && way.isLoaded() && way.getVersion() != null) {
                                object2 = Integer.valueOf(stream.getAttributeValue(null, "version"));
                                if ((Integer)object2 <= way.getVersion()) {
                                    bl = true;
                                    continue;
                                }
                                throw new OsmXmlParserException("Inconsistency, way " + l2 + " already exists.");
                            }
                            if (way == null) {
                                way = new Way();
                                way.setId(l2);
                            }
                            this.parseObjectAttributes(stream, way, "id");
                            way.setLoaded(true);
                            osmObject = way;
                            instantiatedOsmXmlParserDelta.getCreatedWays().add(way);
                            continue;
                        }
                        if (state == InstantiatedOsmXmlParser.State.modify) {
                            way = this.root.getWay(l2);
                            if (way == null) {
                                throw new OsmXmlParserException("Inconsistency, way " + l2 + " does not exists.");
                            }
                            object2 = Integer.valueOf(stream.getAttributeValue(null, "version"));
                            if ((Integer)object2 <= way.getVersion()) {
                                bl = true;
                                continue;
                            }
                            if ((Integer)object2 > way.getVersion() + 1 && !this.isAllowingMissingVersions()) {
                                throw new OsmXmlParserException("Inconsistency, found too great version in new data during modify way.");
                            }
                            if (((Integer)object2).equals(way.getVersion())) {
                                throw new OsmXmlParserException("Inconsistency, found same version in new data during modify way.");
                            }
                            way.setTags(null);
                            way.setAttributes(null);
                            if (way.getNodes() != null) {
                                for (Node node2 : way.getNodes()) {
                                    node2.getWaysMemberships().remove(way);
                                    this.root.add(node2);
                                }
                            }
                            way.setNodes(null);
                            this.parseObjectAttributes(stream, way, "id");
                            osmObject = way;
                            instantiatedOsmXmlParserDelta.getModifiedWays().add(way);
                            continue;
                        }
                        if (state != InstantiatedOsmXmlParser.State.delete) continue;
                        object2 = this.root.getWay(l2);
                        if (object2 == null) {
                            bl = true;
                            continue;
                        }
                        Integer n2 = Integer.valueOf(stream.getAttributeValue(null, "version"));
                        if (n2 < ((OsmObject)object2).getVersion()) {
                            bl = true;
                            continue;
                        }
                        if (n2 > ((OsmObject)object2).getVersion() + 1 && !this.isAllowingMissingVersions()) {
                            throw new OsmXmlParserException("Inconsistency, too great way version found during delete way.");
                        }
                        this.root.remove((OsmObject)object2);
                        instantiatedOsmXmlParserDelta.getDeletedWays().add((Way)object2);
                        continue;
                    }
                    if ("nd".equals(stream.getLocalName())) {
                        if (bl) continue;
                        object4 = Long.valueOf(stream.getAttributeValue(null, "ref"));
                        if (state == InstantiatedOsmXmlParser.State.none || state == InstantiatedOsmXmlParser.State.create || state == InstantiatedOsmXmlParser.State.modify) {
                            object3 = this.root.getNode((Long)object4);
                            if (object3 == null) {
                                object3 = new Node();
                                ((OsmObject)object3).setId((Long)object4);
                                this.root.add((OsmObject)object3);
                            }
                            ((Node)object3).addWayMembership(way);
                            way.addNode((Node)object3);
                            continue;
                        }
                        if (state != InstantiatedOsmXmlParser.State.delete) continue;
                    }
                    if ("relation".equals(stream.getLocalName())) {
                        object4 = Long.valueOf(stream.getAttributeValue(null, "id"));
                        if (state == InstantiatedOsmXmlParser.State.none || state == InstantiatedOsmXmlParser.State.create) {
                            relation = this.root.getRelation((Long)object4);
                            if (relation != null && relation.isLoaded() && relation.getVersion() != null) {
                                object3 = Integer.valueOf(stream.getAttributeValue(null, "version"));
                                if ((Integer)object3 <= relation.getVersion()) {
                                    bl = true;
                                    continue;
                                }
                                throw new OsmXmlParserException("Inconsistency, relation " + object4 + " already exists.");
                            }
                            if (relation == null) {
                                relation = new Relation();
                                relation.setId((Long)object4);
                            }
                            this.parseObjectAttributes(stream, relation, "id");
                            relation.setLoaded(true);
                            osmObject = relation;
                            instantiatedOsmXmlParserDelta.getCreatedRelations().add(relation);
                            continue;
                        }
                        if (state == InstantiatedOsmXmlParser.State.modify) {
                            relation = this.root.getRelation((Long)object4);
                            if (relation == null) {
                                throw new OsmXmlParserException("Inconsistency, relation " + object4 + " does not exists.");
                            }
                            object3 = Integer.valueOf(stream.getAttributeValue(null, "version"));
                            if ((Integer)object3 < relation.getVersion()) {
                                bl = true;
                                continue;
                            }
                            if ((Integer)object3 > relation.getVersion() + 1 && !this.isAllowingMissingVersions()) {
                                throw new OsmXmlParserException("Inconsistency, too great version found during modify relation.");
                            }
                            if (((Integer)object3).equals(relation.getVersion())) {
                                throw new OsmXmlParserException("Inconsistency, same version found during modify relation.");
                            }
                            if (relation.getMembers() != null) {
                                for (RelationMembership relationMembership : relation.getMembers()) {
                                    relationMembership.getObject().getRelationMemberships().remove(relationMembership);
                                    if (!relationMembership.getObject().getRelationMemberships().isEmpty()) continue;
                                    relationMembership.getObject().setRelationMemberships(null);
                                }
                                relation.setMembers(null);
                            }
                            relation.setAttributes(null);
                            relation.setTags(null);
                            osmObject = relation;
                            this.parseObjectAttributes(stream, relation, "id");
                            instantiatedOsmXmlParserDelta.getModifiedRelations().add(relation);
                            continue;
                        }
                        if (state != InstantiatedOsmXmlParser.State.delete) continue;
                        object3 = this.root.getRelation((Long)object4);
                        if (object3 == null) {
                            bl = true;
                            continue;
                        }
                        object2 = Integer.valueOf(stream.getAttributeValue(null, "version"));
                        if ((Integer)object2 < ((OsmObject)object3).getVersion()) {
                            bl = true;
                            continue;
                        }
                        if ((Integer)object2 > ((OsmObject)object3).getVersion() + 1 && !this.isAllowingMissingVersions()) {
                            throw new OsmXmlParserException("Inconsistency, too great version found during delete relation.");
                        }
                        if (((Relation)object3).getMembers() != null) {
                            for (RelationMembership relationMembership : ((Relation)object3).getMembers()) {
                                relationMembership.getObject().getRelationMemberships().remove(relationMembership);
                                if (!relationMembership.getObject().getRelationMemberships().isEmpty()) continue;
                                relationMembership.getObject().setRelationMemberships(null);
                            }
                            ((Relation)object3).setMembers(null);
                        }
                        this.root.remove((OsmObject)object3);
                        instantiatedOsmXmlParserDelta.getDeletedRelations().add((Relation)object3);
                        continue;
                    }
                    if ("member".equals(stream.getLocalName())) {
                        if (bl) continue;
                        if (state == InstantiatedOsmXmlParser.State.none || state == InstantiatedOsmXmlParser.State.create || state == InstantiatedOsmXmlParser.State.modify) {
                            object4 = new RelationMembership();
                            ((RelationMembership)object4).setRelation(relation);
                            ((RelationMembership)object4).setRole(this.roleIntern.intern(stream.getAttributeValue(null, "role")));
                            object3 = Long.valueOf(stream.getAttributeValue(null, "ref"));
                            object2 = stream.getAttributeValue(null, "type");
                            if ("way".equals(object2)) {
                                void var16_25;
                                Way way2 = this.root.getWay((Long)object3);
                                if (way2 == null) {
                                    Way way3 = new Way();
                                    way3.setId((Long)object3);
                                    this.root.add(way3);
                                }
                                ((RelationMembership)object4).setObject((OsmObject)var16_25);
                            } else if ("node".equals(object2)) {
                                void var16_28;
                                Node node3 = this.root.getNode((Long)object3);
                                if (node3 == null) {
                                    Node node4 = new Node();
                                    node4.setId((Long)object3);
                                    this.root.add(node4);
                                }
                                ((RelationMembership)object4).setObject((OsmObject)var16_28);
                            } else if ("relation".equals(object2)) {
                                void var16_31;
                                Relation relation2 = this.root.getRelation((Long)object3);
                                if (relation2 == null) {
                                    Relation relation3 = new Relation();
                                    relation3.setId((Long)object3);
                                    this.root.add(relation3);
                                }
                                ((RelationMembership)object4).setObject((OsmObject)var16_31);
                            } else {
                                throw new RuntimeException("Unsupported relation member type: " + object2);
                            }
                            ((RelationMembership)object4).getObject().addRelationMembership((RelationMembership)object4);
                            relation.addMember((RelationMembership)object4);
                            continue;
                        }
                        if (state != InstantiatedOsmXmlParser.State.delete) continue;
                        continue;
                    }
                    if (!"tag".equals(stream.getLocalName()) || bl) continue;
                    if (state == InstantiatedOsmXmlParser.State.none || state == InstantiatedOsmXmlParser.State.create || state == InstantiatedOsmXmlParser.State.modify) {
                        object4 = this.tagKeyIntern.intern(stream.getAttributeValue(null, "k"));
                        object3 = this.tagValueIntern.intern(stream.getAttributeValue(null, "v"));
                        osmObject.setTag((String)object4, (String)object3);
                        continue;
                    }
                    if (state != InstantiatedOsmXmlParser.State.delete) continue;
                    continue;
                }
                if (!stream.isEndElement(n)) continue;
                if ("create".equals(stream.getLocalName())) {
                    state = InstantiatedOsmXmlParser.State.none;
                    continue;
                }
                if ("modify".equals(stream.getLocalName())) {
                    state = InstantiatedOsmXmlParser.State.none;
                    continue;
                }
                if ("delete".equals(stream.getLocalName())) {
                    state = InstantiatedOsmXmlParser.State.none;
                    continue;
                }
                if ("node".equals(stream.getLocalName())) {
                    if (state == InstantiatedOsmXmlParser.State.none || state == InstantiatedOsmXmlParser.State.create || state == InstantiatedOsmXmlParser.State.modify) {
                        this.root.add(node);
                    }
                    this.processParsedNode(node, state);
                    node = null;
                    osmObject = null;
                    bl = false;
                    continue;
                }
                if ("way".equals(stream.getLocalName())) {
                    if (state == InstantiatedOsmXmlParser.State.none || state == InstantiatedOsmXmlParser.State.create || state == InstantiatedOsmXmlParser.State.modify) {
                        this.root.add(way);
                    }
                    this.processParsedWay(way, state);
                    way = null;
                    osmObject = null;
                    bl = false;
                    continue;
                }
                if (!"relation".equals(stream.getLocalName())) continue;
                if (state == InstantiatedOsmXmlParser.State.none || state == InstantiatedOsmXmlParser.State.create || state == InstantiatedOsmXmlParser.State.modify) {
                    this.root.add(relation);
                }
                this.processParsedRelation(relation, state);
                relation = null;
                osmObject = null;
                bl = false;
            }
            stream.close();
        }
        catch (StreamException streamException) {
            throw new OsmXmlParserException(streamException);
        }
        long l3 = System.currentTimeMillis() - l;
        return instantiatedOsmXmlParserDelta;
    }

    private void parseObjectAttributes(Stream stream, OsmObject osmObject, String ... stringArray) throws StreamException {
        for (int i = 0; i < stream.getAttributeCount(); ++i) {
            String string = stream.getAttributeLocalName(i);
            String string2 = stream.getAttributeValue(i);
            if ("version".equals(string)) {
                osmObject.setVersion(Integer.valueOf(string2));
                continue;
            }
            if ("changeset".equals(string)) {
                osmObject.setChangeset(Long.valueOf(string2));
                continue;
            }
            if ("uid".equals(string)) {
                osmObject.setUid(Long.valueOf(string2));
                continue;
            }
            if ("user".equals(string)) {
                osmObject.setUser(this.userIntern.intern(string2));
                continue;
            }
            if ("visible".equals(string)) {
                osmObject.setVisible(Boolean.valueOf(string2));
                continue;
            }
            if ("timestamp".equals(string)) {
                try {
                    osmObject.setTimestamp(this.timestampFormat.parse(string2).getTime());
                    continue;
                }
                catch (ParseException parseException) {
                    throw new RuntimeException(parseException);
                }
            }
            boolean bl = false;
            for (String string3 : stringArray) {
                if (!string3.equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            osmObject.setAttribute(string, string2);
        }
    }

    public static abstract class Stream {
        public abstract int getEventType() throws StreamException;

        public abstract boolean isEndDocument(int var1) throws StreamException;

        public abstract int next() throws StreamException;

        public abstract boolean isStartElement(int var1) throws StreamException;

        public abstract boolean isEndElement(int var1) throws StreamException;

        public abstract String getLocalName() throws StreamException;

        public abstract String getAttributeValue(String var1, String var2) throws StreamException;

        public abstract int getAttributeCount() throws StreamException;

        public abstract String getAttributeValue(int var1) throws StreamException;

        public abstract String getAttributeLocalName(int var1) throws StreamException;

        public abstract void close() throws StreamException;
    }

    public static class StreamException
    extends Exception {
        public StreamException() {
        }

        public StreamException(String string) {
            super(string);
        }

        public StreamException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public StreamException(Throwable throwable) {
            super(throwable);
        }
    }
}

