/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.checkBoxTree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodeData;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodePanel;

public class CheckBoxNodeRenderer
implements TreeCellRenderer {
    private final CheckBoxNodePanel panel = new CheckBoxNodePanel();
    private final DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();
    private final Color selectionForeground;
    private final Color selectionBackground;
    private final Color textForeground;
    private final Color textBackground;

    public CheckBoxNodeRenderer() {
        Font font = UIManager.getFont("Tree.font");
        if (font != null) {
            this.panel.getLabel().setFont(font);
        }
        Boolean bl = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.panel.check.setFocusPainted(bl != null && bl != false);
        this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
        this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
        this.textForeground = UIManager.getColor("Tree.textForeground");
        this.textBackground = UIManager.getColor("Tree.textBackground");
    }

    protected CheckBoxNodePanel getPanel() {
        return this.panel;
    }

    public void addNodeListener(MouseAdapter mouseAdapter) {
        this.panel.addMouseListener(mouseAdapter);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object2;
        CheckBoxNodeData checkBoxNodeData = null;
        if (object instanceof DefaultMutableTreeNode && (object2 = (defaultMutableTreeNode = (DefaultMutableTreeNode)object).getUserObject()) instanceof CheckBoxNodeData) {
            checkBoxNodeData = (CheckBoxNodeData)object2;
        }
        this.panel.setSelected(Boolean.FALSE);
        this.panel.setEnabled(jTree.isEnabled());
        if (bl) {
            this.panel.setForeground(this.selectionForeground);
            this.panel.setBackground(this.selectionBackground);
            this.panel.getLabel().setForeground(this.selectionForeground);
            this.panel.getLabel().setBackground(this.selectionBackground);
        } else {
            this.panel.setForeground(this.textForeground);
            this.panel.setBackground(this.textBackground);
            this.panel.getLabel().setForeground(this.textForeground);
            this.panel.getLabel().setBackground(this.textBackground);
        }
        if (checkBoxNodeData == null) {
            return this.defaultRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        }
        this.panel.setData(checkBoxNodeData);
        this.panel.setSelected(checkBoxNodeData.isSelected());
        return this.panel;
    }
}

