/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.openstreetmap.gui.jmapviewer.AbstractLayer;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.LayerGroup;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodePanel;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxTree;
import org.openstreetmap.gui.jmapviewer.interfaces.MapObject;

public class JMapViewerTree
extends JPanel {
    private static final long serialVersionUID = 3050203054402323972L;
    private JMapViewer map;
    private CheckBoxTree tree;
    private JPanel treePanel;
    private JSplitPane splitPane = new JSplitPane(1);

    public JMapViewerTree(String string) {
        this(string, false);
    }

    public JMapViewerTree(String string, boolean bl) {
        this.tree = new CheckBoxTree(string);
        this.treePanel = new JPanel(new BorderLayout());
        this.treePanel.add((Component)this.tree, "Center");
        this.treePanel.add((Component)new JLabel("<html><center>Use right mouse button to<br />show/hide texts</center></html>"), "South");
        this.map = new JMapViewer();
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(150);
        Dimension dimension = new Dimension(100, 50);
        this.map.setMinimumSize(dimension);
        this.createRefresh();
        this.setLayout(new BorderLayout());
        this.setTreeVisible(bl);
        this.tree.addNodeListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                AbstractLayer abstractLayer;
                if (mouseEvent.isPopupTrigger() && (abstractLayer = ((CheckBoxNodePanel)mouseEvent.getComponent()).getData().getAbstractLayer()) != null) {
                    JMapViewerTree.this.createPopupMenu(abstractLayer).show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private JPopupMenu createPopupMenu(final AbstractLayer abstractLayer) {
        JMenuItem jMenuItem = new JMenuItem("show texts");
        JMenuItem jMenuItem2 = new JMenuItem("hide texts");
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (abstractLayer.isVisibleTexts() == null) {
            jPopupMenu.add(jMenuItem);
            jPopupMenu.add(jMenuItem2);
        } else if (abstractLayer.isVisibleTexts().booleanValue()) {
            jPopupMenu.add(jMenuItem2);
        } else {
            jPopupMenu.add(jMenuItem);
        }
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMapViewerTree.setVisibleTexts(abstractLayer, true);
                if (abstractLayer.getParent() != null) {
                    abstractLayer.getParent().calculateVisibleTexts();
                }
                JMapViewerTree.this.map.repaint();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMapViewerTree.setVisibleTexts(abstractLayer, false);
                if (abstractLayer.getParent() != null) {
                    abstractLayer.getParent().calculateVisibleTexts();
                }
                JMapViewerTree.this.map.repaint();
            }
        });
        return jPopupMenu;
    }

    private static void setVisibleTexts(AbstractLayer abstractLayer, boolean bl) {
        LayerGroup layerGroup;
        abstractLayer.setVisibleTexts(bl);
        if (abstractLayer instanceof LayerGroup && (layerGroup = (LayerGroup)abstractLayer).getLayers() != null) {
            for (AbstractLayer abstractLayer2 : layerGroup.getLayers()) {
                JMapViewerTree.setVisibleTexts(abstractLayer2, bl);
            }
        }
    }

    public Layer addLayer(String string) {
        Layer layer = new Layer(string);
        this.addLayer(layer);
        return layer;
    }

    public JMapViewerTree addLayer(Layer layer) {
        this.tree.addLayer(layer);
        return this;
    }

    public JMapViewerTree addLayer(MapObject mapObject) {
        return this.addLayer(mapObject.getLayer());
    }

    public Layer removeFromLayer(MapObject mapObject) {
        mapObject.getLayer().getElements().remove(mapObject);
        return mapObject.getLayer();
    }

    public static int size(List<?> list) {
        return list == null ? 0 : list.size();
    }

    public JMapViewer getViewer() {
        return this.map;
    }

    public CheckBoxTree getTree() {
        return this.tree;
    }

    public void addMapObject(MapObject mapObject) {
    }

    public void setTreeVisible(boolean bl) {
        this.removeAll();
        this.revalidate();
        if (bl) {
            this.splitPane.setLeftComponent(this.treePanel);
            this.splitPane.setRightComponent(this.map);
            this.add((Component)this.splitPane, "Center");
        } else {
            this.add((Component)this.map, "Center");
        }
        this.repaint();
    }

    private void createRefresh() {
        this.tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                JMapViewerTree.this.repaint();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
    }
}

