/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.util.List;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.marker.Marker;
import org.gpsmaster.painter.Painter;
import org.openstreetmap.gui.jmapviewer.JMapViewer;

public class TrackPainter
extends Painter {
    private float trackLineWidth = 3.0f;
    private boolean paintBorder = true;
    private final int ORDER = 0;

    public TrackPainter() {
        this.order = 0;
    }

    public TrackPainter(JMapViewer jMapViewer) {
        super(jMapViewer);
        this.order = 0;
    }

    public float getLineWidth() {
        return this.trackLineWidth;
    }

    public void setLineWidth(float f) {
        this.trackLineWidth = f;
    }

    @Override
    public void paint(Graphics2D graphics2D, GPXFile gPXFile) {
        BasicStroke basicStroke = new BasicStroke(this.trackLineWidth + 2.0f, 1, 1);
        BasicStroke basicStroke2 = new BasicStroke(this.trackLineWidth, 1, 1);
        float[] fArray = new float[]{this.trackLineWidth * 3.0f, this.trackLineWidth};
        BasicStroke basicStroke3 = new BasicStroke(this.trackLineWidth + 2.0f, 0, 0, 10.0f, fArray, 0.0f);
        Stroke stroke = graphics2D.getStroke();
        if (gPXFile.isVisible() && this.enabled) {
            for (Route gPXObjectCommon : gPXFile.getRoutes()) {
                if (!gPXObjectCommon.isVisible()) continue;
                this.paintPath(graphics2D, gPXObjectCommon.getPath(), basicStroke3, null);
            }
            for (Track track : gPXFile.getTracks()) {
                if (!track.isVisible()) continue;
                for (WaypointGroup waypointGroup : track.getTracksegs()) {
                    if (!waypointGroup.isVisible()) continue;
                    this.paintPath(graphics2D, waypointGroup, basicStroke2, basicStroke);
                }
            }
            if (gPXFile.isTrackPtsVisible()) {
                for (Route route : gPXFile.getRoutes()) {
                    if (!route.isTrackPtsVisible() || !route.isVisible()) continue;
                    this.paintPathpoints(graphics2D, route.getPath());
                }
                for (Track track : gPXFile.getTracks()) {
                    if (!track.isTrackPtsVisible() || !track.isVisible()) continue;
                    for (WaypointGroup waypointGroup : track.getTracksegs()) {
                        this.paintPathpoints(graphics2D, waypointGroup);
                    }
                }
            }
        }
        graphics2D.setStroke(stroke);
    }

    @Override
    public void paint(Graphics2D graphics2D, List<Marker> list) {
    }

    private void paintPath(Graphics2D graphics2D, WaypointGroup waypointGroup, Stroke stroke, Stroke stroke2) {
        Point point = this.mapViewer.getMapPosition(waypointGroup.getMinLat(), waypointGroup.getMaxLon(), false);
        Point point2 = this.mapViewer.getMapPosition(waypointGroup.getMaxLat(), waypointGroup.getMinLon(), false);
        if (point.x < 0 || point.y < 0 || point2.x > this.mapViewer.getWidth() || point2.y > this.mapViewer.getHeight()) {
            return;
        }
        graphics2D.setColor(waypointGroup.getColor());
        if (waypointGroup.getNumPts() >= 2) {
            List<Waypoint> list = waypointGroup.getWaypoints();
            GeneralPath generalPath = new GeneralPath();
            Waypoint waypoint = waypointGroup.getStart();
            Point point3 = this.mapViewer.getMapPosition(waypoint.getLat(), waypoint.getLon(), false);
            generalPath.moveTo(point3.x, point3.y);
            Point point4 = point3;
            for (int i = 1; i < list.size(); ++i) {
                waypoint = list.get(i);
                point3 = this.mapViewer.getMapPosition(waypoint.getLat(), waypoint.getLon(), false);
                if (!point3.equals(point4)) {
                    generalPath.lineTo(point3.x, point3.y);
                }
                point4 = point3;
            }
            if (this.paintBorder && waypointGroup.getColor().getAlpha() == 255 && stroke2 != null) {
                graphics2D.setStroke(stroke2);
                graphics2D.setColor(Color.BLACK);
                graphics2D.draw(generalPath);
            }
            graphics2D.setStroke(stroke);
            graphics2D.setColor(waypointGroup.getColor());
            graphics2D.draw(generalPath);
        }
    }

    private void paintPathpoints(Graphics2D graphics2D, WaypointGroup waypointGroup) {
        if (waypointGroup.isVisible() && waypointGroup.isTrackPtsVisible()) {
            graphics2D.setColor(Color.BLACK);
            for (Waypoint waypoint : waypointGroup.getWaypoints()) {
                Point point = this.mapViewer.getMapPosition(waypoint.getLat(), waypoint.getLon(), false);
                if (!this.mapViewer.getBounds().contains(point)) continue;
                graphics2D.drawOval(point.x - 2, point.y - 2, 4, 4);
            }
        }
    }
}

