/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.util.List;
import javax.swing.ImageIcon;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.marker.Marker;
import org.gpsmaster.painter.Painter;
import org.openstreetmap.gui.jmapviewer.JMapViewer;

public class StartEndPainter
extends Painter {
    private Image imgPathStart;
    private Image imgPathEnd;
    private final int ORDER = 5;

    public StartEndPainter() {
        this.init();
    }

    public StartEndPainter(JMapViewer jMapViewer) {
        super(jMapViewer);
        this.init();
    }

    @Override
    public void paint(Graphics2D graphics2D, GPXFile gPXFile) {
        if (gPXFile.isVisible() && this.enabled) {
            for (Route gPXObjectCommon : gPXFile.getRoutes()) {
                if (!gPXObjectCommon.isVisible()) continue;
                this.paintStartAndEnd(graphics2D, gPXObjectCommon.getPath());
            }
            for (Track track : gPXFile.getTracks()) {
                if (!track.isVisible()) continue;
                for (WaypointGroup waypointGroup : track.getTracksegs()) {
                    if (!waypointGroup.isVisible()) continue;
                    this.paintStartAndEnd(graphics2D, waypointGroup);
                }
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D, List<Marker> list) {
    }

    private void init() {
        this.order = 5;
        this.imgPathStart = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/marker/path-start.png")).getImage();
        this.imgPathEnd = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/marker/path-end.png")).getImage();
    }

    private void paintStartAndEnd(Graphics2D graphics2D, WaypointGroup waypointGroup) {
        Point point;
        Waypoint waypoint;
        if (waypointGroup.getNumPts() >= 2) {
            waypoint = waypointGroup.getEnd();
            point = this.mapViewer.getMapPosition(waypoint.getLat(), waypoint.getLon(), false);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawImage(this.imgPathEnd, point.x - 9, point.y - 28, null);
        }
        if (waypointGroup.getNumPts() >= 1) {
            waypoint = waypointGroup.getStart();
            point = this.mapViewer.getMapPosition(waypoint.getLat(), waypoint.getLon(), false);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawImage(this.imgPathStart, point.x - 9, point.y - 28, null);
        }
    }
}

