/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.util.List;
import org.gpsmaster.gpxpanel.ArrowType;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.marker.Marker;
import org.gpsmaster.painter.Painter;

public class ArrowPainter
extends Painter {
    private final double arrowOffset = -12.0;
    private Polygon arrowHead = new Polygon();
    private Polygon parallelArrow = new Polygon();
    private final Color color = Color.BLACK;
    private final int check = 2;
    private ArrowType arrowType = ArrowType.NONE;

    public ArrowPainter() {
        this.order = 7;
        this.arrowHead.addPoint(0, 8);
        this.arrowHead.addPoint(-5, -5);
        this.arrowHead.addPoint(5, -5);
        this.parallelArrow.addPoint(0, -14);
        this.parallelArrow.addPoint(0, 8);
        this.parallelArrow.addPoint(-4, -4);
        this.parallelArrow.addPoint(4, -4);
        this.parallelArrow.addPoint(0, 8);
    }

    public ArrowType getArrowType() {
        return this.arrowType;
    }

    public void setArrowType(ArrowType arrowType) {
        this.arrowType = arrowType;
    }

    @Override
    public void paint(Graphics2D graphics2D, GPXFile gPXFile) {
        if (this.coordinator.getDistanceInterval() == 0.0) {
            this.coordinator.setDistanceInterval(this.mapViewer.getMeterPerPixel() * 125.0);
        }
        if (this.arrowType != ArrowType.NONE && this.enabled && gPXFile.isVisible()) {
            for (Track gPXObjectCommon : gPXFile.getTracks()) {
                for (WaypointGroup waypointGroup : gPXObjectCommon.getTracksegs()) {
                    if (!gPXObjectCommon.isVisible() || !waypointGroup.isVisible()) continue;
                    this.paintGroup(graphics2D, waypointGroup);
                }
            }
            for (Route route : gPXFile.getRoutes()) {
                if (!route.isVisible()) continue;
                this.paintGroup(graphics2D, route.getPath());
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D, List<Marker> list) {
    }

    private void paintGroup(Graphics2D graphics2D, WaypointGroup waypointGroup) {
        double d = 0.0;
        double d2 = this.coordinator.getDistanceInterval() / 2.0;
        long l = waypointGroup.getWaypoints().size();
        int n = 1;
        while ((long)n < l) {
            Waypoint waypoint = waypointGroup.getWaypoints().get(n - 1);
            Waypoint waypoint2 = waypointGroup.getWaypoints().get(n);
            int n2 = n - 2;
            int n3 = n + 2;
            if ((d += waypoint2.getDistance(waypoint)) >= d2 && n2 >= 0 && (long)n3 < l) {
                switch (this.arrowType) {
                    case PARALLEL: {
                        this.paintParallelArrow(graphics2D, waypointGroup.getColor(), waypoint2, waypointGroup.getWaypoints().get(n2), waypointGroup.getWaypoints().get(n3));
                        break;
                    }
                    case ONTRACK: {
                        this.paintTrackArrow(graphics2D, this.color, waypoint2, waypointGroup.getWaypoints().get(n2), waypointGroup.getWaypoints().get(n3));
                        break;
                    }
                }
                d = 0.0;
                d2 = this.coordinator.getDistanceInterval();
            }
            ++n;
        }
    }

    private void paintParallelArrow(Graphics2D graphics2D, Color color, Waypoint waypoint, Waypoint waypoint2, Waypoint waypoint3) {
        Point point = this.mapViewer.getMapPosition(waypoint2.getLat(), waypoint2.getLon(), false);
        Point point2 = this.mapViewer.getMapPosition(waypoint3.getLat(), waypoint3.getLon(), false);
        Point point3 = this.mapViewer.getMapPosition(waypoint.getLat(), waypoint.getLon(), false);
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.setToIdentity();
        double d = Math.atan2(point2.y - point.y, point2.x - point.x);
        affineTransform2.translate(point3.x, point3.y);
        affineTransform2.rotate(d - 1.5707963267948966);
        affineTransform2.translate(-12.0, -0.5 * point.distance(point2));
        graphics2D.setColor(color);
        graphics2D.transform(affineTransform2);
        graphics2D.drawPolygon(this.parallelArrow);
        graphics2D.setTransform(affineTransform);
    }

    private void paintTrackArrow(Graphics2D graphics2D, Color color, Waypoint waypoint, Waypoint waypoint2, Waypoint waypoint3) {
        Point point = this.mapViewer.getMapPosition(waypoint2.getLat(), waypoint2.getLon(), false);
        Point point2 = this.mapViewer.getMapPosition(waypoint3.getLat(), waypoint3.getLon(), false);
        Point point3 = this.mapViewer.getMapPosition(waypoint.getLat(), waypoint.getLon(), false);
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.setToIdentity();
        double d = Math.atan2(point2.y - point.y, point2.x - point.x);
        affineTransform2.translate(point3.x, point3.y);
        affineTransform2.rotate(d - 1.5707963267948966);
        affineTransform2.translate(0.0, -0.5 * point.distance(point2));
        graphics2D.setColor(color);
        graphics2D.transform(affineTransform2);
        graphics2D.fill(this.arrowHead);
        graphics2D.setTransform(affineTransform);
    }
}

