/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.online;

import eu.fuegenstein.unit.UnitConverter;
import java.util.Date;
import javax.swing.Icon;
import org.gpsmaster.dialogs.TransferableItemTableModel;
import org.gpsmaster.online.OnlineTrack;

public class GpsiesTableModel
extends TransferableItemTableModel {
    private static final long serialVersionUID = 453877575896893489L;
    private final String[] colNames = new String[]{"", "Name", "Length", "Date"};

    public GpsiesTableModel(UnitConverter unitConverter) {
        super(unitConverter);
    }

    @Override
    public int getColumnCount() {
        return this.colNames.length;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Icon.class;
            }
            case 2: {
                return Long.class;
            }
            case 3: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        return this.colNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        OnlineTrack onlineTrack = (OnlineTrack)this.itemList.get(n);
        switch (n2) {
            case 0: {
                return this.getStatusIcon(onlineTrack);
            }
            case 1: {
                return onlineTrack.getName();
            }
            case 2: {
                return (long)this.uc.dist(onlineTrack.getLength() * 1000L);
            }
            case 3: {
                return onlineTrack.getDate();
            }
        }
        return "--";
    }
}

