/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpxpanel;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.gpsmaster.gpxpanel.GPXExtension;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.GPXObjectND;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.marker.Marker;

public class WaypointGroup
extends GPXObjectND
implements Comparable<WaypointGroup>,
TreeNode {
    private WptGrpType wptGrpType;
    private List<Waypoint> waypoints = new ArrayList<Waypoint>();
    private final double exMinDist = 0.2f;

    public WaypointGroup(Color color, WptGrpType wptGrpType) {
        super(color);
        switch (wptGrpType) {
            case WAYPOINTS: {
                this.name = "Waypoints";
                break;
            }
            case ROUTE: {
                this.name = "Route";
                break;
            }
            case TRACKSEG: {
                this.name = "Track segment";
            }
        }
        this.wptGrpType = wptGrpType;
    }

    public WaypointGroup(WaypointGroup waypointGroup) {
        super(waypointGroup);
        this.wptGrpType = waypointGroup.wptGrpType;
        for (Waypoint waypoint : waypointGroup.waypoints) {
            this.waypoints.add(new Waypoint(waypoint));
        }
    }

    public WptGrpType getWptGrpType() {
        return this.wptGrpType;
    }

    public List<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public void setWaypoints(List<Waypoint> list) {
        this.waypoints = list;
    }

    public void addWaypoint(Waypoint waypoint) {
        this.waypoints.add(waypoint);
    }

    public void removeWaypoint(Waypoint waypoint) {
        this.waypoints.remove(waypoint);
        this.updateBounds();
    }

    public int getNumPts() {
        return this.waypoints.size();
    }

    public Waypoint getStart() {
        if (this.waypoints.size() > 0) {
            return this.waypoints.get(0);
        }
        return null;
    }

    public Waypoint getEnd() {
        if (this.waypoints.size() > 0) {
            return this.waypoints.get(this.waypoints.size() - 1);
        }
        return null;
    }

    @Override
    public void updateAllProperties() {
        if (this.waypoints.size() > 0) {
            this.updateDuration();
            this.updateLength();
            this.updateEx();
            this.updateMaxSpeed();
            this.updateEleProps();
            this.updateBounds();
            this.updateStartEnd();
            this.updateExtensions();
            this.extToColor();
        }
    }

    private void updateExtensions() {
        for (Waypoint waypoint : this.waypoints) {
            this.updateExtension(waypoint.getExtension());
        }
    }

    private void updateExtension(GPXExtension gPXExtension) {
        if (null != gPXExtension) {
            for (GPXExtension gPXExtension2 : gPXExtension.getExtensions()) {
                if (null != gPXExtension2.getValue() && !gPXExtension2.getValue().trim().isEmpty()) {
                    String[] stringArray = gPXExtension2.getKey().split(":");
                    String string = stringArray[stringArray.length - 1];
                    try {
                        double d = Double.parseDouble(gPXExtension2.getValue());
                        GPXObject.ExtensionMeta extensionMeta = (GPXObject.ExtensionMeta)this.minMaxExtensions.get(string);
                        if (null == extensionMeta) {
                            extensionMeta = new GPXObject.ExtensionMeta();
                            extensionMeta.name = string;
                            this.minMaxExtensions.put(string, extensionMeta);
                        }
                        extensionMeta.values.add(d);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("GPXExtension is not a number! " + gPXExtension2.getKey() + " | " + gPXExtension2.getValue());
                    }
                }
                this.updateExtension(gPXExtension2);
            }
        }
    }

    private void updateDuration() {
        this.duration = this.getStart().getDuration(this.getEnd());
    }

    private void updateEx() {
        this.exStop = 0L;
        Waypoint waypoint = this.getStart();
        for (Waypoint waypoint2 : this.waypoints) {
            Waypoint waypoint3;
            waypoint = waypoint2;
            double d = waypoint.getDistance(waypoint3 = waypoint);
            if (!(d > (double)0.2f) || waypoint.getTime() == null) continue;
            this.exStop += waypoint.getDuration(waypoint3);
        }
    }

    private void updateLength() {
        this.lengthMeters = 0.0;
        Waypoint waypoint = this.getStart();
        for (Waypoint waypoint2 : this.waypoints) {
            Waypoint waypoint3 = waypoint;
            waypoint = waypoint2;
            this.lengthMeters += waypoint.getDistance(waypoint3);
        }
    }

    private void updateMaxSpeed() {
        this.maxSpeedMps = 0.0;
        int n = 5;
        if (this.getNumPts() <= n) {
            return;
        }
        Waypoint waypoint = this.getStart();
        Waypoint waypoint2 = this.waypoints.get(n);
        for (int i = n; i < this.getNumPts(); ++i) {
            long l;
            double d;
            Comparable<Date> comparable;
            waypoint2 = this.waypoints.get(i);
            waypoint = this.waypoints.get(i - n);
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                comparable = this.waypoints.get(i - j);
                Waypoint waypoint3 = this.waypoints.get(i - j - 1);
                d2 += ((Waypoint)comparable).getDistance(waypoint3);
            }
            Date date = waypoint.getTime();
            comparable = waypoint2.getTime();
            if (date == null || comparable == null || Double.isNaN(d = d2 / (double)(l = (long)((double)(((Date)comparable).getTime() - date.getTime()) / 1000.0))) || Double.isInfinite(d)) continue;
            this.maxSpeedMps = Math.max(this.maxSpeedMps, d2 / (double)l);
        }
    }

    public void updateEleProps() {
        this.eleStartMeters = this.getStart().getEle();
        this.eleEndMeters = this.getEnd().getEle();
        this.eleMinMeters = 2.147483647E9;
        this.eleMaxMeters = -2.147483648E9;
        this.grossRiseMeters = 0.0;
        this.grossFallMeters = 0.0;
        this.riseTime = 0L;
        this.fallTime = 0L;
        Waypoint waypoint = this.getStart();
        for (Waypoint waypoint2 : this.waypoints) {
            Waypoint waypoint3 = waypoint;
            waypoint = waypoint2;
            if (waypoint.getEle() > waypoint3.getEle()) {
                this.grossRiseMeters += waypoint.getEle() - waypoint3.getEle();
                if (waypoint.getTime() != null && waypoint3.getTime() != null) {
                    this.riseTime += waypoint.getTime().getTime() - waypoint3.getTime().getTime();
                }
            } else if (waypoint.getEle() < waypoint3.getEle()) {
                this.grossFallMeters += waypoint3.getEle() - waypoint.getEle();
                if (waypoint.getTime() != null && waypoint3.getTime() != null) {
                    this.fallTime += waypoint.getTime().getTime() - waypoint3.getTime().getTime();
                }
            }
            this.eleMinMeters = Math.min(this.eleMinMeters, waypoint.getEle());
            this.eleMaxMeters = Math.max(this.eleMaxMeters, waypoint.getEle());
        }
        this.fallTime /= 1000L;
        this.riseTime /= 1000L;
    }

    private void updateBounds() {
        this.minLat = 86.0;
        this.maxLat = -86.0;
        this.minLon = 180.0;
        this.maxLon = -180.0;
        for (Waypoint waypoint : this.waypoints) {
            this.minLat = Math.min(this.minLat, waypoint.getLat());
            this.minLon = Math.min(this.minLon, waypoint.getLon());
            this.maxLat = Math.max(this.maxLat, waypoint.getLat());
            this.maxLon = Math.max(this.maxLon, waypoint.getLon());
        }
    }

    private void updateStartEnd() {
        this.startTime = this.waypoints.get(0).getTime();
        this.endTime = this.waypoints.size() > 1 ? this.waypoints.get(this.waypoints.size() - 1).getTime() : this.startTime;
    }

    @Override
    public int compareTo(WaypointGroup waypointGroup) {
        if (this.getStartTime() == null || waypointGroup.getStartTime() == null) {
            return 0;
        }
        return this.getStartTime().compareTo(waypointGroup.getStartTime());
    }

    public Enumeration<TreeNode> children() {
        ArrayList<Marker> arrayList = null;
        if (this.wptGrpType == WptGrpType.WAYPOINTS) {
            arrayList = new ArrayList<Marker>();
            for (int i = 0; i < this.waypoints.size(); ++i) {
                arrayList.add((Marker)this.waypoints.get(i));
            }
            return Collections.enumeration(arrayList);
        }
        return null;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.wptGrpType == WptGrpType.WAYPOINTS;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return (Marker)this.waypoints.get(n);
    }

    @Override
    public int getChildCount() {
        if (this.wptGrpType == WptGrpType.WAYPOINTS) {
            return this.waypoints.size();
        }
        return 0;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        if (this.wptGrpType == WptGrpType.WAYPOINTS) {
            return this.waypoints.indexOf(treeNode);
        }
        return 0;
    }

    @Override
    public boolean isLeaf() {
        return this.wptGrpType != WptGrpType.WAYPOINTS;
    }

    public static enum WptGrpType {
        WAYPOINTS,
        ROUTE,
        TRACKSEG;

    }
}

