/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpxpanel;

import java.awt.Color;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.tree.TreeNode;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.GPXObjectCommon;
import org.gpsmaster.gpxpanel.WaypointGroup;

public class Route
extends GPXObjectCommon {
    protected int number;
    protected String type;
    private WaypointGroup path;

    public Route(Color color) {
        super(color);
        this.path = new WaypointGroup(this.color, WaypointGroup.WptGrpType.ROUTE);
        this.path.setParent(this);
    }

    public Route(Route route) {
        this.path = new WaypointGroup(route.path);
        this.path.setParent(this);
        this.minMaxExtensions = new HashMap<String, GPXObject.ExtensionMeta>(route.getMinMaxExtensions());
    }

    @Override
    public String toString() {
        String string = "Route";
        if (this.name != null && !this.name.equals("")) {
            string = string.concat(" - " + this.name);
        }
        return string;
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        this.path.setColor(color);
    }

    public WaypointGroup getPath() {
        return this.path;
    }

    public int getNumPts() {
        return this.path.getNumPts();
    }

    @Override
    public void updateAllProperties() {
        this.path.updateAllProperties();
        this.duration = this.path.getDuration();
        this.maxSpeedMps = this.path.getMaxSpeedMps();
        this.lengthMeters = this.path.getLengthMeters();
        this.eleStartMeters = this.path.getEleStartMeters();
        this.eleEndMeters = this.path.getEleEndMeters();
        this.eleMinMeters = this.path.getEleMinMeters();
        this.eleMaxMeters = this.path.getEleMaxMeters();
        this.grossRiseMeters = this.path.getGrossRiseMeters();
        this.grossFallMeters = this.path.getGrossFallMeters();
        this.fallTime = this.path.getFallTime();
        this.riseTime = this.path.getRiseTime();
        this.minLat = this.path.getMinLat();
        this.minLon = this.path.getMinLon();
        this.maxLat = this.path.getMaxLat();
        this.maxLon = this.path.getMaxLon();
        if (0 != this.path.minMaxExtensions.size()) {
            for (String string : this.path.getMinMaxExtensions().keySet()) {
                GPXObject.ExtensionMeta extensionMeta = this.path.getMinMaxExtensions().get(string);
                GPXObject.ExtensionMeta extensionMeta2 = (GPXObject.ExtensionMeta)this.minMaxExtensions.get(string);
                if (null == extensionMeta2) {
                    extensionMeta2 = new GPXObject.ExtensionMeta();
                    extensionMeta2.name = string;
                    this.minMaxExtensions.put(string, extensionMeta2);
                }
                extensionMeta2.values.addAll(extensionMeta.values);
            }
        }
        this.extToColor();
    }

    public Enumeration<TreeNode> children() {
        return null;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return 0;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }
}

