/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpxpanel;

import com.topografix.gpx._1._1.BoundsType;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.xml.bind.annotation.XmlElement;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.GpxMetadata;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;

public class GPXFile
extends GPXObject {
    private String creator;
    private GpxMetadata metadata;
    private WaypointGroup waypointGroup;
    private List<Route> routes = new ArrayList<Route>();
    private List<Track> tracks = new ArrayList<Track>();
    private List<String> extPrefixes = new ArrayList<String>();
    private long dbId = -1L;

    public GPXFile() {
        super(true);
        this.metadata = new GpxMetadata();
        this.metadata.setBounds(new BoundsType());
        this.trackPtsVisible = false;
        this.creator = "GpsMaster 0.63.31";
        this.waypointGroup = new WaypointGroup(this.color, WaypointGroup.WptGrpType.WAYPOINTS);
        this.waypointGroup.setParent(this);
        this.extPrefixes.add("gpsm");
    }

    public GPXFile(String string) {
        this();
        if (!string.equals("")) {
            this.metadata.setName(string);
        }
    }

    public GPXFile(GPXFile gPXFile) {
        super(gPXFile);
        this.creator = gPXFile.creator;
        this.metadata = gPXFile.metadata;
        this.waypointGroup = new WaypointGroup(gPXFile.waypointGroup);
        for (Track gPXObjectCommon : gPXFile.tracks) {
            this.tracks.add(new Track(gPXObjectCommon));
        }
        for (Route route : gPXFile.routes) {
            this.routes.add(new Route(route));
        }
    }

    public long getNumTrackPts() {
        long l = 0L;
        for (Track track : this.tracks) {
            l += track.getNumPts();
        }
        return l;
    }

    public long getNumRoutePts() {
        long l = 0L;
        for (Route route : this.routes) {
            l += (long)route.getNumPts();
        }
        return l;
    }

    public long getNumWayPts() {
        return this.waypointGroup.getNumPts();
    }

    @Override
    public void setColor(Color color) {
        super.setColor(color);
        this.waypointGroup.setColor(color);
        for (Route gPXObjectCommon : this.routes) {
            gPXObjectCommon.setColor(color);
        }
        for (Track track : this.tracks) {
            track.setColor(color);
        }
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String string) {
        this.creator = string;
    }

    @XmlElement
    public GpxMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public String getName() {
        return this.metadata.getName();
    }

    @Override
    public void setName(String string) {
        this.metadata.setName(string);
    }

    @Override
    public String getDesc() {
        return this.metadata.getDesc();
    }

    @Override
    public void setDesc(String string) {
        this.metadata.setDesc(string);
    }

    public WaypointGroup getWaypointGroup() {
        return this.waypointGroup;
    }

    @XmlElement(name="rte")
    public List<Route> getRoutes() {
        return this.routes;
    }

    public void addTrack(Track track) {
        track.setParent(this);
        this.tracks.add(track);
    }

    public Route addRoute() {
        Route route = new Route(this.color);
        route.setParent(this);
        route.setName(this.metadata.getName());
        this.routes.add(route);
        return route;
    }

    public void addRoute(Route route) {
        route.setParent(this);
        this.routes.add(route);
    }

    @XmlElement(name="trk")
    public List<Track> getTracks() {
        return this.tracks;
    }

    @Override
    public double getMinLat() {
        return this.metadata.getBounds().getMinlat().doubleValue();
    }

    @Override
    public double getMinLon() {
        return this.metadata.getBounds().getMinlon().doubleValue();
    }

    @Override
    public double getMaxLat() {
        return this.metadata.getBounds().getMaxlat().doubleValue();
    }

    @Override
    public double getMaxLon() {
        return this.metadata.getBounds().getMaxlon().doubleValue();
    }

    public String toString() {
        return this.metadata.getName();
    }

    public void addExtensionPrefix(String string) {
        if (!this.extPrefixes.contains(string)) {
            this.extPrefixes.add(string);
        }
    }

    public List<String> getExtensionPrefixes() {
        return this.extPrefixes;
    }

    @Override
    public void updateAllProperties() {
        Waypoint waypoint;
        this.lengthMeters = 0.0;
        this.duration = 0L;
        this.maxSpeedMps = 0.0;
        this.riseTime = 0L;
        this.fallTime = 0L;
        this.grossRiseMeters = 0.0;
        this.grossFallMeters = 0.0;
        if (this.waypointGroup.getWaypoints().size() > 1) {
            this.waypointGroup.updateAllProperties();
        }
        for (Route object2 : this.routes) {
            object2.updateAllProperties();
        }
        for (Track track : this.tracks) {
            track.updateAllProperties();
        }
        this.minLat = 86.0;
        this.maxLat = -86.0;
        this.minLon = 180.0;
        this.maxLon = -180.0;
        this.eleMinMeters = 2.147483647E9;
        this.eleMaxMeters = -2.147483648E9;
        for (Route route : this.routes) {
            this.minLat = Math.min(this.minLat, route.getMinLat());
            this.minLon = Math.min(this.minLon, route.getMinLon());
            this.maxLat = Math.max(this.maxLat, route.getMaxLat());
            this.maxLon = Math.max(this.maxLon, route.getMaxLon());
        }
        for (Track track : this.tracks) {
            this.minLat = Math.min(this.minLat, track.getMinLat());
            this.minLon = Math.min(this.minLon, track.getMinLon());
            this.maxLat = Math.max(this.maxLat, track.getMaxLat());
            this.maxLon = Math.max(this.maxLon, track.getMaxLon());
            this.eleMinMeters = Math.min(this.eleMinMeters, track.getEleMinMeters());
            this.eleMaxMeters = Math.max(this.eleMaxMeters, track.getEleMaxMeters());
            this.lengthMeters += track.getLengthMeters();
            this.duration += track.getDuration();
            this.exStop += track.getDurationExStop();
            this.maxSpeedMps = Math.max(this.maxSpeedMps, track.getMaxSpeedMps());
            this.grossRiseMeters += track.getGrossRiseMeters();
            this.grossFallMeters += track.getGrossFallMeters();
            this.riseTime += track.getRiseTime();
            this.fallTime += track.getFallTime();
            if (0 == track.minMaxExtensions.size()) continue;
            for (String string : track.getMinMaxExtensions().keySet()) {
                GPXObject.ExtensionMeta extensionMeta = track.getMinMaxExtensions().get(string);
                GPXObject.ExtensionMeta extensionMeta2 = (GPXObject.ExtensionMeta)this.minMaxExtensions.get(string);
                if (null == extensionMeta2) {
                    extensionMeta2 = new GPXObject.ExtensionMeta();
                    extensionMeta2.name = string;
                    this.minMaxExtensions.put(string, extensionMeta2);
                }
                extensionMeta2.values.addAll(extensionMeta.values);
            }
        }
        Object object3 = this.waypointGroup.getWaypoints().iterator();
        while (object3.hasNext()) {
            Waypoint waypoint2 = (Waypoint)object3.next();
            this.minLat = Math.min(this.minLat, waypoint2.getLat());
            this.minLon = Math.min(this.minLon, waypoint2.getLon());
            this.maxLat = Math.max(this.maxLat, waypoint2.getLat());
            this.maxLon = Math.max(this.maxLon, waypoint2.getLon());
        }
        if (this.tracks.size() > 0) {
            this.startTime = this.tracks.get(0).getStartTime();
            this.eleStartMeters = this.tracks.get(0).getEleStartMeters();
            this.endTime = this.tracks.get(this.tracks.size() - 1).getEndTime();
            this.eleEndMeters = this.tracks.get(this.tracks.size() - 1).getEleEndMeters();
        }
        if (this.metadata.getTime() == null && this.tracks.size() > 0 && ((Track)(object3 = this.tracks.get(0))).getTracksegs().size() > 0 && (waypoint = ((Track)object3).getTracksegs().get(0).getStart()) != null) {
            this.metadata.setTime(waypoint.getTime());
        }
        this.extToColor();
        this.metadata.getBounds().setMaxlat(new BigDecimal(this.maxLat));
        this.metadata.getBounds().setMaxlon(new BigDecimal(this.maxLon));
        this.metadata.getBounds().setMinlat(new BigDecimal(this.minLat));
        this.metadata.getBounds().setMinlon(new BigDecimal(this.minLon));
    }

    public long getDbId() {
        return this.dbId;
    }

    public void setDbId(long l) {
        this.dbId = l;
    }

    public Enumeration<TreeNode> children() {
        return Collections.enumeration(this.childList());
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return this.childList().get(n);
    }

    @Override
    public int getChildCount() {
        int n = 0;
        if (this.getWaypointGroup().getNumPts() > 0) {
            ++n;
        }
        n = n + this.tracks.size() + this.routes.size();
        return n;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.childList().indexOf(treeNode);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    private List<TreeNode> childList() {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        if (this.waypointGroup.getNumPts() > 0) {
            arrayList.add(this.waypointGroup);
        }
        arrayList.addAll(this.routes);
        arrayList.addAll(this.tracks);
        return arrayList;
    }
}

