/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpsloader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.ValidationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.gpsloader.GpsLoader;
import org.gpsmaster.gpxpanel.GPXExtension;
import org.gpsmaster.gpxpanel.GPXFile;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class XmlLoader
extends GpsLoader {
    int depth = 0;
    XMLStreamWriter writer = null;
    DateTimeFormatter formatter = ISODateTimeFormat.dateTimeNoMillis().withZoneUTC();
    protected String xsdResource = "";
    protected final Locale fileLocale = new Locale("en", "US");

    @Override
    public abstract GPXFile load(InputStream var1, String var2) throws Exception;

    @Override
    public boolean canValidate() {
        return true;
    }

    @Override
    public void validate(InputStream inputStream) throws ValidationException {
        if (!this.xsdResource.isEmpty()) {
            URL uRL = GpsMaster.class.getResource(this.xsdResource);
            StreamSource streamSource = new StreamSource(inputStream);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = null;
            try {
                schema = schemaFactory.newSchema(uRL);
                Validator validator = schema.newValidator();
                validator.validate(streamSource);
            }
            catch (SAXException sAXException) {
                throw new ValidationException(sAXException.getMessage());
            }
            catch (IOException iOException) {
                throw new ValidationException(iOException.getMessage());
            }
        }
    }

    protected String getSubValue(Element element, String string) {
        String string2 = null;
        try {
            NodeList nodeList = element.getElementsByTagName(string).item(0).getChildNodes();
            Node node = nodeList.item(0);
            string2 = node.getTextContent();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return string2;
    }

    protected Element getSubElement(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || (element2 = (Element)node).getNodeName() != string) continue;
            return element2;
        }
        return null;
    }

    protected List<Element> getSubElementsByTagName(Element element, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getElementsByTagName(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || (element2 = (Element)node).getNodeName() != string) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    protected List<Element> getSubElements(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            arrayList.add(element2);
        }
        return arrayList;
    }

    protected void writeAttribute(String string, double d) throws XMLStreamException {
        this.writer.writeAttribute(string, String.format(this.fileLocale, "%.8f", d));
    }

    protected void writeSimpleElement(String string, double d) throws XMLStreamException {
        this.writeSimpleElement(string, String.format(this.fileLocale, "%.8f", d));
    }

    protected void writeSimpleElement(String string, int n) throws XMLStreamException {
        this.writeSimpleElement(string, Integer.toString(n));
    }

    protected void writeSimpleElement(String string, Date date) throws XMLStreamException {
        if (date != null) {
            this.writeSimpleElement(string, this.formatter.print((ReadableInstant)new DateTime((Object)date)));
        }
    }

    protected void writeSimpleElement(String string, String string2) throws XMLStreamException {
        if (string2 != null && !string2.isEmpty()) {
            this.writer.writeCharacters("\n");
            this.writer.writeStartElement(string);
            this.writer.writeCharacters(string2);
            this.writer.writeEndElement();
        }
    }

    protected void writeSubtree(GPXExtension gPXExtension) throws XMLStreamException {
        if (gPXExtension.getExtensions().size() > 0) {
            this.writeStartElement(gPXExtension.getKey());
            for (GPXExtension gPXExtension2 : gPXExtension.getExtensions()) {
                this.writeSubtree(gPXExtension2);
            }
            this.writeEndElement();
        } else {
            this.writeSimpleElement(gPXExtension.getKey(), gPXExtension.getValue());
        }
    }

    protected void writeStartElement(String string) throws XMLStreamException {
        this.writer.writeCharacters("\n");
        this.writer.writeStartElement(string);
        ++this.depth;
    }

    protected void writeEndElement() throws XMLStreamException {
        this.writer.writeCharacters("\n");
        this.writer.writeEndElement();
        --this.depth;
    }

    public void printTree(GPXExtension gPXExtension, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("___");
        }
        System.out.println(gPXExtension.getKey() + " = " + gPXExtension.getValue());
        for (GPXExtension gPXExtension2 : gPXExtension.getExtensions()) {
            this.printTree(gPXExtension2, n + 1);
        }
    }
}

