/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpsloader;

import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.NotBoundException;
import javax.xml.bind.ValidationException;
import net.sf.marineapi.nmea.event.SentenceEvent;
import net.sf.marineapi.nmea.event.SentenceListener;
import net.sf.marineapi.nmea.io.SentenceReader;
import net.sf.marineapi.nmea.parser.DataNotAvailableException;
import net.sf.marineapi.nmea.sentence.GGASentence;
import net.sf.marineapi.nmea.sentence.GSASentence;
import net.sf.marineapi.nmea.sentence.RMCSentence;
import net.sf.marineapi.nmea.sentence.Sentence;
import net.sf.marineapi.nmea.sentence.SentenceId;
import net.sf.marineapi.nmea.sentence.WPLSentence;
import net.sf.marineapi.nmea.util.Date;
import net.sf.marineapi.nmea.util.Time;
import org.gpsmaster.gpsloader.GpsLoader;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.joda.time.DateTime;

public class NmeaLoader
extends GpsLoader
implements SentenceListener {
    private SentenceReader reader = null;
    private Waypoint wpt = null;
    private WaypointGroup trackSeg = null;
    private Date gpsDate = null;
    private boolean running = false;

    public NmeaLoader() {
        this.extensions.add("nmea");
    }

    @Override
    public boolean canValidate() {
        return false;
    }

    @Override
    public void validate(InputStream inputStream) throws ValidationException, NotBoundException {
    }

    @Override
    public GPXFile load(InputStream inputStream, String string) throws Exception {
        this.gpx = new GPXFile();
        this.gpx.addExtensionPrefix("nmea");
        Track track = new Track(this.gpx.getColor());
        this.gpx.addTrack(track);
        this.trackSeg = track.addTrackseg();
        this.reader = new SentenceReader(inputStream);
        this.reader.addSentenceListener((SentenceListener)this, SentenceId.GGA);
        this.reader.addSentenceListener((SentenceListener)this, SentenceId.GSA);
        this.reader.addSentenceListener((SentenceListener)this, SentenceId.RMC);
        this.reader.addSentenceListener((SentenceListener)this, SentenceId.GLL);
        this.reader.addSentenceListener((SentenceListener)this, SentenceId.VTG);
        this.reader.addSentenceListener((SentenceListener)this, SentenceId.WPL);
        this.reader.addSentenceListener((SentenceListener)this, SentenceId.MTW);
        this.reader.addSentenceListener((SentenceListener)this, SentenceId.DPT);
        this.reader.addSentenceListener((SentenceListener)this, SentenceId.DBT);
        this.running = true;
        this.reader.start();
        while (this.running) {
            Thread.sleep(1000L, 0);
        }
        return this.gpx;
    }

    @Override
    public void loadCumulative(InputStream inputStream) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(GPXFile gPXFile, OutputStream outputStream) {
    }

    @Override
    public void readingPaused() {
        this.running = false;
        System.out.println("-- Paused --");
    }

    @Override
    public void readingStarted() {
    }

    @Override
    public void readingStopped() {
        this.running = false;
        System.out.println("-- Stopped --");
    }

    @Override
    public void sentenceRead(SentenceEvent sentenceEvent) {
        Sentence sentence = sentenceEvent.getSentence();
        String string = sentence.getSentenceId();
        System.out.println(sentence.toString());
        if (string.equals("GGA")) {
            this.procSentence((GGASentence)sentenceEvent.getSentence());
        } else if (string.equals("GSA")) {
            this.procSentence((GSASentence)sentenceEvent.getSentence());
        } else if (string.equals("RMC")) {
            this.procSentence((RMCSentence)sentenceEvent.getSentence());
        } else if (!string.equals("GLL")) {
            if (string.equals("WPL")) {
                this.procSentence((WPLSentence)sentenceEvent.getSentence());
            } else if (string.equals("AAM")) {
                // empty if block
            }
        }
    }

    private void procSentence(GGASentence gGASentence) {
        this.wpt = new Waypoint(gGASentence.getPosition().getLatitude(), gGASentence.getPosition().getLongitude());
        this.wpt.setEle(gGASentence.getAltitude());
        if (this.gpsDate != null) {
            Time time = gGASentence.getTime();
            DateTime dateTime = new DateTime(this.gpsDate.getYear(), this.gpsDate.getMonth(), this.gpsDate.getDay(), time.getHour(), time.getMinutes(), (int)time.getSeconds());
            this.wpt.setTime(dateTime.toDate());
            this.trackSeg.addWaypoint(this.wpt);
        }
        this.wpt.setHdop(gGASentence.getHorizontalDOP());
        this.wpt.setSat(gGASentence.getSatelliteCount());
        this.wpt.setGeoidheight(gGASentence.getGeoidalHeight());
        switch (gGASentence.getFixQuality()) {
            case NORMAL: {
                this.wpt.setFix("sps");
                break;
            }
            default: {
                this.wpt.setFix(gGASentence.getFixQuality().toString().toLowerCase());
            }
        }
    }

    private void procSentence(GSASentence gSASentence) {
        try {
            this.wpt.setHdop(gSASentence.getHorizontalDOP());
        }
        catch (DataNotAvailableException dataNotAvailableException) {
            // empty catch block
        }
        try {
            this.wpt.setVdop(gSASentence.getVerticalDOP());
        }
        catch (DataNotAvailableException dataNotAvailableException) {
            // empty catch block
        }
        try {
            this.wpt.setPdop(gSASentence.getPositionDOP());
        }
        catch (DataNotAvailableException dataNotAvailableException) {
            // empty catch block
        }
    }

    private void procSentence(RMCSentence rMCSentence) {
        try {
            this.wpt.setMagvar(rMCSentence.getVariation());
        }
        catch (DataNotAvailableException dataNotAvailableException) {
            // empty catch block
        }
        try {
            this.wpt.getExtension().add("heading", Double.toString(rMCSentence.getCorrectedCourse()));
        }
        catch (DataNotAvailableException dataNotAvailableException) {
            // empty catch block
        }
        try {
            this.wpt.getExtension().add("speed", Double.toString(rMCSentence.getSpeed()));
        }
        catch (DataNotAvailableException dataNotAvailableException) {
            // empty catch block
        }
        this.gpsDate = rMCSentence.getDate();
    }

    private void procSentence(WPLSentence wPLSentence) {
        Waypoint waypoint = new Waypoint(wPLSentence.getWaypoint().getLatitude(), wPLSentence.getWaypoint().getLongitude());
        waypoint.setName(wPLSentence.getWaypoint().getDescription());
        this.gpx.getWaypointGroup().addWaypoint(waypoint);
    }
}

