/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpsloader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gpsmaster.gpsloader.XmlLoader;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.marker.WaypointMarker;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KmlLoader
extends XmlLoader {
    public KmlLoader() {
        this.extensions.add("kml");
        this.extensions.add("kmz");
    }

    public void open(File file) {
        this.file = file;
        this.isOpen = true;
    }

    private Waypoint parseCoordinateLine(String string) {
        double d;
        String[] stringArray = string.split(",");
        if (stringArray.length < 2) {
            return null;
        }
        double d2 = Double.parseDouble(stringArray[0]);
        double d3 = Double.parseDouble(stringArray[1]);
        Waypoint waypoint = new Waypoint(d3, d2);
        if (!stringArray[2].isEmpty() && (d = Double.parseDouble(stringArray[2])) > 0.0) {
            waypoint.setEle(d);
        }
        return waypoint;
    }

    private void parsePlacemark(Element element) {
        Track track;
        Element element2 = null;
        element2 = this.getSubElement(element, "Point");
        if (element2 != null) {
            this.parseWaypoint(this.gpx.getWaypointGroup().getWaypoints(), element);
        }
        if ((element2 = this.getSubElement(element, "LineString")) != null) {
            track = new Track(this.gpx.getColor());
            this.parseTrack(track, element);
            this.gpx.addTrack(track);
        }
        if ((element2 = this.getSubElement(element, "gx:Track")) != null) {
            track = new Track(this.gpx.getColor());
            this.parseGxTrack(track, element);
            this.gpx.getTracks().add(track);
        }
        if ((element2 = this.getSubElement(element, "MultiGeometry")) != null) {
            track = new Track(this.gpx.getColor());
            this.parseTrack(track, element);
            this.gpx.getTracks().add(track);
        }
    }

    private void parseWaypoint(List<Waypoint> list, Element element) {
        String string;
        String string2 = this.getSubValue(element, "coordinates");
        Waypoint waypoint = this.parseCoordinateLine(string2);
        WaypointMarker waypointMarker = new WaypointMarker(waypoint);
        String string3 = this.getSubValue(element, "name");
        if (string3 != null) {
            waypointMarker.setName(string3);
        }
        if ((string = this.getSubValue(element, "description")) != null) {
            waypointMarker.setDesc(string);
        }
        list.add(waypointMarker);
    }

    private void parseCoordinateSection(WaypointGroup waypointGroup, Element element) {
        Element element2 = this.getSubElement(element, "LineString");
        Element element3 = this.getSubElement(element2, "coordinates");
        String string = element3.getTextContent();
        for (String string2 : string.split("\\s+")) {
            Waypoint waypoint = this.parseCoordinateLine(string2);
            if (waypoint == null) continue;
            waypointGroup.addWaypoint(waypoint);
        }
    }

    private void parseGxCoordinates(WaypointGroup waypointGroup, Element element) {
        Element element2 = this.getSubElement(element, "gx:Track");
        NodeList nodeList = element2.getElementsByTagName("when");
        NodeList nodeList2 = element2.getElementsByTagName("gx:coord");
        if (nodeList.getLength() != nodeList2.getLength()) {
            throw new IllegalArgumentException("coordinates & time count mismatch");
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = nodeList.item(i).getTextContent();
            String string2 = nodeList2.item(i).getTextContent();
            String[] stringArray = string2.split("[ ]+");
            double d = Double.parseDouble(stringArray[0]);
            double d2 = Double.parseDouble(stringArray[1]);
            double d3 = Double.parseDouble(stringArray[2]);
            Waypoint waypoint = new Waypoint(d2, d);
            if (d3 > 0.0) {
                waypoint.setEle(d3);
            }
            DateTime dateTime = ISODateTimeFormat.dateTimeNoMillis().parseDateTime(string);
            waypoint.setTime(dateTime.toDate());
            waypointGroup.addWaypoint(waypoint);
        }
    }

    private void parseTrack(Track track, Element element) {
        track.setName(this.getSubValue(element, "name"));
        String string = this.getSubValue(element, "description");
        if (string != null) {
            track.setDesc(string);
        }
        WaypointGroup waypointGroup = new WaypointGroup(track.getColor(), WaypointGroup.WptGrpType.TRACKSEG);
        Element element2 = this.getSubElement(element, "MultiGeometry");
        if (element2 == null) {
            this.parseCoordinateSection(waypointGroup, element);
        } else {
            this.parseCoordinateSection(waypointGroup, element2);
        }
        if (waypointGroup.getWaypoints().size() > 0) {
            track.addTrackseg(waypointGroup);
        }
    }

    private void parseGxTrack(Track track, Element element) {
        track.setName(this.getSubValue(element, "name"));
        String string = this.getSubValue(element, "description");
        if (string != null) {
            track.setDesc(string);
        }
        WaypointGroup waypointGroup = new WaypointGroup(track.getColor(), WaypointGroup.WptGrpType.TRACKSEG);
        this.parseGxCoordinates(waypointGroup, element);
        if (waypointGroup.getWaypoints().size() > 0) {
            track.addTrackseg(waypointGroup);
        }
    }

    private void scanForPlacemark(Element element) {
        for (Element element2 : this.getSubElements(element)) {
            if (element2.getTagName().equals("Placemark")) {
                this.parsePlacemark(element2);
                continue;
            }
            if (!element2.getTagName().equals("Folder")) continue;
            this.scanForPlacemark(element2);
        }
    }

    @Override
    public GPXFile load(InputStream inputStream, String string) throws Exception {
        ZipInputStream zipInputStream = null;
        ZipEntry zipEntry = null;
        this.gpx = new GPXFile();
        if (string.equals("kml")) {
            this.parseKml(inputStream);
        } else if (string.equals("kmz")) {
            zipInputStream = new ZipInputStream(inputStream);
            Boolean bl = false;
            while (!bl.booleanValue()) {
                zipEntry = zipInputStream.getNextEntry();
                if (zipEntry == null || !zipEntry.getName().equals("doc.kml")) continue;
                bl = true;
            }
            if (!bl.booleanValue()) {
                throw new FileNotFoundException("KMZ file does not contain doc.kml");
            }
            this.parseKml(zipInputStream);
            zipInputStream.close();
        } else {
            throw new UnsupportedOperationException("unsupported type " + string);
        }
        return this.gpx;
    }

    private void parseKml(InputStream inputStream) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        Element element = document.getDocumentElement();
        Element element2 = this.getSubElement(element, "Document");
        if (element2 == null) {
            throw new NoSuchElementException("Document");
        }
        String string = this.getSubValue(element2, "name");
        this.gpx.getMetadata().setName(string);
        String string2 = this.getSubValue(element2, "description");
        this.gpx.getMetadata().setDesc(string2);
        this.scanForPlacemark(element2);
    }

    @Override
    public void loadCumulative(InputStream inputStream) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(GPXFile gPXFile, OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    public void save(GPXFile gPXFile, File file) {
        throw new UnsupportedOperationException();
    }
}

