/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpsloader;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.NotBoundException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.ValidationException;
import org.gpsmaster.gpsloader.LoaderConfig;
import org.gpsmaster.gpxpanel.GPXFile;

public abstract class GpsLoader {
    protected boolean isDefault = false;
    protected boolean isOpen = false;
    protected boolean isAdding = false;
    protected File file = null;
    protected GPXFile gpx = null;
    protected List<String> extensions = new ArrayList<String>();
    protected Hashtable<File, GPXFile> gpxFiles = new Hashtable();
    protected LoaderConfig loaderConfig = null;
    protected Locale numLocale = new Locale("en", "US");

    public boolean isDefaultLoader() {
        return this.isDefault;
    }

    public boolean isCumulative() {
        return this.isAdding;
    }

    public void setConfig(LoaderConfig loaderConfig) {
        this.loaderConfig = loaderConfig;
    }

    public Hashtable<File, GPXFile> getFiles() {
        return this.gpxFiles;
    }

    public abstract GPXFile load(InputStream var1, String var2) throws Exception;

    public abstract void loadCumulative(InputStream var1) throws Exception;

    public abstract void save(GPXFile var1, OutputStream var2);

    public abstract boolean canValidate();

    public abstract void validate(InputStream var1) throws ValidationException, NotBoundException;

    public List<String> getLoadFormats() {
        return this.extensions;
    }

    public void clear() {
        this.gpxFiles.clear();
    }
}

