/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpsloader;

import eu.fuegenstein.messagecenter.MessageCenter;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.swing.TransferHandler;
import org.gpsmaster.filehub.FileHub;
import org.gpsmaster.filehub.FileItem;

public class FileDropHandler
extends TransferHandler {
    private static final long serialVersionUID = 7547034606181097621L;
    private static DataFlavor _uriListFlavour = null;
    private FileHub fileHub = null;
    private MessageCenter msg = null;

    public FileDropHandler(FileHub fileHub, MessageCenter messageCenter) {
        this.fileHub = fileHub;
        this.msg = messageCenter;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        boolean bl = transferSupport.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
        if (bl) {
            transferSupport.setDropAction(1);
        }
        return bl;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        Object object;
        if (!this.canImport(transferSupport)) {
            return false;
        }
        boolean bl = false;
        try {
            object = (List)transferSupport.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            bl = true;
            String[] stringArray = object.iterator();
            while (stringArray.hasNext()) {
                File file = (File)stringArray.next();
                this.addFile(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            try {
                object = transferSupport.getTransferable().getTransferData(_uriListFlavour).toString();
                bl = true;
                for (String string : ((String)object).split("[\n\r]+")) {
                    if (string == null || string.equals("")) continue;
                    File file = new File(new URI(string));
                    this.addFile(file);
                }
            }
            catch (Exception exception) {
                this.msg.error(exception);
                return false;
            }
        }
        this.fileHub.run();
        return true;
    }

    private void addFile(File file) {
        try {
            if (file.exists() && file.canRead()) {
                if (file.isFile()) {
                    FileItem fileItem = new FileItem(file);
                    this.fileHub.getItemSource().getItems().add(fileItem);
                } else if (file.isDirectory()) {
                    for (String string : file.list()) {
                        this.addFile(new File(file, string));
                    }
                }
            }
        }
        catch (Exception exception) {
            this.msg.error(exception);
        }
    }

    static {
        try {
            _uriListFlavour = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

