/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.gpsloader;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.lang.GeoLocation;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDescriptor;
import com.drew.metadata.exif.GpsDirectory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gpsmaster.gpsloader.GpsLoader;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.marker.PhotoMarker;

public class ExifLoader
extends GpsLoader {
    GPXFile gpx = null;

    public ExifLoader() {
        this.extensions.add("jpg");
        this.extensions.add("jpeg");
        this.isAdding = true;
    }

    @Override
    public void loadCumulative(InputStream inputStream) throws ImageProcessingException, IOException, MetadataException {
        if (this.gpx == null) {
            this.setupGpx();
        }
        this.readExif(inputStream);
    }

    @Override
    public GPXFile load(InputStream inputStream, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void save(GPXFile gPXFile, OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canValidate() {
        return false;
    }

    @Override
    public void validate(InputStream inputStream) {
    }

    private void readExif(InputStream inputStream) throws ImageProcessingException, IOException, MetadataException {
        Directory directory2;
        PhotoMarker photoMarker = null;
        String string = "";
        String string2 = "";
        Date date = null;
        String string3 = "";
        Metadata metadata = ImageMetadataReader.readMetadata((BufferedInputStream)new BufferedInputStream(inputStream), (boolean)true);
        GpsDirectory gpsDirectory = null;
        GpsDescriptor gpsDescriptor = null;
        GeoLocation geoLocation = null;
        try {
            gpsDirectory = (GpsDirectory)metadata.getDirectory(GpsDirectory.class);
            gpsDescriptor = new GpsDescriptor(gpsDirectory);
            geoLocation = gpsDirectory.getGeoLocation();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("File does not contain GPS data");
        }
        photoMarker = new PhotoMarker(geoLocation.getLatitude(), geoLocation.getLongitude());
        photoMarker.setName(this.file.getName());
        photoMarker.setDirectory(this.file.getPath());
        if (gpsDirectory.containsTag(6)) {
            photoMarker.setEle(gpsDirectory.getDouble(6));
        }
        for (Directory directory2 : metadata.getDirectories()) {
            for (Tag tag : directory2.getTags()) {
                photoMarker.addExifTag(tag);
            }
        }
        string = gpsDescriptor.getGpsTimeStampDescription();
        for (Directory directory2 : gpsDirectory.getTags()) {
            if (directory2.getTagName().equals("GPS Date Stamp")) {
                string2 = directory2.getDescription();
            }
            if (!directory2.getTagName().equals("GPS Time Stamp") && !directory2.getTagName().equals("GPS Time-Stamp")) continue;
            string = directory2.getDescription();
        }
        Object object = new SimpleDateFormat("yyyy:MM:dd k:mm:ss Z");
        try {
            date = ((DateFormat)object).parse(string2 + " " + string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        directory2 = (ExifIFD0Directory)metadata.getDirectory(ExifIFD0Directory.class);
        for (Tag tag : directory2.getTags()) {
            if (!tag.getTagName().equals("Date/Time") || date != null) continue;
            object = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
            try {
                date = ((DateFormat)object).parse(tag.getDescription());
            }
            catch (ParseException parseException) {}
        }
        if (date != null) {
            photoMarker.setTime(date);
        }
        if (!string3.isEmpty()) {
            photoMarker.setCmt(string3);
        }
        this.gpx.getWaypointGroup().getWaypoints().add(photoMarker);
    }

    private void setupGpx() {
        this.gpx = new GPXFile();
        this.gpx.getMetadata().setName("Geo-referenced Images");
        this.gpxFiles.put(new File("exif"), this.gpx);
    }

    @Override
    public void clear() {
        super.clear();
        this.gpx = null;
    }
}

