/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import eu.fuegenstein.swing.ExtendedTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gpsmaster.dialogs.GenericDialog;
import org.gpsmaster.dialogs.TransferableItemLogPanel;
import org.gpsmaster.dialogs.TransferableItemStatusTableModel;
import org.gpsmaster.dialogs.TransferableItemTableModel;
import org.gpsmaster.filehub.TransferableItem;

public class TransferStatusDialog
extends GenericDialog {
    private static final long serialVersionUID = -6893640537199180024L;
    private int logLevel = 2;
    private final double RESIZEWEIGHT = 0.66f;
    private TransferableItemLogPanel logPanel = null;
    private ExtendedTable itemTable = null;
    private TransferableItemTableModel tableModel = null;

    public TransferStatusDialog(JFrame jFrame) {
        super(jFrame);
        this.setIcon("/org/gpsmaster/icons/dialogs/", "state-warning.png");
        this.setup();
    }

    public void addItems(List<TransferableItem> list) {
        for (TransferableItem transferableItem : list) {
            this.tableModel.addItem(transferableItem);
        }
        this.itemTable.minimizeColumnWidth(0, 1);
        this.tableModel.fireTableDataChanged();
        if (this.tableModel.getRowCount() > 0) {
            this.itemTable.setRowSelectionInterval(0, 0);
        }
    }

    public List<TransferableItem> getItems() {
        return this.tableModel.getItemList();
    }

    @Override
    public void begin() {
        this.pack();
        this.setCenterLocation();
        this.setVisible(false);
    }

    @Override
    public String getTitle() {
        return "Transfer Status";
    }

    private void setup() {
        this.setLayout(new BorderLayout());
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setResizeWeight(0.66f);
        this.add((Component)jSplitPane, "Center");
        this.tableModel = new TransferableItemStatusTableModel();
        this.itemTable = new ExtendedTable(this.tableModel);
        this.itemTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!listSelectionEvent.getValueIsAdjusting() && (n = TransferStatusDialog.this.itemTable.getSelectedRowCount()) > 0) {
                    TransferableItem transferableItem = TransferStatusDialog.this.tableModel.getItem(TransferStatusDialog.this.itemTable.getSelectedRow());
                    TransferStatusDialog.this.logPanel.setLog(transferableItem.getLog());
                }
            }
        });
        this.itemTable.setFillsViewportHeight(true);
        this.itemTable.getColumnModel().getColumn(0).setPreferredWidth(20);
        jSplitPane.setTopComponent(new JScrollPane(this.itemTable));
        this.logPanel = new TransferableItemLogPanel();
        this.logPanel.setAutoHide(false);
        jSplitPane.setBottomComponent(this.logPanel);
        JPanel jPanel = new JPanel();
        this.add((Component)jPanel, "South");
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransferStatusDialog.this.tableModel.clear();
                TransferStatusDialog.this.tableModel.fireTableDataChanged();
                TransferStatusDialog.this.logPanel.setLog(null);
                TransferStatusDialog.this.firePropertyChange("logChanged", null, null);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Close");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransferStatusDialog.this.setVisible(false);
            }
        });
        jPanel.add(jButton2);
    }
}

