/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import eu.fuegenstein.messagecenter.MessageCenter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import org.gpsmaster.GenericAlgorithm;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.dialogs.GenericAlgorithmPanel;
import org.gpsmaster.dialogs.RadioButtonDialog;
import org.gpsmaster.timeshift.ClearTimestamps;
import org.gpsmaster.timeshift.LocalToUTC;
import org.gpsmaster.timeshift.Reverse;
import org.gpsmaster.timeshift.ShiftTime;
import org.gpsmaster.timeshift.TimeshiftAlgorithm;

public class TimeshiftDialog
extends RadioButtonDialog {
    private PropertyChangeListener changeListener = null;
    private ActionListener selectionListener = null;
    private List<TimeshiftAlgorithm> algorithms = new ArrayList<TimeshiftAlgorithm>();
    private TimeshiftAlgorithm selected = null;
    private JButton applyButton = null;

    public TimeshiftDialog(JFrame jFrame) {
        super(jFrame);
        this.setup();
    }

    public TimeshiftDialog(JFrame jFrame, MessageCenter messageCenter) {
        super(jFrame, messageCenter);
        this.setup();
    }

    @Override
    public void begin() {
        this.setGpxObject();
        this.setVisible(true);
    }

    @Override
    public void dispose() {
        GpsMaster.active.removePropertyChangeListener(this.changeListener);
        GpsMaster.active.repaintMap();
        super.dispose();
    }

    private void setGpxObject() {
        System.out.println("setGpxObject " + GpsMaster.active.getGroups().size());
        for (GenericAlgorithm genericAlgorithm : this.algorithms) {
            genericAlgorithm.clear();
            genericAlgorithm.setWaypointGroups(GpsMaster.active.getGroups());
        }
    }

    private void apply() {
        this.applyButton.setEnabled(false);
        this.selected.apply();
        GpsMaster.active.addUndoOperation(this.selected);
        GpsMaster.active.refresh();
        GpsMaster.active.repaintMap();
        this.makeAlgoList();
        this.applyButton.setEnabled(true);
    }

    private void makeAlgoList() {
        this.algorithms.clear();
        this.algorithms.add(new ShiftTime());
        this.algorithms.add(new LocalToUTC());
        this.algorithms.add(new ClearTimestamps());
        this.algorithms.add(new Reverse());
    }

    private void setup() {
        this.setIcon("/org/gpsmaster/icons/toolbar/", "timeshift.png");
        this.makeAlgoList();
        this.setDefaultCloseOperation(2);
        this.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("activeGpxObject") || string.equals("refreshGpx")) {
                    TimeshiftDialog.this.setGpxObject();
                }
            }
        };
        GpsMaster.active.addPropertyChangeListener(this.changeListener);
        this.selectionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (TimeshiftAlgorithm timeshiftAlgorithm : TimeshiftDialog.this.algorithms) {
                    if (!timeshiftAlgorithm.getName().equals(actionEvent.getActionCommand())) continue;
                    GenericAlgorithmPanel genericAlgorithmPanel = new GenericAlgorithmPanel(timeshiftAlgorithm);
                    ((JComponent)genericAlgorithmPanel).setBackground(TimeshiftDialog.this.backgroundColor);
                    TimeshiftDialog.this.setInfoPanel(genericAlgorithmPanel);
                    TimeshiftDialog.this.revalidate();
                    TimeshiftDialog.this.repaint();
                    TimeshiftDialog.this.selected = timeshiftAlgorithm;
                    System.out.println("selected = " + timeshiftAlgorithm.getName());
                    return;
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        for (TimeshiftAlgorithm timeshiftAlgorithm : this.algorithms) {
            JRadioButton jRadioButton = new JRadioButton(timeshiftAlgorithm.getName());
            jRadioButton.setBackground(this.backgroundColor);
            jRadioButton.addActionListener(this.selectionListener);
            this.radioPanel.add(jRadioButton);
            buttonGroup.add(jRadioButton);
            if (this.algorithms.indexOf(timeshiftAlgorithm) != 0) continue;
            jRadioButton.setSelected(true);
        }
        this.selected = this.algorithms.get(0);
        this.setInfoPanel(new GenericAlgorithmPanel(this.selected));
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimeshiftDialog.this.apply();
            }
        });
        this.buttonPanel.add(this.applyButton);
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TimeshiftDialog.this.dispose();
            }
        });
        this.buttonPanel.add(jButton);
        this.pack();
        this.setCenterLocation();
    }

    @Override
    public String getTitle() {
        return "Timeshift";
    }
}

