/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import eu.fuegenstein.messagecenter.MessageCenter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.TableModelEvent;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.dialogs.ExifTableModel;
import org.gpsmaster.dialogs.GenericDialog;
import org.gpsmaster.dialogs.ImageDisplay;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.marker.PhotoMarker;

public class ImageViewer
extends GenericDialog {
    private static final long serialVersionUID = 7056561782303771912L;
    private List<GPXFile> gpxFiles = null;
    private PropertyChangeListener changeListener = null;
    private JLabel filenameLabel = new JLabel();
    private ImageDisplay imageDisplay = null;
    private JTable exifTable = null;
    private ExifTableModel exifModel = new ExifTableModel();
    private List<PhotoMarker> markers = new ArrayList<PhotoMarker>();
    private PhotoMarker current = null;
    private JButton prevButton = new JButton();
    private JToggleButton centerButton = new JToggleButton();
    private JButton nextButton = new JButton();
    private JButton zoomButton = new JButton();

    public ImageViewer(JFrame jFrame, MessageCenter messageCenter) {
        super(jFrame, messageCenter);
    }

    @Override
    public void begin() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        Container container = this.getContentPane();
        Dimension dimension = new Dimension(640, 480);
        this.setMinimumSize(dimension);
        this.setTitle("View Image");
        this.setIconImage(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/marker/photo.png")).getImage());
        container.setLayout(new BorderLayout());
        this.filenameLabel = new JLabel();
        container.add((Component)this.filenameLabel, "North");
        jPanel2.setLayout(new BorderLayout());
        this.imageDisplay = new ImageDisplay();
        jPanel2.add((Component)this.imageDisplay, "Center");
        this.prevButton.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/dialogs/prev.png")));
        this.prevButton.setEnabled(false);
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ImageViewer.this.markers.indexOf(ImageViewer.this.current);
                if (n > 0) {
                    ImageViewer.this.showMarker((PhotoMarker)ImageViewer.this.markers.get(n - 1));
                    ImageViewer.this.setPrevNext();
                    ImageViewer.this.centerMap();
                }
            }
        });
        this.nextButton.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/dialogs/next.png")));
        this.nextButton.setEnabled(false);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ImageViewer.this.markers.indexOf(ImageViewer.this.current);
                if (n < ImageViewer.this.markers.size() - 1) {
                    ImageViewer.this.showMarker((PhotoMarker)ImageViewer.this.markers.get(n + 1));
                    ImageViewer.this.setPrevNext();
                    ImageViewer.this.centerMap();
                }
            }
        });
        this.zoomButton.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/dialogs/zoom-best-fit.png")));
        this.zoomButton.setToolTipText("Zoom Best Fit");
        this.zoomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ImageViewer.this.imageDisplay != null) {
                    ImageViewer.this.imageDisplay.zoomBestFitOrOne();
                }
            }
        });
        this.centerButton.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/dialogs/centreview.png")));
        this.centerButton.setToolTipText("Center Map");
        this.centerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageViewer.this.centerMap();
            }
        });
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.prevButton);
        jPanel3.add(this.centerButton);
        jPanel3.add(this.zoomButton);
        jPanel3.add(this.nextButton);
        jPanel2.add((Component)jPanel3, "South");
        jPanel.setLayout(new BorderLayout());
        this.exifTable = new JTable(this.exifModel);
        this.exifTable.getColumnModel().getColumn(0).setPreferredWidth(25);
        this.exifTable.getColumnModel().getColumn(1).setPreferredWidth(80);
        this.exifTable.getColumnModel().getColumn(2).setPreferredWidth(285);
        JScrollPane jScrollPane = new JScrollPane(this.exifTable);
        jPanel.add((Component)jScrollPane, "Center");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Image", jPanel2);
        jTabbedPane.addTab("EXIF", jPanel);
        container.add((Component)jTabbedPane, "Center");
        this.pack();
        this.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("refreshGpx") || string.equals("newGpx")) {
                    ImageViewer.this.refresh();
                    ImageViewer.this.setPrevNext();
                }
            }
        };
        GpsMaster.active.addPropertyChangeListener(this.changeListener);
        this.setCenterLocation();
        this.setVisible(true);
    }

    public void showImage(File file) throws IOException {
        this.filenameLabel.setText(file.getName());
        this.imageDisplay.setImage(file, -1);
    }

    public void showImage(String string) throws IOException {
        this.showImage(new File(string));
    }

    public void setGpxFiles(List<GPXFile> list) {
        this.gpxFiles = list;
        this.refresh();
        this.setPrevNext();
    }

    public synchronized void showMarker(PhotoMarker photoMarker) {
        if (this.current != null) {
            this.current.setSelected(false);
        }
        String string = photoMarker.getDirectory();
        this.filenameLabel.setText(string);
        this.imageDisplay.setImage(new File(string), photoMarker.getOrientation());
        this.exifModel.setTags(photoMarker.getExifTags());
        this.exifTable.tableChanged(new TableModelEvent(this.exifModel));
        this.current = photoMarker;
        this.current.setSelected(true);
        this.setPrevNext();
        GpsMaster.active.repaintMap();
    }

    @Override
    public String getTitle() {
        return "ImageViewer";
    }

    public void clear() {
        this.imageDisplay.setImage(null, 0);
        this.prevButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.current = null;
        this.gpxFiles = null;
        this.markers.clear();
    }

    @Override
    public void dispose() {
        GpsMaster.active.removePropertyChangeListener(this.changeListener);
        if (this.current != null) {
            this.current.setSelected(false);
        }
        super.dispose();
    }

    private void refresh() {
        if (this.gpxFiles != null) {
            this.markers.clear();
            for (GPXFile gPXFile : this.gpxFiles) {
                for (Waypoint waypoint : gPXFile.getWaypointGroup().getWaypoints()) {
                    if (!(waypoint instanceof PhotoMarker)) continue;
                    this.markers.add((PhotoMarker)waypoint);
                }
            }
        }
        if (this.current != null && this.markers.size() > 0 && !this.markers.contains(this.current)) {
            this.showMarker(this.markers.get(0));
        }
    }

    private void setPrevNext() {
        this.prevButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        if (this.current != null) {
            int n = this.markers.indexOf(this.current);
            if (n > 0) {
                this.prevButton.setEnabled(true);
            }
            if (n < this.markers.size() - 1) {
                this.nextButton.setEnabled(true);
            }
        }
    }

    private void centerMap() {
        if (this.current != null && this.centerButton.isSelected()) {
            GpsMaster.active.centerMap(this.current);
        }
    }
}

