/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import eu.fuegenstein.messagecenter.MessageCenter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.gpsmaster.Config;
import org.gpsmaster.dialogs.GenericDialog;
import org.gpsmaster.dialogs.ItemTargetSelectionPanel;
import org.gpsmaster.filehub.FileHub;
import org.gpsmaster.filehub.FileItem;

public class FileOpenDialog
extends GenericDialog {
    private static final long serialVersionUID = -3238498222001098590L;
    protected JPanel mainPanel = new JPanel();
    protected ItemTargetSelectionPanel targetPanel = null;
    protected JFileChooser fileChooser = null;
    protected FileHub fileHub = null;
    private Config config = null;

    public FileOpenDialog(JFrame jFrame, MessageCenter messageCenter, FileHub fileHub) {
        super(jFrame, messageCenter);
        this.fileHub = fileHub;
        this.fileChooser = new JFileChooser();
        this.targetPanel = new ItemTargetSelectionPanel(fileHub.getItemTargets());
        this.setIcon("/org/gpsmaster/icons/menubar/", "file-open.png");
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.fileChooser, "Center");
        this.getContentPane().add(this.mainPanel);
        this.fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("ApproveSelection")) {
                    FileOpenDialog.this.loadSelected();
                    FileOpenDialog.this.setVisible(false);
                    FileOpenDialog.this.dispose();
                } else if (actionEvent.getActionCommand().equals("CancelSelection")) {
                    FileOpenDialog.this.setVisible(false);
                    FileOpenDialog.this.dispose();
                }
            }
        });
        this.setDefaultCloseOperation(2);
        int n = jFrame.getWidth() * 8 / 10;
        int n2 = jFrame.getHeight() * 8 / 10;
        n = Math.min(864, n);
        n2 = Math.min(539, n2);
        this.setPreferredSize(new Dimension(n, n2));
        this.pack();
        this.setCenterLocation();
        this.setVisible(true);
    }

    public JFileChooser getFileChooser() {
        return this.fileChooser;
    }

    public void setConfig(Config config) {
        this.config = config;
        if (config != null) {
            this.fileChooser.setCurrentDirectory(new File(config.getLastOpenDirectory()));
        }
    }

    @Override
    public void begin() {
    }

    @Override
    public String getTitle() {
        return "Open Files";
    }

    private void loadSelected() {
        this.config.setLastOpenDirectory(this.fileChooser.getCurrentDirectory().getPath());
        for (File file : this.fileChooser.getSelectedFiles()) {
            this.fileHub.addItem(new FileItem(file));
        }
        this.fileHub.run();
    }
}

