/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Track;

public class EditPropsDialog
extends JDialog {
    private GPXObject gpxObject;
    private String name = null;
    private String desc = null;
    private String gpxType = null;
    private Integer number = null;
    private String activity = "";
    private JTextField inputName;
    private JTextArea inputDesc;
    private JTextField inputGPXType;
    private JTextField inputNumber;
    private JTextField inputActivity;

    public EditPropsDialog(Frame frame, String string, GPXObject gPXObject) {
        super(frame, string, true);
        GridBagConstraints gridBagConstraints;
        Object object;
        GridBagConstraints gridBagConstraints2;
        JLabel jLabel;
        this.setForeground(Color.BLACK);
        this.getContentPane().setForeground(Color.BLACK);
        this.gpxObject = gPXObject;
        ImageIcon imageIcon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/edit-properties.png"));
        this.setIconImage(imageIcon.getImage());
        int n = 400;
        int n2 = (frame.getWidth() - n) / 2;
        int n3 = 250;
        int n4 = (frame.getHeight() - n3) / 2;
        this.setBounds(frame.getX() + n2, frame.getY() + n4, n, n3);
        this.setMinimumSize(new Dimension(400, 250));
        JPanel jPanel = new JPanel();
        final JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        jPanel.add(jButton);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditPropsDialog.this.okButton();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditPropsDialog.this.cancelButton();
            }
        });
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(jPanel2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{70, 300};
        gridBagLayout.rowHeights = new int[]{20, 90};
        jPanel2.setLayout(gridBagLayout);
        JLabel jLabel2 = new JLabel("Name");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.weighty = 0.0;
        jPanel2.add((Component)jLabel2, gridBagConstraints3);
        this.inputName = new JTextField();
        if (gPXObject.isGPXFile()) {
            this.inputName.setText(((GPXFile)gPXObject).getMetadata().getName());
        } else {
            this.inputName.setText(gPXObject.getName());
        }
        this.inputName.setFont(new Font("Tahoma", 0, 11));
        this.inputName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    jButton.doClick();
                    keyEvent.consume();
                }
            }
        });
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 0.0;
        jPanel2.add((Component)this.inputName, gridBagConstraints4);
        if (gPXObject.isGPXFile()) {
            jLabel = new JLabel("Activity");
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(1, 1, 1, 1);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.weighty = 1.0;
            jPanel2.add((Component)jLabel, gridBagConstraints2);
            object = (GPXFile)gPXObject;
            this.inputActivity = new JTextField();
            if (((GPXObject)object).getExtension().containsKey("gpsm:activity")) {
                this.inputActivity.setText(((GPXObject)object).getExtension().getSubValue("gpsm:activity"));
            }
            this.inputActivity.setFont(new Font("Tahoma", 0, 11));
            this.inputActivity.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        jButton.doClick();
                        keyEvent.consume();
                    }
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(1, 1, 1, 1);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            jPanel2.add((Component)this.inputActivity, gridBagConstraints);
        }
        jLabel = new JLabel("Description");
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 1.0;
        jPanel2.add((Component)jLabel, gridBagConstraints2);
        this.inputDesc = new JTextArea();
        this.inputDesc.setText(gPXObject.getDesc());
        this.inputDesc.setBorder(null);
        this.inputDesc.setFont(new Font("Tahoma", 0, 11));
        this.inputDesc.setLineWrap(true);
        this.inputDesc.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    if (keyEvent.getModifiers() > 0) {
                        EditPropsDialog.this.inputDesc.transferFocusBackward();
                    } else {
                        EditPropsDialog.this.inputDesc.transferFocus();
                    }
                    keyEvent.consume();
                }
            }
        });
        object = new JScrollPane(this.inputDesc);
        ((JComponent)object).setBorder(new LineBorder(new Color(171, 173, 179)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)object, gridBagConstraints);
        this.inputDesc.addFocusListener(new FocusListener((JScrollPane)object){
            final /* synthetic */ JScrollPane val$scrollPane;
            {
                this.val$scrollPane = jScrollPane;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        val$scrollPane.getViewport().setViewPosition(new Point(0, 0));
                    }
                });
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JScrollBar jScrollBar = val$scrollPane.getVerticalScrollBar();
                        jScrollBar.setValue(jScrollBar.getMaximum());
                        EditPropsDialog.this.inputDesc.setCaretPosition(EditPropsDialog.this.inputDesc.getText().length());
                    }
                });
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add(jPanel);
        SwingUtilities.invokeLater(new Runnable((JScrollPane)object){
            final /* synthetic */ JScrollPane val$scrollPane;
            {
                this.val$scrollPane = jScrollPane;
            }

            @Override
            public void run() {
                this.val$scrollPane.getViewport().setViewPosition(new Point(0, 0));
            }
        });
        if (gPXObject.isRoute() || gPXObject.isTrack()) {
            JLabel jLabel3 = new JLabel("Type");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.insets = new Insets(1, 1, 1, 1);
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 3;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.weighty = 0.0;
            jPanel2.add((Component)jLabel3, gridBagConstraints5);
            this.inputGPXType = new JTextField();
            if (gPXObject.isRoute()) {
                this.inputGPXType.setText(((Route)gPXObject).getType());
            } else if (gPXObject.isTrack()) {
                this.inputGPXType.setText(((Track)gPXObject).getType());
            }
            this.inputGPXType.setFont(new Font("Tahoma", 0, 11));
            this.inputGPXType.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        jButton.doClick();
                        keyEvent.consume();
                    }
                }
            });
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.insets = new Insets(1, 1, 1, 1);
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridy = 3;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.weighty = 0.0;
            jPanel2.add((Component)this.inputGPXType, gridBagConstraints6);
            JLabel jLabel4 = new JLabel("Number");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.insets = new Insets(1, 1, 1, 1);
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 4;
            gridBagConstraints7.weightx = 0.0;
            gridBagConstraints7.weighty = 0.0;
            jPanel2.add((Component)jLabel4, gridBagConstraints7);
            this.inputNumber = new JTextField();
            if (gPXObject.isRoute()) {
                this.inputNumber.setText(Integer.toString(((Route)gPXObject).getNumber()));
            } else if (gPXObject.isTrack()) {
                this.inputNumber.setText(Integer.toString(((Track)gPXObject).getNumber()));
            }
            if (this.inputNumber.getText().equals("0")) {
                this.inputNumber.setText("");
            }
            this.inputNumber.setFont(new Font("Tahoma", 0, 11));
            this.inputNumber.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        jButton.doClick();
                        keyEvent.consume();
                    }
                }
            });
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.insets = new Insets(1, 1, 1, 1);
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.gridy = 4;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.weighty = 0.0;
            jPanel2.add((Component)this.inputNumber, gridBagConstraints8);
            this.inputNumber.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    String string = EditPropsDialog.this.inputNumber.getText();
                    NumberFormat numberFormat = NumberFormat.getIntegerInstance();
                    Number number = null;
                    try {
                        number = numberFormat.parse(string);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    if (number != null && number.intValue() > 0 && number.intValue() < Integer.MAX_VALUE) {
                        String string2 = String.format("%d", number);
                        EditPropsDialog.this.inputNumber.setText(string2);
                    } else {
                        EditPropsDialog.this.inputNumber.setText("");
                    }
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }
            });
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getGPXType() {
        return this.gpxType;
    }

    public Integer getNumber() {
        return this.number;
    }

    public String getActivity() {
        return this.activity;
    }

    private void okButton() {
        this.name = this.inputName.getText();
        this.desc = this.inputDesc.getText();
        if (this.gpxObject.isRoute() || this.gpxObject.isTrack()) {
            this.gpxType = this.inputGPXType.getText().equals("") ? null : this.inputGPXType.getText();
            Integer n = this.number = this.inputNumber.getText().equals("") ? null : Integer.valueOf(Integer.parseInt(this.inputNumber.getText()));
        }
        if (this.gpxObject.isGPXFile()) {
            this.activity = this.inputActivity.getText();
        }
        this.setVisible(false);
    }

    private void cancelButton() {
        this.name = null;
        this.desc = null;
        this.gpxType = null;
        this.number = null;
        this.setVisible(false);
    }
}

