/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import eu.fuegenstein.swing.PlainColorIcon;
import eu.fuegenstein.util.XTime;
import java.awt.Color;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.db.DbLayer;
import org.gpsmaster.db.GpsRecord;

public class DbTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 5273731050613887670L;
    private final String[] colNames = new String[]{" ", "Start Date", "Name", "Distance", "Duration", "Activity"};
    private final int COLUMNCOUNT = 6;
    private DbLayer db = null;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private List<GpsRecord> gpsEntries = new ArrayList<GpsRecord>();
    private Hashtable<String, ImageIcon> iconCache = new Hashtable();
    private Hashtable<Color, Icon> colorCache = new Hashtable();

    public DbTableModel(DbLayer dbLayer) {
        this.db = dbLayer;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        return this.gpsEntries.size();
    }

    @Override
    public String getColumnName(int n) {
        return this.colNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        GpsRecord gpsRecord = this.gpsEntries.get(n);
        switch (n2) {
            case 0: {
                return this.getColorIcon(gpsRecord.getColor());
            }
            case 1: {
                return this.sdf.format(gpsRecord.getStartTime());
            }
            case 2: {
                return gpsRecord.getName();
            }
            case 3: {
                return gpsRecord.getDistance();
            }
            case 4: {
                return XTime.getDurationString(gpsRecord.getDuration());
            }
            case 5: {
                return this.getActivityIcon(gpsRecord.getActivity());
            }
        }
        return "?";
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 5: {
                return Icon.class;
            }
            case 3: {
                return Long.class;
            }
        }
        return String.class;
    }

    public GpsRecord get(int n) {
        return this.gpsEntries.get(n);
    }

    public List<GpsRecord> getGpsRecords() {
        return this.gpsEntries;
    }

    public void setGpsRecords(List<GpsRecord> list) {
        this.gpsEntries = list;
    }

    public void refresh() throws SQLException {
        this.gpsEntries.clear();
        this.db.getGpsRecords(this.gpsEntries);
        this.fireTableDataChanged();
    }

    public void clear() {
        this.gpsEntries.clear();
        this.fireTableDataChanged();
    }

    private ImageIcon getActivityIcon(String string) {
        ImageIcon imageIcon = null;
        if (string.length() > 0) {
            if (this.iconCache.containsKey(string)) {
                imageIcon = this.iconCache.get(string);
            } else {
                imageIcon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/activities/" + string + ".png"));
                this.iconCache.put(string, imageIcon);
            }
        }
        return imageIcon;
    }

    private Icon getColorIcon(Color color) {
        Icon icon = null;
        if (this.colorCache.containsKey(color)) {
            icon = this.colorCache.get(color);
        } else {
            icon = new PlainColorIcon(color);
            this.colorCache.put(color, icon);
        }
        return icon;
    }
}

