/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.dialogs;

import eu.fuegenstein.messagecenter.MessageCenter;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.cleaning.CleaningAlgorithm;
import org.gpsmaster.cleaning.CloudBuster;
import org.gpsmaster.cleaning.Duplicates;
import org.gpsmaster.cleaning.MinDistance;
import org.gpsmaster.cleaning.Singleton;
import org.gpsmaster.dialogs.CleaningStats;
import org.gpsmaster.dialogs.RadioButtonDialog;
import org.gpsmaster.marker.Marker;

public class CleaningDialog
extends RadioButtonDialog {
    private static final long serialVersionUID = 7970617363233860922L;
    private ActionListener selectionListener = null;
    private PropertyChangeListener changeListener = null;
    private List<CleaningAlgorithm> algorithms = new ArrayList<CleaningAlgorithm>();
    private List<Marker> markerList = null;
    private CleaningAlgorithm selected = null;
    private CleaningStats statPanel = null;

    public CleaningDialog(JFrame jFrame, MessageCenter messageCenter) {
        super(jFrame, messageCenter);
        this.algorithms.add(new Duplicates());
        this.algorithms.add(new MinDistance());
        this.algorithms.add(new Singleton());
        this.algorithms.add(new CloudBuster());
        this.setIcon("/org/gpsmaster/icons/toolbar/", "clean-distance.png");
        this.setGpxObject();
        this.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("activeGpxObject") || string.equals("refreshGpx")) {
                    CleaningDialog.this.setGpxObject();
                }
            }
        };
        GpsMaster.active.addPropertyChangeListener(this.changeListener);
        this.statPanel = new CleaningStats();
        this.statPanel.setBackground(this.backgroundColor);
        this.statPanel.setBorder(new EmptyBorder(3, 0, 0, 0));
        this.statPanel.setAlignmentX(0.0f);
        this.statPanel.setBackground(Color.RED);
    }

    @Override
    public String getTitle() {
        return "Apply cleaning algorithm";
    }

    public List<Marker> getMarkerList() {
        return this.markerList;
    }

    public void setMarkerList(List<Marker> list) {
        this.markerList = list;
        for (CleaningAlgorithm cleaningAlgorithm : this.algorithms) {
            cleaningAlgorithm.setMarkerList(list);
        }
    }

    @Override
    public void begin() {
        AbstractButton abstractButton;
        if (this.selectionListener == null) {
            this.selectionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (CleaningAlgorithm cleaningAlgorithm : CleaningDialog.this.algorithms) {
                        if (!cleaningAlgorithm.getName().equals(actionEvent.getActionCommand())) continue;
                        CleaningDialog.this.setInfoPanel(cleaningAlgorithm.getPanel(CleaningDialog.this.backgroundColor));
                        CleaningDialog.this.revalidate();
                        CleaningDialog.this.repaint();
                        CleaningDialog.this.selected = cleaningAlgorithm;
                        return;
                    }
                }
            };
        }
        this.setDefaultCloseOperation(2);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (CleaningAlgorithm object2 : this.algorithms) {
            abstractButton = new JRadioButton(object2.getName());
            abstractButton.setActionCommand(object2.getName());
            abstractButton.addActionListener(this.selectionListener);
            abstractButton.setBackground(this.backgroundColor);
            if (this.algorithms.indexOf(object2) == 0) {
                abstractButton.setSelected(true);
            }
            this.radioPanel.add(abstractButton);
            buttonGroup.add(abstractButton);
        }
        this.selected = this.algorithms.get(0);
        this.setInfoPanel(this.selected.getPanel(this.backgroundColor));
        JButton jButton = new JButton("Preview");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CleaningDialog.this.preview();
            }
        });
        this.buttonPanel.add(jButton);
        JButton jButton2 = new JButton("Apply");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CleaningDialog.this.apply();
            }
        });
        this.buttonPanel.add(jButton2);
        abstractButton = new JButton("Close");
        abstractButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CleaningDialog.this.dispose();
            }
        });
        this.buttonPanel.add(abstractButton);
        this.pack();
        this.setCenterLocation();
        this.setVisible(true);
    }

    @Override
    public void dispose() {
        GpsMaster.active.removePropertyChangeListener(this.changeListener);
        for (CleaningAlgorithm cleaningAlgorithm : this.algorithms) {
            cleaningAlgorithm.clear();
        }
        GpsMaster.active.repaintMap();
        super.dispose();
    }

    private void setGpxObject() {
        for (CleaningAlgorithm cleaningAlgorithm : this.algorithms) {
            cleaningAlgorithm.clear();
            cleaningAlgorithm.setWaypointGroups(GpsMaster.active.getGroups());
        }
    }

    private void apply() {
        if (this.selected != null) {
            this.selected.apply();
            this.selected.clear();
            GpsMaster.active.refresh();
            GpsMaster.active.repaintMap();
        }
    }

    private void preview() {
        if (this.selected != null) {
            this.selected.preview();
            GpsMaster.active.repaintMap();
        }
    }
}

