/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.db;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gpsmaster.db.DbLayer;
import org.gpsmaster.db.GpsRecord;
import org.gpsmaster.filehub.DataType;
import org.gpsmaster.filehub.IItemTarget;
import org.gpsmaster.filehub.TransferableItem;
import org.gpsmaster.gpxpanel.GPXFile;

public class DbTarget
implements IItemTarget {
    protected DbLayer dbLayer = null;
    protected TransferableItem currentItem = null;
    protected GpsRecord gpsRecord = null;
    protected ByteArrayOutputStream outStream = null;
    protected ZipOutputStream zipOut = null;
    protected boolean enabled = false;

    public DbTarget(DbLayer dbLayer) {
        this.dbLayer = dbLayer;
    }

    @Override
    public String getName() {
        return "GPS Database";
    }

    @Override
    public String getDescription() {
        return "Store in GPS Database";
    }

    @Override
    public DataType getDataType() {
        return DataType.STREAMGPX;
    }

    @Override
    public boolean doShowProgressText() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public void addGpxFile(GPXFile gPXFile, TransferableItem transferableItem) {
        gPXFile.updateAllProperties();
        this.gpsRecord = new GpsRecord(gPXFile);
        this.gpsRecord.setLoaderClassName(this.currentItem.getLoaderClassName());
        this.gpsRecord.setSourceFormat(this.currentItem.getSourceFormat());
        this.gpsRecord.setName(this.currentItem.getName());
        this.gpsRecord.setId(gPXFile.getDbId());
    }

    @Override
    public void open(TransferableItem transferableItem) throws Exception {
        this.currentItem = transferableItem;
    }

    @Override
    public String getRequiredFormat() {
        return "gpx";
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.outStream = new ByteArrayOutputStream();
        if (this.dbLayer.useCompression()) {
            this.gpsRecord.setCompressed(true);
            this.zipOut = new ZipOutputStream(this.outStream);
            this.zipOut.putNextEntry(new ZipEntry(this.gpsRecord.getName()));
        }
        return this.outStream;
    }

    @Override
    public void close() throws Exception {
        if (this.gpsRecord.getId() == -1L) {
            this.dbLayer.addGpsRecord(this.gpsRecord, this.outStream.toByteArray());
        } else {
            this.dbLayer.updateGpsRecord(this.gpsRecord, this.outStream.toByteArray());
        }
        if (this.zipOut != null) {
            this.zipOut.closeEntry();
            this.zipOut.close();
        }
        this.outStream.close();
        this.currentItem = null;
        this.gpsRecord = null;
        this.zipOut = null;
        this.outStream = null;
    }
}

