/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.db;

import eu.fuegenstein.util.NamedParameterStatement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import org.gpsmaster.db.DBConfig;
import org.gpsmaster.db.GpsRecord;

public class DbLayer {
    private DBConfig dbConfig = null;
    private Connection connection = null;

    public DbLayer(DBConfig dBConfig) {
        this.dbConfig = dBConfig;
    }

    public boolean isConnected() {
        return false;
    }

    public boolean useCompression() {
        return this.dbConfig.isCompression();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void connect() throws SQLException {
        this.connection = DriverManager.getConnection(this.dbConfig.getDSN(), this.dbConfig.getUsername(), this.dbConfig.getPassword());
        this.connection.setAutoCommit(false);
    }

    public void disconnect() throws SQLException {
        this.connection.close();
    }

    public void updateGpsRecord(GpsRecord gpsRecord, byte[] byArray) throws SQLException {
        String string = "UPDATE dat_gps SET name = :name, color = :color, start_dt = start_dt, end_dt = end_dt, distance = :distance, duration = :duration, min_lat = :min_lat, max_lat = :max_lat, min_lon = :min_lon, max_lon = :max_lon,loader_class = :loader_class, prog_version = :prog_version, data = :data, source_urn = :source_urn, user_id = :user_id, compressed = :compressed, entry_dt = :entry_dt, checksum = :checksum, activity = :activity, fileformat = :format WHERE ID = :id";
        try (NamedParameterStatement namedParameterStatement = new NamedParameterStatement(this.connection, string);){
            namedParameterStatement.setLong("id", gpsRecord.getId());
            this.itemToStmt(gpsRecord, namedParameterStatement, byArray);
            namedParameterStatement.executeUpdate();
            this.connection.commit();
        }
    }

    public void addGpsRecord(GpsRecord gpsRecord, byte[] byArray) throws SQLException {
        long l = 0L;
        String string = "SELECT max(id) from dat_gps";
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            l = resultSet.getLong(1);
        }
        resultSet.close();
        statement.close();
        ++l;
        string = "INSERT INTO dat_gps(id, name, color, start_dt, end_dt, distance, duration,min_lat, max_lat, min_lon, max_lon, loader_class, prog_version, data, source_urn, user_id, compressed, entry_dt, checksum, activity, fileformat) VALUES (:id, :name, :color, :start_dt, :end_dt, :distance, :duration, :min_lat, :max_lat, :min_lon, :max_lon, :loader_class, :prog_version, :data, :source_urn, :user_id, :compressed, :entry_dt, :checksum, :activity, :fileformat)";
        try (NamedParameterStatement namedParameterStatement = new NamedParameterStatement(this.connection, string);){
            namedParameterStatement.setLong("id", l);
            this.itemToStmt(gpsRecord, namedParameterStatement, byArray);
            namedParameterStatement.execute();
            this.connection.commit();
            gpsRecord.setId(l);
        }
    }

    public GpsRecord getGpsRecord(long l) throws SQLException {
        GpsRecord gpsRecord = null;
        String string = "SELECT * FROM dat_gps where id = ?";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            gpsRecord = new GpsRecord();
            this.rsToItem(resultSet, gpsRecord);
        }
        return gpsRecord;
    }

    public void deleteGpsRecord(long l) throws SQLException {
        String string = "DELETE FROM dat_gps where id = ?";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        preparedStatement.execute();
        this.connection.commit();
    }

    public void getGpsRecords(List<GpsRecord> list) throws SQLException {
        String string = "SELECT id, name, color, start_dt, end_dt, distance, duration, min_lat, max_lat, min_lon, max_lon, activity, loader_class, fileformat,  prog_version, source_urn, user_id, compressed, entry_dt, checksum  FROM dat_gps";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            GpsRecord gpsRecord = new GpsRecord();
            this.rsToItem(resultSet, gpsRecord);
            list.add(gpsRecord);
        }
        resultSet.close();
    }

    public InputStream getGpsData(long l) throws SQLException {
        ByteArrayInputStream byteArrayInputStream = null;
        String string = "SELECT data FROM dat_gps where id = ?";
        PreparedStatement preparedStatement = this.connection.prepareStatement(string);
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            byteArrayInputStream = new ByteArrayInputStream(resultSet.getBytes("data"));
        }
        return byteArrayInputStream;
    }

    private void rsToItem(ResultSet resultSet, GpsRecord gpsRecord) throws SQLException {
        gpsRecord.setId(resultSet.getLong("id"));
        gpsRecord.setName(resultSet.getString("name"));
        gpsRecord.setRgbColor(resultSet.getInt("color"));
        gpsRecord.setStartTime(resultSet.getTimestamp("start_dt"));
        gpsRecord.setEndTime(resultSet.getTimestamp("end_dt"));
        gpsRecord.setDistance(resultSet.getLong("distance"));
        gpsRecord.setDuration(resultSet.getLong("duration"));
        gpsRecord.getBounds().setMinlat(new BigDecimal(resultSet.getDouble("min_lat")));
        gpsRecord.getBounds().setMaxlat(new BigDecimal(resultSet.getDouble("max_lat")));
        gpsRecord.getBounds().setMinlon(new BigDecimal(resultSet.getDouble("min_lon")));
        gpsRecord.getBounds().setMaxlon(new BigDecimal(resultSet.getDouble("max_lon")));
        gpsRecord.setActivity(resultSet.getString("activity"));
        gpsRecord.setLoaderClassName(resultSet.getString("loader_class"));
        gpsRecord.setSourceFormat(resultSet.getString("fileformat"));
        gpsRecord.setProgVersion(resultSet.getString("prog_version"));
        gpsRecord.setSourceUrn(resultSet.getString("source_urn"));
        gpsRecord.setUserId(resultSet.getLong("user_id"));
        gpsRecord.setCompressed(resultSet.getBoolean("compressed"));
        gpsRecord.setEntryDate(resultSet.getDate("entry_dt"));
        gpsRecord.setChecksum(resultSet.getString("checksum"));
    }

    private void itemToStmt(GpsRecord gpsRecord, NamedParameterStatement namedParameterStatement, byte[] byArray) throws SQLException {
        namedParameterStatement.setString("name", gpsRecord.getName());
        namedParameterStatement.setInt("color", gpsRecord.getRgbColor());
        if (gpsRecord.getStartTime() != null) {
            namedParameterStatement.setTimestamp("start_dt", new Timestamp(gpsRecord.getStartTime().getTime()));
        }
        if (gpsRecord.getEndTime() != null) {
            namedParameterStatement.setTimestamp("end_dt", new Timestamp(gpsRecord.getEndTime().getTime()));
        }
        namedParameterStatement.setLong("distance", gpsRecord.getDistance());
        namedParameterStatement.setLong("duration", gpsRecord.getDuration());
        namedParameterStatement.setDouble("min_lat", gpsRecord.getBounds().getMinlat().doubleValue());
        namedParameterStatement.setDouble("max_lat", gpsRecord.getBounds().getMaxlat().doubleValue());
        namedParameterStatement.setDouble("min_lon", gpsRecord.getBounds().getMinlon().doubleValue());
        namedParameterStatement.setDouble("max_lon", gpsRecord.getBounds().getMaxlon().doubleValue());
        namedParameterStatement.setString("loader_class", gpsRecord.getLoaderClassName());
        namedParameterStatement.setString("prog_version", gpsRecord.getProgVersion());
        namedParameterStatement.setBytes("data", byArray);
        namedParameterStatement.setString("source_urn", gpsRecord.getSourceUrn());
        namedParameterStatement.setLong("user_id", gpsRecord.getUserId());
        namedParameterStatement.setBoolean("compressed", gpsRecord.isCompressed());
        namedParameterStatement.setDate("entry_dt", new Date(gpsRecord.getEntryDate().getTime()));
        namedParameterStatement.setString("checksum", gpsRecord.getChecksum());
        namedParameterStatement.setString("activity", gpsRecord.getActivity());
        namedParameterStatement.setString("fileformat", gpsRecord.getSourceFormat());
    }
}

