/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.cleaning;

import eu.fuegenstein.parameter.DoubleParameter;
import java.util.List;
import org.gpsmaster.cleaning.CleaningAlgorithm;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;

public class MinDistance
extends CleaningAlgorithm {
    private DoubleParameter minDistance = new DoubleParameter(1.0);

    public MinDistance() {
        this.minDistance.setDescription("Minimum Distance");
        this.minDistance.setName("minDistance");
        this.minDistance.setFormat("%.1f");
        this.params.add(this.minDistance);
    }

    @Override
    public String getName() {
        return "MinDistance";
    }

    @Override
    public String getDescription() {
        return "Remove all trackpoints within a certain distance to their neighbours";
    }

    @Override
    protected void applyAlgorithm(WaypointGroup waypointGroup, List<Waypoint> list) {
        double d = 0.0;
        if (waypointGroup.getWaypoints().size() > 2) {
            List<Waypoint> list2 = waypointGroup.getWaypoints();
            Waypoint waypoint = list2.get(0);
            for (int i = 1; i < list2.size(); ++i) {
                Waypoint waypoint2 = list2.get(i);
                if ((d += waypoint2.getDistance(waypoint)) < this.minDistance.getValue()) {
                    list.add(waypoint2);
                    continue;
                }
                d = 0.0;
                waypoint = waypoint2;
            }
        }
    }
}

