/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.chart;

import eu.fuegenstein.unit.UnitConverter;
import java.util.ArrayList;
import java.util.List;
import org.gpsmaster.chart.ChartYAxis;
import org.gpsmaster.gpxpanel.Waypoint;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.renderer.xy.XYAreaRenderer;

public class SpeedAxis
extends ChartYAxis {
    private int windowSize = 5;
    private List<Waypoint> window = new ArrayList<Waypoint>();

    public SpeedAxis(UnitConverter unitConverter) {
        super(unitConverter);
        this.title = "Speed";
        this.iconFile = "axis_speed.png";
        this.valueAxis = new NumberAxis();
        this.valueAxis.setLabel(unitConverter.getTargetSet().getSpeedUnit().getSymbol());
        this.renderer = new XYAreaRenderer(2);
        super.setDefaults();
    }

    @Override
    public double getValue(Waypoint waypoint) {
        if (waypoint == null || waypoint.getTime() == null) {
            return 0.0;
        }
        this.window.add(waypoint);
        if (this.window.size() < this.windowSize) {
            return 0.0;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 1; i < this.windowSize; ++i) {
            d2 += this.window.get(i).getDistance(this.window.get(i - 1));
        }
        double d3 = (double)(this.window.get(this.windowSize - 1).getTime().getTime() - this.window.get(0).getTime().getTime()) / 1000.0;
        d = this.uc.speed(d2 / d3);
        this.window.remove(0);
        return d;
    }

    @Override
    public void reset() {
    }
}

