/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.PeriodAxis;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.chart.axis.SubCategoryAxis;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.LabelBlock;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeCategoryPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.MultiplePiePlot;
import org.jfree.chart.plot.PieLabelLinkStyle;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.GradientBarPainter;
import org.jfree.chart.renderer.category.LineRenderer3D;
import org.jfree.chart.renderer.category.MinMaxCategoryRenderer;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.chart.renderer.xy.GradientXYBarPainter;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.CompositeTitle;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.util.DefaultShadowGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ShadowGenerator;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class GpsMasterChartTheme
implements ChartTheme,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -119345562874607800L;
    private String name;
    private Font extraLargeFont;
    private Font largeFont;
    private Font regularFont;
    private Font smallFont;
    private transient Paint titlePaint;
    private transient Paint subtitlePaint;
    private transient Paint chartBackgroundPaint;
    private transient Paint legendBackgroundPaint;
    private transient Paint legendItemPaint;
    private DrawingSupplier drawingSupplier;
    private transient Paint plotBackgroundPaint;
    private transient Paint plotOutlinePaint;
    private PieLabelLinkStyle labelLinkStyle;
    private transient Paint labelLinkPaint;
    private transient Paint domainGridlinePaint;
    private transient Paint rangeGridlinePaint;
    private transient Paint baselinePaint;
    private transient Paint crosshairPaint;
    private RectangleInsets axisOffset;
    private transient Paint axisLabelPaint;
    private transient Paint tickLabelPaint;
    private transient Paint itemLabelPaint;
    private boolean shadowVisible;
    private transient Paint shadowPaint;
    private BarPainter barPainter;
    private XYBarPainter xyBarPainter;
    private transient Paint thermometerPaint;
    private transient Paint wallPaint;
    private transient Paint errorIndicatorPaint;
    private transient Paint gridBandPaint = SymbolAxis.DEFAULT_GRID_BAND_PAINT;
    private transient Paint gridBandAlternatePaint = SymbolAxis.DEFAULT_GRID_BAND_ALTERNATE_PAINT;
    private ShadowGenerator shadowGenerator;

    public GpsMasterChartTheme(String string) {
        this(string, false);
    }

    public GpsMasterChartTheme(String string, boolean bl) {
        ParamChecks.nullNotPermitted((Object)string, (String)"name");
        this.name = string;
        this.extraLargeFont = new Font("Tahoma", 1, 18);
        this.largeFont = new Font("Tahoma", 1, 12);
        this.regularFont = new Font("Tahoma", 0, 10);
        this.smallFont = new Font("Tahoma", 0, 8);
        this.titlePaint = Color.black;
        this.subtitlePaint = Color.black;
        this.legendBackgroundPaint = Color.white;
        this.legendItemPaint = Color.darkGray;
        this.chartBackgroundPaint = Color.white;
        this.drawingSupplier = new DefaultDrawingSupplier();
        this.plotBackgroundPaint = Color.WHITE;
        this.plotOutlinePaint = Color.black;
        this.labelLinkPaint = Color.black;
        this.labelLinkStyle = PieLabelLinkStyle.CUBIC_CURVE;
        this.axisOffset = new RectangleInsets(4.0, 4.0, 4.0, 4.0);
        this.domainGridlinePaint = Color.GRAY;
        this.rangeGridlinePaint = Color.GRAY;
        this.baselinePaint = Color.black;
        this.crosshairPaint = Color.blue;
        this.axisLabelPaint = Color.darkGray;
        this.tickLabelPaint = Color.darkGray;
        this.barPainter = new GradientBarPainter();
        this.xyBarPainter = new GradientXYBarPainter();
        this.shadowVisible = false;
        this.shadowPaint = Color.gray;
        this.itemLabelPaint = Color.black;
        this.thermometerPaint = Color.white;
        this.wallPaint = BarRenderer3D.DEFAULT_WALL_PAINT;
        this.errorIndicatorPaint = Color.black;
        this.shadowGenerator = bl ? new DefaultShadowGenerator() : null;
    }

    public Font getExtraLargeFont() {
        return this.extraLargeFont;
    }

    public void setExtraLargeFont(Font font) {
        ParamChecks.nullNotPermitted((Object)font, (String)"font");
        this.extraLargeFont = font;
    }

    public Font getLargeFont() {
        return this.largeFont;
    }

    public void setLargeFont(Font font) {
        ParamChecks.nullNotPermitted((Object)font, (String)"font");
        this.largeFont = font;
    }

    public Font getRegularFont() {
        return this.regularFont;
    }

    public void setRegularFont(Font font) {
        ParamChecks.nullNotPermitted((Object)font, (String)"font");
        this.regularFont = font;
    }

    public Font getSmallFont() {
        return this.smallFont;
    }

    public void setSmallFont(Font font) {
        ParamChecks.nullNotPermitted((Object)font, (String)"font");
        this.smallFont = font;
    }

    public Paint getTitlePaint() {
        return this.titlePaint;
    }

    public void setTitlePaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.titlePaint = paint;
    }

    public Paint getSubtitlePaint() {
        return this.subtitlePaint;
    }

    public void setSubtitlePaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.subtitlePaint = paint;
    }

    public Paint getChartBackgroundPaint() {
        return this.chartBackgroundPaint;
    }

    public void setChartBackgroundPaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.chartBackgroundPaint = paint;
    }

    public Paint getLegendBackgroundPaint() {
        return this.legendBackgroundPaint;
    }

    public void setLegendBackgroundPaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.legendBackgroundPaint = paint;
    }

    public Paint getLegendItemPaint() {
        return this.legendItemPaint;
    }

    public void setLegendItemPaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.legendItemPaint = paint;
    }

    public Paint getPlotBackgroundPaint() {
        return this.plotBackgroundPaint;
    }

    public void setPlotBackgroundPaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.plotBackgroundPaint = paint;
    }

    public Paint getPlotOutlinePaint() {
        return this.plotOutlinePaint;
    }

    public void setPlotOutlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.plotOutlinePaint = paint;
    }

    public PieLabelLinkStyle getLabelLinkStyle() {
        return this.labelLinkStyle;
    }

    public void setLabelLinkStyle(PieLabelLinkStyle pieLabelLinkStyle) {
        ParamChecks.nullNotPermitted((Object)pieLabelLinkStyle, (String)"style");
        this.labelLinkStyle = pieLabelLinkStyle;
    }

    public Paint getLabelLinkPaint() {
        return this.labelLinkPaint;
    }

    public void setLabelLinkPaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.labelLinkPaint = paint;
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.domainGridlinePaint = paint;
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.rangeGridlinePaint = paint;
    }

    public Paint getBaselinePaint() {
        return this.baselinePaint;
    }

    public void setBaselinePaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.baselinePaint = paint;
    }

    public Paint getCrosshairPaint() {
        return this.crosshairPaint;
    }

    public void setCrosshairPaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.crosshairPaint = paint;
    }

    public RectangleInsets getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(RectangleInsets rectangleInsets) {
        ParamChecks.nullNotPermitted((Object)rectangleInsets, (String)"offset");
        this.axisOffset = rectangleInsets;
    }

    public Paint getAxisLabelPaint() {
        return this.axisLabelPaint;
    }

    public void setAxisLabelPaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.axisLabelPaint = paint;
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.tickLabelPaint = paint;
    }

    public Paint getItemLabelPaint() {
        return this.itemLabelPaint;
    }

    public void setItemLabelPaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.itemLabelPaint = paint;
    }

    public boolean isShadowVisible() {
        return this.shadowVisible;
    }

    public void setShadowVisible(boolean bl) {
        this.shadowVisible = bl;
    }

    public Paint getShadowPaint() {
        return this.shadowPaint;
    }

    public void setShadowPaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.shadowPaint = paint;
    }

    public BarPainter getBarPainter() {
        return this.barPainter;
    }

    public void setBarPainter(BarPainter barPainter) {
        ParamChecks.nullNotPermitted((Object)barPainter, (String)"painter");
        this.barPainter = barPainter;
    }

    public XYBarPainter getXYBarPainter() {
        return this.xyBarPainter;
    }

    public void setXYBarPainter(XYBarPainter xYBarPainter) {
        ParamChecks.nullNotPermitted((Object)xYBarPainter, (String)"painter");
        this.xyBarPainter = xYBarPainter;
    }

    public Paint getThermometerPaint() {
        return this.thermometerPaint;
    }

    public void setThermometerPaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.thermometerPaint = paint;
    }

    public Paint getWallPaint() {
        return this.wallPaint;
    }

    public void setWallPaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.wallPaint = paint;
    }

    public Paint getErrorIndicatorPaint() {
        return this.errorIndicatorPaint;
    }

    public void setErrorIndicatorPaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.errorIndicatorPaint = paint;
    }

    public Paint getGridBandPaint() {
        return this.gridBandPaint;
    }

    public void setGridBandPaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.gridBandPaint = paint;
    }

    public Paint getGridBandAlternatePaint() {
        return this.gridBandAlternatePaint;
    }

    public void setGridBandAlternatePaint(Paint paint) {
        ParamChecks.nullNotPermitted((Object)paint, (String)"paint");
        this.gridBandAlternatePaint = paint;
    }

    public String getName() {
        return this.name;
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        if (this.drawingSupplier instanceof PublicCloneable) {
            PublicCloneable publicCloneable = (PublicCloneable)this.drawingSupplier;
            try {
                drawingSupplier = (DrawingSupplier)publicCloneable.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }
        return drawingSupplier;
    }

    public void setDrawingSupplier(DrawingSupplier drawingSupplier) {
        ParamChecks.nullNotPermitted((Object)drawingSupplier, (String)"supplier");
        this.drawingSupplier = drawingSupplier;
    }

    public void apply(JFreeChart jFreeChart) {
        ParamChecks.nullNotPermitted((Object)jFreeChart, (String)"chart");
        TextTitle textTitle = jFreeChart.getTitle();
        if (textTitle != null) {
            textTitle.setFont(this.extraLargeFont);
            textTitle.setPaint(this.titlePaint);
        }
        int n = jFreeChart.getSubtitleCount();
        for (int i = 0; i < n; ++i) {
            this.applyToTitle(jFreeChart.getSubtitle(i));
        }
        jFreeChart.setBackgroundPaint(this.chartBackgroundPaint);
        Plot plot = jFreeChart.getPlot();
        if (plot != null) {
            this.applyToPlot(plot);
        }
    }

    protected void applyToTitle(Title title) {
        if (title instanceof TextTitle) {
            TextTitle textTitle = (TextTitle)title;
            textTitle.setFont(this.largeFont);
            textTitle.setPaint(this.subtitlePaint);
        } else if (title instanceof LegendTitle) {
            LegendTitle legendTitle = (LegendTitle)title;
            if (legendTitle.getBackgroundPaint() != null) {
                legendTitle.setBackgroundPaint(this.legendBackgroundPaint);
            }
            legendTitle.setItemFont(this.regularFont);
            legendTitle.setItemPaint(this.legendItemPaint);
            if (legendTitle.getWrapper() != null) {
                this.applyToBlockContainer(legendTitle.getWrapper());
            }
        } else if (title instanceof PaintScaleLegend) {
            PaintScaleLegend paintScaleLegend = (PaintScaleLegend)title;
            paintScaleLegend.setBackgroundPaint(this.legendBackgroundPaint);
            ValueAxis valueAxis = paintScaleLegend.getAxis();
            if (valueAxis != null) {
                this.applyToValueAxis(valueAxis);
            }
        } else if (title instanceof CompositeTitle) {
            CompositeTitle compositeTitle = (CompositeTitle)title;
            BlockContainer blockContainer = compositeTitle.getContainer();
            List list = blockContainer.getBlocks();
            for (Block block : list) {
                if (!(block instanceof Title)) continue;
                this.applyToTitle((Title)block);
            }
        }
    }

    protected void applyToBlockContainer(BlockContainer blockContainer) {
        for (Block block : blockContainer.getBlocks()) {
            this.applyToBlock(block);
        }
    }

    protected void applyToBlock(Block block) {
        if (block instanceof Title) {
            this.applyToTitle((Title)block);
        } else if (block instanceof LabelBlock) {
            LabelBlock labelBlock = (LabelBlock)block;
            labelBlock.setFont(this.regularFont);
            labelBlock.setPaint(this.legendItemPaint);
        }
    }

    protected void applyToPlot(Plot plot) {
        ParamChecks.nullNotPermitted((Object)plot, (String)"plot");
        if (plot.getDrawingSupplier() != null) {
            plot.setDrawingSupplier(this.getDrawingSupplier());
        }
        if (plot.getBackgroundPaint() != null) {
            plot.setBackgroundPaint(this.plotBackgroundPaint);
        }
        plot.setOutlinePaint(this.plotOutlinePaint);
        if (plot instanceof PiePlot) {
            this.applyToPiePlot((PiePlot)plot);
        } else if (plot instanceof MultiplePiePlot) {
            this.applyToMultiplePiePlot((MultiplePiePlot)plot);
        } else if (plot instanceof CategoryPlot) {
            this.applyToCategoryPlot((CategoryPlot)plot);
        } else if (plot instanceof XYPlot) {
            this.applyToXYPlot((XYPlot)plot);
        } else if (plot instanceof FastScatterPlot) {
            this.applyToFastScatterPlot((FastScatterPlot)plot);
        } else if (plot instanceof MeterPlot) {
            this.applyToMeterPlot((MeterPlot)plot);
        } else if (plot instanceof ThermometerPlot) {
            this.applyToThermometerPlot((ThermometerPlot)plot);
        } else if (plot instanceof SpiderWebPlot) {
            this.applyToSpiderWebPlot((SpiderWebPlot)plot);
        } else if (plot instanceof PolarPlot) {
            this.applyToPolarPlot((PolarPlot)plot);
        }
    }

    protected void applyToPiePlot(PiePlot piePlot) {
        piePlot.setLabelLinkPaint(this.labelLinkPaint);
        piePlot.setLabelLinkStyle(this.labelLinkStyle);
        piePlot.setLabelFont(this.regularFont);
        piePlot.setShadowGenerator(this.shadowGenerator);
        if (piePlot.getAutoPopulateSectionPaint()) {
            piePlot.clearSectionPaints(false);
        }
        if (piePlot.getAutoPopulateSectionOutlinePaint()) {
            piePlot.clearSectionOutlinePaints(false);
        }
        if (piePlot.getAutoPopulateSectionOutlineStroke()) {
            piePlot.clearSectionOutlineStrokes(false);
        }
    }

    protected void applyToMultiplePiePlot(MultiplePiePlot multiplePiePlot) {
        this.apply(multiplePiePlot.getPieChart());
    }

    protected void applyToCategoryPlot(CategoryPlot categoryPlot) {
        int n;
        int n2;
        categoryPlot.setAxisOffset(this.axisOffset);
        categoryPlot.setDomainGridlinePaint(this.domainGridlinePaint);
        categoryPlot.setRangeGridlinePaint(this.rangeGridlinePaint);
        categoryPlot.setRangeZeroBaselinePaint(this.baselinePaint);
        categoryPlot.setShadowGenerator(this.shadowGenerator);
        int n3 = categoryPlot.getDomainAxisCount();
        for (n2 = 0; n2 < n3; ++n2) {
            CategoryAxis categoryAxis = categoryPlot.getDomainAxis(n2);
            if (categoryAxis == null) continue;
            this.applyToCategoryAxis(categoryAxis);
        }
        n2 = categoryPlot.getRangeAxisCount();
        for (n = 0; n < n2; ++n) {
            ValueAxis valueAxis = categoryPlot.getRangeAxis(n);
            if (valueAxis == null) continue;
            this.applyToValueAxis(valueAxis);
        }
        n = categoryPlot.getRendererCount();
        for (int i = 0; i < n; ++i) {
            CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer(i);
            if (categoryItemRenderer == null) continue;
            this.applyToCategoryItemRenderer(categoryItemRenderer);
        }
        if (categoryPlot instanceof CombinedDomainCategoryPlot) {
            CombinedDomainCategoryPlot combinedDomainCategoryPlot = (CombinedDomainCategoryPlot)categoryPlot;
            for (CategoryPlot categoryPlot2 : combinedDomainCategoryPlot.getSubplots()) {
                if (categoryPlot2 == null) continue;
                this.applyToPlot((Plot)categoryPlot2);
            }
        }
        if (categoryPlot instanceof CombinedRangeCategoryPlot) {
            CombinedRangeCategoryPlot combinedRangeCategoryPlot = (CombinedRangeCategoryPlot)categoryPlot;
            for (CategoryPlot categoryPlot2 : combinedRangeCategoryPlot.getSubplots()) {
                if (categoryPlot2 == null) continue;
                this.applyToPlot((Plot)categoryPlot2);
            }
        }
    }

    protected void applyToXYPlot(XYPlot xYPlot) {
        XYItemRenderer xYItemRenderer2;
        int n;
        int n2;
        xYPlot.setAxisOffset(this.axisOffset);
        xYPlot.setDomainZeroBaselinePaint(this.baselinePaint);
        xYPlot.setRangeZeroBaselinePaint(this.baselinePaint);
        xYPlot.setDomainGridlinePaint(this.domainGridlinePaint);
        xYPlot.setRangeGridlinePaint(this.rangeGridlinePaint);
        xYPlot.setDomainCrosshairPaint(this.crosshairPaint);
        xYPlot.setRangeCrosshairPaint(this.crosshairPaint);
        xYPlot.setShadowGenerator(this.shadowGenerator);
        int n3 = xYPlot.getDomainAxisCount();
        for (n2 = 0; n2 < n3; ++n2) {
            ValueAxis valueAxis = xYPlot.getDomainAxis(n2);
            if (valueAxis == null) continue;
            this.applyToValueAxis(valueAxis);
        }
        n2 = xYPlot.getRangeAxisCount();
        for (n = 0; n < n2; ++n) {
            ValueAxis valueAxis = xYPlot.getRangeAxis(n);
            if (valueAxis == null) continue;
            this.applyToValueAxis(valueAxis);
        }
        n = xYPlot.getRendererCount();
        for (int i = 0; i < n; ++i) {
            xYItemRenderer2 = xYPlot.getRenderer(i);
            if (xYItemRenderer2 == null) continue;
            this.applyToXYItemRenderer(xYItemRenderer2);
        }
        for (XYItemRenderer xYItemRenderer2 : xYPlot.getAnnotations()) {
            this.applyToXYAnnotation((XYAnnotation)xYItemRenderer2);
        }
        if (xYPlot instanceof CombinedDomainXYPlot) {
            xYItemRenderer2 = (CombinedDomainXYPlot)xYPlot;
            for (XYPlot xYPlot2 : xYItemRenderer2.getSubplots()) {
                if (xYPlot2 == null) continue;
                this.applyToPlot((Plot)xYPlot2);
            }
        }
        if (xYPlot instanceof CombinedRangeXYPlot) {
            xYItemRenderer2 = (CombinedRangeXYPlot)xYPlot;
            for (XYPlot xYPlot2 : xYItemRenderer2.getSubplots()) {
                if (xYPlot2 == null) continue;
                this.applyToPlot((Plot)xYPlot2);
            }
        }
    }

    protected void applyToFastScatterPlot(FastScatterPlot fastScatterPlot) {
        ValueAxis valueAxis;
        fastScatterPlot.setDomainGridlinePaint(this.domainGridlinePaint);
        fastScatterPlot.setRangeGridlinePaint(this.rangeGridlinePaint);
        ValueAxis valueAxis2 = fastScatterPlot.getDomainAxis();
        if (valueAxis2 != null) {
            this.applyToValueAxis(valueAxis2);
        }
        if ((valueAxis = fastScatterPlot.getRangeAxis()) != null) {
            this.applyToValueAxis(valueAxis);
        }
    }

    protected void applyToPolarPlot(PolarPlot polarPlot) {
        polarPlot.setAngleLabelFont(this.regularFont);
        polarPlot.setAngleLabelPaint(this.tickLabelPaint);
        polarPlot.setAngleGridlinePaint(this.domainGridlinePaint);
        polarPlot.setRadiusGridlinePaint(this.rangeGridlinePaint);
        ValueAxis valueAxis = polarPlot.getAxis();
        if (valueAxis != null) {
            this.applyToValueAxis(valueAxis);
        }
    }

    protected void applyToSpiderWebPlot(SpiderWebPlot spiderWebPlot) {
        spiderWebPlot.setLabelFont(this.regularFont);
        spiderWebPlot.setLabelPaint(this.axisLabelPaint);
        spiderWebPlot.setAxisLinePaint(this.axisLabelPaint);
    }

    protected void applyToMeterPlot(MeterPlot meterPlot) {
        meterPlot.setDialBackgroundPaint(this.plotBackgroundPaint);
        meterPlot.setValueFont(this.largeFont);
        meterPlot.setValuePaint(this.axisLabelPaint);
        meterPlot.setDialOutlinePaint(this.plotOutlinePaint);
        meterPlot.setNeedlePaint(this.thermometerPaint);
        meterPlot.setTickLabelFont(this.regularFont);
        meterPlot.setTickLabelPaint(this.tickLabelPaint);
    }

    protected void applyToThermometerPlot(ThermometerPlot thermometerPlot) {
        thermometerPlot.setValueFont(this.largeFont);
        thermometerPlot.setThermometerPaint(this.thermometerPaint);
        ValueAxis valueAxis = thermometerPlot.getRangeAxis();
        if (valueAxis != null) {
            this.applyToValueAxis(valueAxis);
        }
    }

    protected void applyToCategoryAxis(CategoryAxis categoryAxis) {
        categoryAxis.setLabelFont(this.largeFont);
        categoryAxis.setLabelPaint(this.axisLabelPaint);
        categoryAxis.setTickLabelFont(this.regularFont);
        categoryAxis.setTickLabelPaint(this.tickLabelPaint);
        if (categoryAxis instanceof SubCategoryAxis) {
            SubCategoryAxis subCategoryAxis = (SubCategoryAxis)categoryAxis;
            subCategoryAxis.setSubLabelFont(this.regularFont);
            subCategoryAxis.setSubLabelPaint(this.tickLabelPaint);
        }
    }

    protected void applyToValueAxis(ValueAxis valueAxis) {
        valueAxis.setLabelFont(this.largeFont);
        valueAxis.setLabelPaint(this.axisLabelPaint);
        valueAxis.setTickLabelFont(this.regularFont);
        valueAxis.setTickLabelPaint(this.tickLabelPaint);
        if (valueAxis instanceof SymbolAxis) {
            this.applyToSymbolAxis((SymbolAxis)valueAxis);
        }
        if (valueAxis instanceof PeriodAxis) {
            this.applyToPeriodAxis((PeriodAxis)valueAxis);
        }
    }

    protected void applyToSymbolAxis(SymbolAxis symbolAxis) {
        symbolAxis.setGridBandPaint(this.gridBandPaint);
        symbolAxis.setGridBandAlternatePaint(this.gridBandAlternatePaint);
    }

    protected void applyToPeriodAxis(PeriodAxis periodAxis) {
        PeriodAxisLabelInfo[] periodAxisLabelInfoArray = periodAxis.getLabelInfo();
        for (int i = 0; i < periodAxisLabelInfoArray.length; ++i) {
            PeriodAxisLabelInfo periodAxisLabelInfo;
            PeriodAxisLabelInfo periodAxisLabelInfo2 = periodAxisLabelInfoArray[i];
            periodAxisLabelInfoArray[i] = periodAxisLabelInfo = new PeriodAxisLabelInfo(periodAxisLabelInfo2.getPeriodClass(), periodAxisLabelInfo2.getDateFormat(), periodAxisLabelInfo2.getPadding(), this.regularFont, this.tickLabelPaint, periodAxisLabelInfo2.getDrawDividers(), periodAxisLabelInfo2.getDividerStroke(), periodAxisLabelInfo2.getDividerPaint());
        }
        periodAxis.setLabelInfo(periodAxisLabelInfoArray);
    }

    protected void applyToAbstractRenderer(AbstractRenderer abstractRenderer) {
        if (abstractRenderer.getAutoPopulateSeriesPaint()) {
            abstractRenderer.clearSeriesPaints(false);
        }
        if (abstractRenderer.getAutoPopulateSeriesStroke()) {
            abstractRenderer.clearSeriesStrokes(false);
        }
    }

    protected void applyToCategoryItemRenderer(CategoryItemRenderer categoryItemRenderer) {
        BarRenderer barRenderer;
        ParamChecks.nullNotPermitted((Object)categoryItemRenderer, (String)"renderer");
        if (categoryItemRenderer instanceof AbstractRenderer) {
            this.applyToAbstractRenderer((AbstractRenderer)categoryItemRenderer);
        }
        categoryItemRenderer.setBaseItemLabelFont(this.regularFont);
        categoryItemRenderer.setBaseItemLabelPaint(this.itemLabelPaint);
        if (categoryItemRenderer instanceof BarRenderer) {
            barRenderer = (BarRenderer)categoryItemRenderer;
            barRenderer.setBarPainter(this.barPainter);
            barRenderer.setShadowVisible(this.shadowVisible);
            barRenderer.setShadowPaint(this.shadowPaint);
        }
        if (categoryItemRenderer instanceof BarRenderer3D) {
            barRenderer = (BarRenderer3D)categoryItemRenderer;
            barRenderer.setWallPaint(this.wallPaint);
        }
        if (categoryItemRenderer instanceof LineRenderer3D) {
            barRenderer = (LineRenderer3D)categoryItemRenderer;
            barRenderer.setWallPaint(this.wallPaint);
        }
        if (categoryItemRenderer instanceof StatisticalBarRenderer) {
            barRenderer = (StatisticalBarRenderer)categoryItemRenderer;
            barRenderer.setErrorIndicatorPaint(this.errorIndicatorPaint);
        }
        if (categoryItemRenderer instanceof MinMaxCategoryRenderer) {
            barRenderer = (MinMaxCategoryRenderer)categoryItemRenderer;
            barRenderer.setGroupPaint(this.errorIndicatorPaint);
        }
    }

    protected void applyToXYItemRenderer(XYItemRenderer xYItemRenderer) {
        ParamChecks.nullNotPermitted((Object)xYItemRenderer, (String)"renderer");
        if (xYItemRenderer instanceof AbstractRenderer) {
            this.applyToAbstractRenderer((AbstractRenderer)xYItemRenderer);
        }
        xYItemRenderer.setBaseItemLabelFont(this.regularFont);
        xYItemRenderer.setBaseItemLabelPaint(this.itemLabelPaint);
        if (xYItemRenderer instanceof XYBarRenderer) {
            XYBarRenderer xYBarRenderer = (XYBarRenderer)xYItemRenderer;
            xYBarRenderer.setBarPainter(this.xyBarPainter);
            xYBarRenderer.setShadowVisible(this.shadowVisible);
        }
    }

    protected void applyToXYAnnotation(XYAnnotation xYAnnotation) {
        ParamChecks.nullNotPermitted((Object)xYAnnotation, (String)"annotation");
        if (xYAnnotation instanceof XYTextAnnotation) {
            XYTextAnnotation xYTextAnnotation = (XYTextAnnotation)xYAnnotation;
            xYTextAnnotation.setFont(this.smallFont);
            xYTextAnnotation.setPaint(this.itemLabelPaint);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GpsMasterChartTheme)) {
            return false;
        }
        GpsMasterChartTheme gpsMasterChartTheme = (GpsMasterChartTheme)object;
        if (!this.name.equals(gpsMasterChartTheme.name)) {
            return false;
        }
        if (!this.extraLargeFont.equals(gpsMasterChartTheme.extraLargeFont)) {
            return false;
        }
        if (!this.largeFont.equals(gpsMasterChartTheme.largeFont)) {
            return false;
        }
        if (!this.regularFont.equals(gpsMasterChartTheme.regularFont)) {
            return false;
        }
        if (!this.smallFont.equals(gpsMasterChartTheme.smallFont)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.titlePaint, (Paint)gpsMasterChartTheme.titlePaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.subtitlePaint, (Paint)gpsMasterChartTheme.subtitlePaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.chartBackgroundPaint, (Paint)gpsMasterChartTheme.chartBackgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.legendBackgroundPaint, (Paint)gpsMasterChartTheme.legendBackgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.legendItemPaint, (Paint)gpsMasterChartTheme.legendItemPaint)) {
            return false;
        }
        if (!this.drawingSupplier.equals(gpsMasterChartTheme.drawingSupplier)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.plotBackgroundPaint, (Paint)gpsMasterChartTheme.plotBackgroundPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.plotOutlinePaint, (Paint)gpsMasterChartTheme.plotOutlinePaint)) {
            return false;
        }
        if (!this.labelLinkStyle.equals((Object)gpsMasterChartTheme.labelLinkStyle)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.labelLinkPaint, (Paint)gpsMasterChartTheme.labelLinkPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.domainGridlinePaint, (Paint)gpsMasterChartTheme.domainGridlinePaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.rangeGridlinePaint, (Paint)gpsMasterChartTheme.rangeGridlinePaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.crosshairPaint, (Paint)gpsMasterChartTheme.crosshairPaint)) {
            return false;
        }
        if (!this.axisOffset.equals((Object)gpsMasterChartTheme.axisOffset)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.axisLabelPaint, (Paint)gpsMasterChartTheme.axisLabelPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.tickLabelPaint, (Paint)gpsMasterChartTheme.tickLabelPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.itemLabelPaint, (Paint)gpsMasterChartTheme.itemLabelPaint)) {
            return false;
        }
        if (this.shadowVisible != gpsMasterChartTheme.shadowVisible) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.shadowPaint, (Paint)gpsMasterChartTheme.shadowPaint)) {
            return false;
        }
        if (!this.barPainter.equals(gpsMasterChartTheme.barPainter)) {
            return false;
        }
        if (!this.xyBarPainter.equals(gpsMasterChartTheme.xyBarPainter)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.thermometerPaint, (Paint)gpsMasterChartTheme.thermometerPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.wallPaint, (Paint)gpsMasterChartTheme.wallPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.errorIndicatorPaint, (Paint)gpsMasterChartTheme.errorIndicatorPaint)) {
            return false;
        }
        if (!PaintUtilities.equal((Paint)this.gridBandPaint, (Paint)gpsMasterChartTheme.gridBandPaint)) {
            return false;
        }
        return PaintUtilities.equal((Paint)this.gridBandAlternatePaint, (Paint)gpsMasterChartTheme.gridBandAlternatePaint);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.titlePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.subtitlePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.chartBackgroundPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.legendBackgroundPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.legendItemPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.plotBackgroundPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.plotOutlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.labelLinkPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.baselinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.domainGridlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.rangeGridlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.crosshairPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.axisLabelPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.tickLabelPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.itemLabelPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.shadowPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.thermometerPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.wallPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.errorIndicatorPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.gridBandPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.gridBandAlternatePaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.titlePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.subtitlePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.chartBackgroundPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.legendBackgroundPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.legendItemPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.plotBackgroundPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.plotOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.labelLinkPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.baselinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.domainGridlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.rangeGridlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.crosshairPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.axisLabelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.tickLabelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.itemLabelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.shadowPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.thermometerPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.wallPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.errorIndicatorPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.gridBandPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.gridBandAlternatePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
    }
}

