/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.chart;

import eu.fuegenstein.swing.JButtonlessComboBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SpringLayout;
import org.gpsmaster.GpsMaster;
import org.gpsmaster.chart.ChartAxis;
import org.gpsmaster.chart.InteractiveChart;
import org.gpsmaster.gpxpanel.Waypoint;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.RectangleEdge;

public class FloatableChartPanel
extends ChartPanel {
    private SpringLayout springLayout = new SpringLayout();
    private JLabel floatLabel = new JLabel();
    private JLabel titleLabel = new JLabel("Interactive Chart");
    private String iconPath = "/org/gpsmaster/icons/chart/";
    private ChartMouseListener mouseListener = null;
    private PropertyChangeListener changeListener = null;
    private JButtonlessComboBox<ChartAxis> xCombo = null;
    private JButtonlessComboBox<ChartAxis> yCombo = null;
    private ValueMarker marker = null;
    private boolean interactive = false;
    public static final int MODE_NONE = 0;
    public static final int MODE_FLOAT = 1;
    public static final int MODE_ATTACH = 2;
    private XYPlot plot = null;
    private static final long serialVersionUID = -4115882625036746218L;

    public FloatableChartPanel(JFreeChart jFreeChart) {
        super(jFreeChart);
        this.setLayout(this.springLayout);
        this.init();
        this.setDefaults();
    }

    public String getChartTitle() {
        return this.titleLabel.getText();
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean bl) {
        this.interactive = bl;
        if (bl) {
            this.interactiveOn();
        } else {
            this.interactiveOff();
        }
    }

    public void setChartTitle(String string) {
        if (string == null) {
            this.titleLabel.setVisible(false);
        } else {
            this.titleLabel.setText(string);
            this.titleLabel.setVisible(true);
        }
    }

    public JLabel getFloatComponent() {
        return this.floatLabel;
    }

    public void setFloatMode(int n) {
        switch (n) {
            case 0: {
                this.floatLabel.setVisible(false);
                break;
            }
            case 1: {
                this.floatLabel.setIcon(new ImageIcon(GpsMaster.class.getResource(this.iconPath.concat("tearoff.png"))));
                this.floatLabel.setToolTipText("Open chart in new window");
                this.floatLabel.setVisible(true);
                break;
            }
            case 2: {
                this.floatLabel.setIcon(new ImageIcon(GpsMaster.class.getResource(this.iconPath.concat("glueback.png"))));
                this.floatLabel.setToolTipText("Attach chart to map msgPanel");
                this.floatLabel.setVisible(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported tear action");
            }
        }
    }

    public JButtonlessComboBox<ChartAxis> getxCombo() {
        return this.xCombo;
    }

    public JButtonlessComboBox<ChartAxis> getyCombo() {
        return this.yCombo;
    }

    private void setDefaults() {
        this.setMaximumDrawHeight(99999);
        this.setMaximumDrawWidth(99999);
        this.setMinimumDrawHeight(1);
        this.setMinimumDrawWidth(1);
    }

    private void init() {
        this.springLayout.putConstraint("North", (Component)this.floatLabel, 0, "North", (Component)((Object)this));
        this.springLayout.putConstraint("East", (Component)this.floatLabel, 0, "East", (Component)((Object)this));
        this.floatLabel.setVisible(false);
        this.add(this.floatLabel);
        this.springLayout.putConstraint("North", (Component)this.titleLabel, 5, "North", (Component)((Object)this));
        this.springLayout.putConstraint("HorizontalCenter", (Component)this.titleLabel, 0, "HorizontalCenter", (Component)((Object)this));
        Font font = new Font(this.getFont().getFontName(), 1, this.getFont().getSize() + 2);
        this.titleLabel.setFont(font);
        this.titleLabel.setVisible(false);
        this.titleLabel.setOpaque(true);
        this.titleLabel.setBackground(Color.WHITE);
        this.add(this.titleLabel);
        this.xCombo = new JButtonlessComboBox();
        this.springLayout.putConstraint("South", this.xCombo, -50, "South", (Component)((Object)this));
        this.springLayout.putConstraint("East", this.xCombo, 10, "East", (Component)((Object)this));
        this.add(this.xCombo);
        this.yCombo = new JButtonlessComboBox();
        this.springLayout.putConstraint("North", this.yCombo, 10, "North", (Component)((Object)this));
        this.springLayout.putConstraint("West", this.yCombo, 50, "West", (Component)((Object)this));
        this.add(this.yCombo);
        this.plot = (XYPlot)this.getChart().getPlot();
    }

    private void interactiveOn() {
        if (this.marker == null) {
            this.marker = new ValueMarker(0.0);
            this.marker.setPaint((Paint)Color.BLACK);
            this.plot.addDomainMarker((Marker)this.marker);
        }
        if (this.mouseListener == null) {
            this.mouseListener = new ChartMouseListener(){

                public void chartMouseMoved(ChartMouseEvent chartMouseEvent) {
                    if (FloatableChartPanel.this.interactive) {
                        FloatableChartPanel.this.highlightWaypoint(chartMouseEvent);
                    }
                }

                public void chartMouseClicked(ChartMouseEvent chartMouseEvent) {
                }
            };
            this.addChartMouseListener(this.mouseListener);
        }
        if (this.changeListener == null) {
            this.changeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("activeTrkPt")) {
                        FloatableChartPanel.this.highlightDomain(propertyChangeEvent);
                    }
                }
            };
            GpsMaster.active.addPropertyChangeListener(this.changeListener);
        }
    }

    private void interactiveOff() {
        if (this.mouseListener != null) {
            this.removeChartMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        if (this.marker != null) {
            this.plot.removeDomainMarker((Marker)this.marker);
            this.marker = null;
        }
        if (this.changeListener != null) {
            GpsMaster.active.removePropertyChangeListener(this.changeListener);
        }
    }

    private void highlightWaypoint(ChartMouseEvent chartMouseEvent) {
        InteractiveChart interactiveChart = (InteractiveChart)this.getChart();
        ValueAxis valueAxis = this.plot.getDomainAxis();
        Rectangle2D rectangle2D = this.getScreenDataArea();
        double d = valueAxis.java2DToValue((double)chartMouseEvent.getTrigger().getX(), rectangle2D, RectangleEdge.BOTTOM);
        this.marker.setValue(d);
        Waypoint waypoint = interactiveChart.getChartDataset().getWaypointForX(d);
        if (waypoint != null) {
            GpsMaster.active.setTrackpoint(waypoint, false);
        }
    }

    private void highlightDomain(PropertyChangeEvent propertyChangeEvent) {
        InteractiveChart interactiveChart;
        double d;
        Waypoint waypoint = GpsMaster.active.getTrackpoint();
        if (waypoint != null && (d = (interactiveChart = (InteractiveChart)this.getChart()).getChartDataset().lookupXValue(waypoint)) != Double.NaN) {
            this.marker.setValue(d);
        }
    }
}

