/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster.chart;

import eu.fuegenstein.unit.UnitConverter;
import java.util.Hashtable;
import org.gpsmaster.chart.ChartAxis;
import org.gpsmaster.gpxpanel.Waypoint;
import org.jfree.chart.axis.AxisLabelLocation;
import org.jfree.ui.RectangleInsets;

public abstract class ChartXAxis
extends ChartAxis {
    protected Hashtable<Waypoint, Double> cache = null;

    public ChartXAxis(UnitConverter unitConverter) {
        super(unitConverter);
    }

    @Override
    protected void setDefaults() {
        super.setDefaults();
        this.valueAxis.setLowerMargin(0.0);
        this.valueAxis.setUpperMargin(0.0);
        this.valueAxis.setLabelLocation(AxisLabelLocation.HIGH_END);
        this.valueAxis.setTickLabelInsets(new RectangleInsets(0.0, 2.0, 0.0, 2.0));
        this.valueAxis.setLabelInsets(new RectangleInsets(0.0, 0.0, 2.0, 5.0));
    }

    protected void enableCaching() {
        if (this.cache == null) {
            this.cache = new Hashtable();
        }
    }

    public double lookupValue(Waypoint waypoint) {
        double d = Double.NaN;
        if (waypoint != null) {
            if (this.cache == null) {
                d = this.getValue(waypoint);
            } else if (this.cache.containsKey(waypoint)) {
                d = this.cache.get(waypoint);
            }
        }
        return d;
    }

    protected void cache(Waypoint waypoint, double d) {
        if (this.cache != null) {
            this.cache.put(waypoint, d);
        }
    }
}

