/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster;

import java.awt.Color;
import java.util.List;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.marker.MeasureMarker;

public class MeasurePoint
implements Comparable<MeasurePoint> {
    private Waypoint waypoint = null;
    private MeasureMarker marker = null;
    private int groupIdx = -1;
    private int pointIdx = -1;
    private Color color = Color.DARK_GRAY;

    public MeasurePoint() {
    }

    public MeasurePoint(Waypoint waypoint, MeasureMarker measureMarker) {
        this.waypoint = waypoint;
        this.marker = measureMarker;
    }

    public Waypoint getWaypoint() {
        return this.waypoint;
    }

    public void setWaypoint(Waypoint waypoint) {
        this.waypoint = waypoint;
    }

    public MeasureMarker getMarker() {
        return this.marker;
    }

    public void setMarker(MeasureMarker measureMarker) {
        this.marker = measureMarker;
    }

    public int getGroupIdx() {
        return this.groupIdx;
    }

    public void setGroupIdx(int n) {
        this.groupIdx = n;
    }

    public int getPointIdx() {
        return this.pointIdx;
    }

    public void setPointIdx(int n) {
        this.pointIdx = n;
    }

    public void setIndexesFrom(List<WaypointGroup> list) throws Exception {
        this.groupIdx = -1;
        this.pointIdx = -1;
        for (WaypointGroup waypointGroup : list) {
            if (!waypointGroup.getWaypoints().contains(this.waypoint)) continue;
            this.groupIdx = list.indexOf(waypointGroup);
            this.pointIdx = waypointGroup.getWaypoints().indexOf(this.waypoint);
        }
        if (this.groupIdx == -1) {
            throw new Exception();
        }
    }

    @Override
    public int compareTo(MeasurePoint measurePoint) {
        if (this.groupIdx < measurePoint.groupIdx) {
            return -1;
        }
        if (this.groupIdx > measurePoint.groupIdx) {
            return 1;
        }
        if (this.pointIdx < measurePoint.pointIdx) {
            return -1;
        }
        if (this.pointIdx > measurePoint.pointIdx) {
            return 1;
        }
        return 0;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

