/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster;

import com.topografix.gpx._1._1.LinkType;
import eu.fuegenstein.messagecenter.MessageCenter;
import eu.fuegenstein.messagecenter.MessagePanel;
import eu.fuegenstein.swing.CustomColorChooser;
import eu.fuegenstein.swing.NamedColor;
import eu.fuegenstein.swing.WidgetLayout;
import eu.fuegenstein.unit.UnitConverter;
import eu.fuegenstein.unit.UnitFactory;
import eu.fuegenstein.unit.UnitSet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.gpsmaster.ActiveGpxObjects;
import org.gpsmaster.ActivityHandler;
import org.gpsmaster.Config;
import org.gpsmaster.Core;
import org.gpsmaster.MapPrinter;
import org.gpsmaster.MeasureThings;
import org.gpsmaster.OnlineTileSource;
import org.gpsmaster.TrackSlider;
import org.gpsmaster.chart.ChartHandler;
import org.gpsmaster.chart.ChartWindow;
import org.gpsmaster.db.DbLayer;
import org.gpsmaster.db.DbTarget;
import org.gpsmaster.device.MoveBikeCompMPT;
import org.gpsmaster.dialogs.BrowserLauncher;
import org.gpsmaster.dialogs.CleaningDialog;
import org.gpsmaster.dialogs.DBDialog;
import org.gpsmaster.dialogs.EditPropsDialog;
import org.gpsmaster.dialogs.FileOpenDialog;
import org.gpsmaster.dialogs.GenericDialog;
import org.gpsmaster.dialogs.GenericDownloadDialog;
import org.gpsmaster.dialogs.GpxPropertiesPanel;
import org.gpsmaster.dialogs.ImageViewer;
import org.gpsmaster.dialogs.InfoDialog;
import org.gpsmaster.dialogs.NameSearchPanel;
import org.gpsmaster.dialogs.TimeshiftDialog;
import org.gpsmaster.dialogs.TransferStatusDialog;
import org.gpsmaster.elevation.Corrector;
import org.gpsmaster.elevation.MapQuestProvider;
import org.gpsmaster.filehub.FileHub;
import org.gpsmaster.filehub.FileSource;
import org.gpsmaster.filehub.FileTarget;
import org.gpsmaster.filehub.IItemTarget;
import org.gpsmaster.filehub.MapTarget;
import org.gpsmaster.filehub.TransferableItem;
import org.gpsmaster.gpsloader.FileDropHandler;
import org.gpsmaster.gpsloader.GpsLoader;
import org.gpsmaster.gpsloader.GpsLoaderFactory;
import org.gpsmaster.gpsloader.LoaderConfig;
import org.gpsmaster.gpxpanel.ArrowType;
import org.gpsmaster.gpxpanel.GPXExtension;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.GPXPanel;
import org.gpsmaster.gpxpanel.GPXRoot;
import org.gpsmaster.gpxpanel.ProgressType;
import org.gpsmaster.gpxpanel.Route;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.marker.Marker;
import org.gpsmaster.marker.PhotoMarker;
import org.gpsmaster.marker.WaypointMarker;
import org.gpsmaster.marker.WikiMarker;
import org.gpsmaster.online.DownloadGpsies;
import org.gpsmaster.online.DownloadOsm;
import org.gpsmaster.online.GetWikipedia;
import org.gpsmaster.online.OnlineTrack;
import org.gpsmaster.online.UploadGpsies;
import org.gpsmaster.painter.ArrowPainter;
import org.gpsmaster.painter.DirectDistancePainter;
import org.gpsmaster.painter.ProgressPainter;
import org.gpsmaster.painter.StartEndPainter;
import org.gpsmaster.painter.TrackPainter;
import org.gpsmaster.painter.WaypointPainter;
import org.gpsmaster.pathfinder.PathFinder;
import org.gpsmaster.pathfinder.RouteProviderFactory;
import org.gpsmaster.tree.GPXTree;
import org.gpsmaster.tree.GPXTreeRenderer;
import org.gpsmaster.undo.IUndoable;
import org.gpsmaster.undo.UndoAddRoute;
import org.gpsmaster.undo.UndoAddWaypoint;
import org.gpsmaster.undo.UndoRemoveWaypoint;
import org.gpsmaster.undo.UndoSplitTrackSeg;
import org.gpsmaster.widget.DistanceWidget;
import org.gpsmaster.widget.PathFinderWidget;
import org.gpsmaster.widget.ProgressWidget;
import org.gpsmaster.widget.ScalebarWidget;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.events.JMVCommandEvent;
import org.openstreetmap.gui.jmapviewer.interfaces.JMapViewerEventListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TemplatedTMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public class GpsMaster
extends JComponent {
    public static final String PROGRAM_NAME = "GpsMaster";
    public static final String VERSION_NUMBER = "0.63.31";
    public static final String ME = "GpsMaster 0.63.31";
    private JFrame frame;
    private static String lookAndFeel;
    private JPanel menuBarsPanel;
    private JToolBar toolBarMain;
    private JButton btnFileNew;
    private JButton btnFileOpen;
    private JToggleButton tglDownload;
    private JButton btnFileSave;
    private JButton btnPrint;
    private JButton btnUndo;
    private JFileChooser chooserFileSave;
    private File fileSave;
    private JButton btnObjectDelete;
    private JButton btnEditProperties;
    private JToggleButton tglPathFinder;
    private JToggleButton tglAddRoutepoint;
    private JToggleButton tglDelPoints;
    private JToggleButton tglSplitTrackseg;
    private JToggleButton tglMeasure;
    private JToggleButton tglProgress;
    private JToggleButton tglArrows;
    private JButton btnTimeShift;
    private JButton btnCorrectEle;
    private JToggleButton tglChart;
    private JButton btnLogWindow;
    private JToggleButton tglToolbar;
    private JButton btnInfo;
    private JComboBox<TileSource> comboBoxTileSource;
    private JLabel lblLat;
    private JTextField textFieldLat;
    private JLabel lblLon;
    private JTextField textFieldLon;
    private JToggleButton tglLatLonFocus;
    private JToggleButton tglAutoFit;
    private JToolBar toolBarSide;
    private JButton btnCleaning;
    private JButton btnMergeOneToOne;
    private JButton btnMergeToMulti;
    private JButton btnMergeToSingle;
    private JButton btnMergeParallel;
    private JToggleButton tglAddWaypoint;
    private JToolBar toolBarDownload;
    private JButton btnDeviceOpen;
    private JButton btnDatabase;
    private JButton btnDownloadOsm;
    private JButton btnDownloadGpsies;
    private JButton btnUploadGpsies;
    private JButton btndownloadWiki;
    private JSplitPane splitPaneMain;
    private JSplitPane splitPaneSidebar;
    private JPanel containerLeftSidebarTop;
    private JPanel containerExplorerHeading;
    private JLabel labelExplorerHeading;
    private JScrollPane scrollPaneExplorer;
    private GPXTree tree;
    private NameSearchPanel searchPanel;
    private JPanel containerLeftSidebarBottom;
    private JSplitPane splitPaneSideCenter = new JSplitPane();
    private JPanel containerPropertiesHeading;
    private JLabel labelPropertiesHeading;
    private JScrollPane scrollPaneProperties;
    private JSplitPane splitPaneMap;
    private GPXPanel mapPanel;
    private ChartWindow chartWindow;
    private Container contentPane;
    private Cursor mapCursor;
    private boolean mouseOverLink;
    private DistanceWidget distanceWidget = null;
    private TrackSlider trackSlider = null;
    private final double mapToChartRatio = 0.85f;
    private Core core = new Core();
    private MessageCenter msg = null;
    private Config conf;
    public UnitConverter uc = new UnitConverter();
    public static ActiveGpxObjects active;
    private String configFilename = "./GpsMaster.config";
    private GpsLoaderFactory loaderFactory = new GpsLoaderFactory();
    private ActivityHandler activityHandler = null;
    private TransferStatusDialog transferStatusDialog = null;
    private ImageViewer imageViewer = null;
    private MeasureThings measure = null;
    private PathFinder pathFinder = null;
    private PathFinderWidget pathFinderWidget = null;
    private ChartHandler chartHandler = null;
    private ProgressPainter progressPainter = null;
    private ArrowPainter arrowPainter = null;
    private DbLayer db = null;
    private PropertyChangeListener propertyListener = null;
    private WindowAdapter windowListener = null;
    private FileDropHandler dropHandler = null;
    private final MapTarget transferTargetMap = null;
    private final FileHub centralFileHub = new FileHub();
    private final List<IItemTarget> centralTargets = new ArrayList<IItemTarget>();
    private List<JToggleButton> toggles = new ArrayList<JToggleButton>();
    private boolean autoFitToPanel = true;
    private MessagePanel routeInfoPanel = null;
    private final Cursor WAIT_CURSOR = new Cursor(3);
    private final Cursor CROSSHAIR_CURSOR = new Cursor(1);
    private final Cursor DEFAULT_CURSOR = new Cursor(0);
    private Corrector eleCorr = null;
    private final Color MENU_BACKGROUND = Color.WHITE;

    public static void main(String[] stringArray) {
        try {
            lookAndFeel = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    GpsMaster gpsMaster = new GpsMaster();
                    gpsMaster.frame.setVisible(true);
                    gpsMaster.frame.requestFocusInWindow();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public GpsMaster() {
        this.initialize();
    }

    private void initialize() {
        Object object;
        this.frame = new JFrame(ME);
        this.contentPane = this.frame.getContentPane();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        int n3 = n * 3 / 4;
        int n4 = n2 * 3 / 4;
        this.frame.setBounds((n - n3) / 2, (n2 - n4) / 2, n3, n4);
        this.frame.setPreferredSize(new Dimension(n3, n4));
        this.frame.setDefaultCloseOperation(3);
        this.frame.setIconImage(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/gpsmaster.png")).getImage());
        this.propertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GpsMaster.this.handlePropertyChangeEvent(propertyChangeEvent);
            }
        };
        this.addPropertyChangeListener(this.propertyListener);
        this.windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GpsMaster.this.handleWindowEvent(windowEvent, 201);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                GpsMaster.this.handleWindowEvent(windowEvent, 202);
            }
        };
        this.msg = new MessageCenter(this.frame);
        this.loadConfig();
        this.msg.setScreenTime(this.conf.getScreenTime());
        this.setupTree();
        active = new ActiveGpxObjects(this.tree);
        active.addPropertyChangeListener(this.propertyListener);
        this.setupUnits();
        this.setupPanels();
        this.setupMenuBar();
        this.setupDownloadBar();
        this.setupToolbar();
        this.setupDatabase();
        this.mapPanel.setGpxFiles(active.getGpxFiles());
        if (!this.conf.getProxyHost().isEmpty() && this.conf.getProxyPort() > 0) {
            object = System.getProperties();
            ((Properties)object).setProperty("http.proxyHost", this.conf.getProxyHost());
            ((Properties)object).setProperty("http.proxyPort", Integer.toString(this.conf.getProxyPort()));
            ((Properties)object).setProperty("https.proxyHost", this.conf.getProxyHost());
            ((Properties)object).setProperty("https.proxyPort", Integer.toString(this.conf.getProxyPort()));
        }
        if (this.conf.getActivitySupport()) {
            this.activityHandler = new ActivityHandler(this.mapPanel, this.contentPane, this.msg);
            this.activityHandler.getWidget().setAlignmentY(0.0f);
        }
        if (this.conf.isShowScalebar()) {
            object = new ScalebarWidget(this.mapPanel, this.uc);
            this.mapPanel.add((Component)object);
        }
        object = new MapTarget();
        ((MapTarget)object).setEnabled(true);
        ((MapTarget)object).AddPropertyChangeListener(this.propertyListener);
        this.centralTargets.add((IItemTarget)object);
        FileTarget fileTarget = new FileTarget();
        fileTarget.setEnabled(false);
        this.centralTargets.add(fileTarget);
        if (this.db != null) {
            DbTarget dbTarget = new DbTarget(this.db);
            dbTarget.setEnabled(false);
            this.centralTargets.add(dbTarget);
        }
        this.centralFileHub.setItemSource(new FileSource());
        this.setupFileHub(this.centralFileHub, this.centralTargets);
        this.transferStatusDialog = new TransferStatusDialog(this.frame);
        this.transferStatusDialog.addPropertyChangeListener(this.propertyListener);
        this.transferStatusDialog.setVisible(false);
        this.transferStatusDialog.begin();
        this.dropHandler = new FileDropHandler(this.centralFileHub, this.msg);
        this.mapPanel.setTransferHandler(this.dropHandler);
        this.mapPanel.addPropertyChangeListener(this.propertyListener);
        this.mapPanel.addJMVListener(new JMapViewerEventListener(){

            @Override
            public void processCommand(JMVCommandEvent jMVCommandEvent) {
                System.out.println((Object)jMVCommandEvent.getCommand());
            }
        });
        this.preloadChart();
    }

    private void setupUnits() {
        UnitSet unitSet = new UnitSet();
        this.uc.setTargetSet(unitSet);
        this.uc.setSourceSet(UnitFactory.getMetricSet());
        this.uc.setSymbolPrefix(" ");
        switch (this.conf.getUnitSystem()) {
            case METRIC: {
                UnitFactory.METER.setUpperUnit(UnitFactory.KILOMETER);
                UnitFactory.KILOMETER.setLowerUnit(UnitFactory.METER);
                unitSet.setDistanceUnit(UnitFactory.KILOMETER);
                unitSet.setSpeedUnit(UnitFactory.KILOMETERS_PER_HOUR);
                unitSet.setElevationUnit(UnitFactory.METER);
                unitSet.setVerticalSpeedUnit(UnitFactory.METERS_PER_HOUR);
                break;
            }
            case IMPERIAL: {
                UnitFactory.FOOT.setUpperUnit(UnitFactory.MILE);
                UnitFactory.MILE.setLowerUnit(UnitFactory.FOOT);
                unitSet.setDistanceUnit(UnitFactory.MILE);
                unitSet.setSpeedUnit(UnitFactory.MILES_PER_HOUR);
                unitSet.setElevationUnit(UnitFactory.FOOT);
                unitSet.setVerticalSpeedUnit(UnitFactory.FEET_PER_HOUR);
                break;
            }
            case NAUTICAL: {
                UnitFactory.FOOT.setUpperUnit(UnitFactory.NAUTICAL_MILE);
                UnitFactory.FOOT.setUpperThreshold(6076.1201171875);
                UnitFactory.NAUTICAL_MILE.setLowerUnit(UnitFactory.FOOT);
                unitSet.setDistanceUnit(UnitFactory.NAUTICAL_MILE);
                unitSet.setSpeedUnit(UnitFactory.KNOTS);
                unitSet.setElevationUnit(UnitFactory.FOOT);
                unitSet.setVerticalSpeedUnit(UnitFactory.FEET_PER_HOUR);
                break;
            }
            default: {
                throw new UnsupportedOperationException("UnitSystem");
            }
        }
    }

    private void setupTree() {
        GPXRoot gPXRoot = new GPXRoot();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(gPXRoot);
        this.tree = new GPXTree(defaultTreeModel);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new GPXTreeRenderer());
        this.tree.putClientProperty("JTree.lineStyle", "None");
        this.tree.setBackground(Color.white);
        this.tree.setToggleClickCount(0);
        ImageIcon imageIcon = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/tree/tree-collapsed.png"));
        ImageIcon imageIcon2 = new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/tree/tree-expanded.png"));
        UIManager.put("Tree.collapsedIcon", imageIcon);
        UIManager.put("Tree.expandedIcon", imageIcon2);
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            SwingUtilities.updateComponentTreeUI(this.tree);
        }
        catch (Exception exception) {
            this.msg.error(exception);
        }
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception exception) {
            this.msg.error(exception);
        }
        this.tree.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                GpsMaster.this.mapPanel.repaint();
            }
        });
        CustomColorChooser customColorChooser = new CustomColorChooser();
        customColorChooser.setCustomColors(this.conf.getPalette());
        this.tree.setColorChooser(customColorChooser);
        this.tree.addPropertyChangeListener(this.propertyListener);
    }

    private void setupPanels() {
        this.menuBarsPanel = new JPanel();
        this.menuBarsPanel.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.menuBarsPanel, "North");
        this.splitPaneMain = new JSplitPane();
        this.splitPaneMain.setContinuousLayout(true);
        this.contentPane.add((Component)this.splitPaneMain, "Center");
        this.mapPanel = new GPXPanel(this.uc, this.msg);
        WidgetLayout widgetLayout = new WidgetLayout();
        widgetLayout.setCornerOffset(2, new Point(0, -20));
        widgetLayout.setCornerOffset(3, new Point(0, -20));
        widgetLayout.setCornerOrientation(2, 1);
        this.mapPanel.setLayout(widgetLayout);
        this.mapPanel.setAlignmentY(0.0f);
        this.mapPanel.setAlignmentX(0.0f);
        this.mapPanel.setDisplayPosition(new Coordinate(this.conf.getLat(), this.conf.getLon()), this.conf.getPositionZoom());
        this.mapPanel.setZoomContolsVisible(this.conf.getZoomControls());
        if (this.mapPanel.getZoomControlsVisible()) {
            widgetLayout.setCornerOffset(0, new Point(35, 0));
        }
        TrackPainter trackPainter = new TrackPainter();
        trackPainter.setLineWidth(this.conf.getTrackLineWidth());
        this.mapPanel.addPainter(trackPainter);
        WaypointPainter waypointPainter = new WaypointPainter();
        this.mapPanel.addPainter(waypointPainter);
        this.progressPainter = new ProgressPainter(this.uc);
        this.mapPanel.addPainter(this.progressPainter);
        this.arrowPainter = new ArrowPainter();
        this.mapPanel.addPainter(this.arrowPainter);
        if (this.conf.isShowStartEnd()) {
            this.mapPanel.addPainter(new StartEndPainter());
        }
        try {
            this.mapPanel.setTileLoader(new OsmTileLoader(this.mapPanel));
        }
        catch (Exception exception) {
            this.msg.error("There was a problem constructing the tile cache on disk", exception);
        }
        this.mapPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    GpsMaster.this.mapPanel.getAttribution().handleAttribution(mouseEvent.getPoint(), true);
                }
            }
        });
        this.mapCursor = this.DEFAULT_CURSOR;
        this.mapPanel.setCursor(this.mapCursor);
        this.mapPanel.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                boolean bl = GpsMaster.this.mapPanel.getAttribution().handleAttributionCursor(mouseEvent.getPoint());
                if (bl) {
                    GpsMaster.this.mapPanel.setCursor(new Cursor(12));
                    GpsMaster.this.mouseOverLink = true;
                } else {
                    GpsMaster.this.mapPanel.setCursor(GpsMaster.this.mapCursor);
                    GpsMaster.this.mouseOverLink = false;
                }
            }
        });
        String string = "zoom in";
        this.mapPanel.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), string);
        this.mapPanel.getInputMap(0).put(KeyStroke.getKeyStroke(521, 0), string);
        this.mapPanel.getInputMap(0).put(KeyStroke.getKeyStroke(107, 0), string);
        this.mapPanel.getActionMap().put(string, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.mapPanel.zoomIn();
            }
        });
        String string2 = "zoom out";
        this.mapPanel.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), string2);
        this.mapPanel.getInputMap(0).put(KeyStroke.getKeyStroke(45, 0), string2);
        this.mapPanel.getInputMap(0).put(KeyStroke.getKeyStroke(109, 0), string2);
        this.mapPanel.getActionMap().put(string2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.mapPanel.zoomOut();
            }
        });
        this.mapPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                GpsMaster.this.mapPanel.requestFocus();
            }
        });
        this.splitPaneSidebar = new JSplitPane();
        this.splitPaneSidebar.setMinimumSize(new Dimension(240, 25));
        this.splitPaneSidebar.setPreferredSize(new Dimension(270, 25));
        this.splitPaneSidebar.setContinuousLayout(true);
        this.splitPaneSidebar.setOrientation(0);
        this.splitPaneMain.setLeftComponent(this.splitPaneSidebar);
        this.containerLeftSidebarTop = new JPanel();
        this.containerLeftSidebarTop.setAlignmentY(0.0f);
        this.containerLeftSidebarTop.setAlignmentX(0.0f);
        this.containerLeftSidebarTop.setLayout(new BoxLayout(this.containerLeftSidebarTop, 1));
        this.containerExplorerHeading = new JPanel();
        this.containerExplorerHeading.setPreferredSize(new Dimension(10, 23));
        this.containerExplorerHeading.setMinimumSize(new Dimension(10, 23));
        this.containerExplorerHeading.setMaximumSize(new Dimension(Short.MAX_VALUE, 23));
        this.containerExplorerHeading.setAlignmentY(0.0f);
        this.containerExplorerHeading.setAlignmentX(0.0f);
        this.containerExplorerHeading.setCursor(this.DEFAULT_CURSOR);
        this.containerExplorerHeading.setLayout(new BoxLayout(this.containerExplorerHeading, 1));
        this.containerExplorerHeading.setBorder(new CompoundBorder(new MatteBorder(1, 1, 0, 1, new Color(0, 0, 0)), new EmptyBorder(2, 5, 5, 5)));
        this.containerLeftSidebarTop.add(this.containerExplorerHeading);
        this.labelExplorerHeading = new JLabel("Explorer");
        this.labelExplorerHeading.setAlignmentX(0.0f);
        this.labelExplorerHeading.setAlignmentY(0.0f);
        this.labelExplorerHeading.setMaximumSize(new Dimension(Short.MAX_VALUE, 14));
        this.labelExplorerHeading.setHorizontalTextPosition(2);
        this.labelExplorerHeading.setHorizontalAlignment(2);
        this.labelExplorerHeading.setFont(new Font("Segoe UI", 1, 12));
        this.containerExplorerHeading.add(this.labelExplorerHeading);
        UIManager.put("ScrollBar.minimumThumbSize", new Dimension(16, 16));
        this.scrollPaneExplorer = new JScrollPane(this.tree);
        this.scrollPaneExplorer.setAlignmentX(0.0f);
        this.scrollPaneExplorer.setAlignmentY(0.0f);
        this.scrollPaneExplorer.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.scrollPaneExplorer.setMinimumSize(new Dimension(Short.MAX_VALUE, 200));
        this.containerLeftSidebarTop.add(this.scrollPaneExplorer);
        this.trackSlider = new TrackSlider();
        this.trackSlider.setAlignmentX(0.0f);
        this.trackSlider.setPaintTicks(false);
        this.trackSlider.setPaintLabels(false);
        this.containerLeftSidebarTop.add(this.trackSlider);
        this.splitPaneSidebar.setTopComponent(this.containerLeftSidebarTop);
        this.splitPaneSideCenter.setContinuousLayout(true);
        this.splitPaneSideCenter.setOrientation(0);
        this.splitPaneSideCenter.setOneTouchExpandable(false);
        this.searchPanel = new NameSearchPanel(this.msg);
        this.searchPanel.setAlignmentX(0.0f);
        this.searchPanel.setAlignmentY(1.0f);
        this.searchPanel.setBorder(new CompoundBorder(new MatteBorder(1, 1, 0, 1, new Color(0, 0, 0)), new EmptyBorder(2, 5, 5, 5)));
        this.searchPanel.addPropertyChangeListener(this.propertyListener);
        this.splitPaneSideCenter.setTopComponent(this.searchPanel);
        this.splitPaneSideCenter.setResizeWeight(0.1f);
        this.containerLeftSidebarBottom = new JPanel();
        this.containerLeftSidebarBottom.setAlignmentY(0.0f);
        this.containerLeftSidebarBottom.setAlignmentX(0.0f);
        this.containerLeftSidebarBottom.setLayout(new BoxLayout(this.containerLeftSidebarBottom, 1));
        this.splitPaneSidebar.setBottomComponent(this.containerLeftSidebarBottom);
        this.containerPropertiesHeading = new JPanel();
        this.containerPropertiesHeading.setMaximumSize(new Dimension(Short.MAX_VALUE, 23));
        this.containerPropertiesHeading.setMinimumSize(new Dimension(10, 23));
        this.containerPropertiesHeading.setPreferredSize(new Dimension(10, 23));
        this.containerPropertiesHeading.setAlignmentY(0.0f);
        this.containerPropertiesHeading.setAlignmentX(0.0f);
        this.containerPropertiesHeading.setCursor(this.DEFAULT_CURSOR);
        this.containerPropertiesHeading.setLayout(new BoxLayout(this.containerPropertiesHeading, 1));
        this.containerPropertiesHeading.setBorder(new CompoundBorder(new MatteBorder(1, 1, 0, 1, new Color(0, 0, 0)), new EmptyBorder(2, 5, 5, 5)));
        this.containerLeftSidebarBottom.add(this.containerPropertiesHeading);
        this.labelPropertiesHeading = new JLabel("Properties");
        this.labelPropertiesHeading.setMaximumSize(new Dimension(Short.MAX_VALUE, 14));
        this.labelPropertiesHeading.setHorizontalTextPosition(2);
        this.labelPropertiesHeading.setHorizontalAlignment(2);
        this.labelPropertiesHeading.setFont(new Font("Segoe UI", 1, 12));
        this.labelPropertiesHeading.setAlignmentY(0.0f);
        this.containerPropertiesHeading.add(this.labelPropertiesHeading);
        GpxPropertiesPanel gpxPropertiesPanel = new GpxPropertiesPanel(this.uc);
        gpxPropertiesPanel.setAlignmentY(0.0f);
        gpxPropertiesPanel.setAlignmentX(0.0f);
        this.scrollPaneProperties = new JScrollPane(gpxPropertiesPanel);
        this.scrollPaneProperties.setAlignmentY(0.0f);
        this.scrollPaneProperties.setAlignmentX(0.0f);
        this.scrollPaneProperties.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.containerLeftSidebarBottom.add(this.scrollPaneProperties);
        this.splitPaneSideCenter.setBottomComponent(this.containerLeftSidebarBottom);
        this.splitPaneSidebar.setBottomComponent(this.splitPaneSideCenter);
        this.splitPaneMap = new JSplitPane();
        this.splitPaneMap.setOrientation(0);
        this.splitPaneMap.setTopComponent(this.mapPanel);
        this.splitPaneMain.setRightComponent(this.splitPaneMap);
        this.splitPaneMap.setBottomComponent(null);
    }

    private void setupDownloadBar() {
        this.toolBarDownload = new JToolBar();
        this.toolBarDownload.setVisible(false);
        this.btnDeviceOpen = new JButton("");
        this.btnDeviceOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.getFromDevice();
            }
        });
        this.btnDeviceOpen.setToolTipText("<html>Get Data from Device<br>[CTRL+G]</html>");
        this.btnDeviceOpen.setFocusable(false);
        this.btnDeviceOpen.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/downloadbar/".concat("file-device.png"))));
        this.btnDeviceOpen.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/downloadbar/".concat("file-device-disabled.png"))));
        String string = "CTRL+G";
        this.mapPanel.getInputMap(2).put(KeyStroke.getKeyStroke(71, 128), string);
        this.mapPanel.getActionMap().put(string, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.getFromDevice();
            }
        });
        this.toolBarDownload.add(this.btnDeviceOpen);
        this.btnDeviceOpen.setEnabled(false);
        this.btnDatabase = new JButton("");
        this.btnDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.openDbDialog();
            }
        });
        this.btnDatabase.setToolTipText("<html>Access GPS Database<br></html>");
        this.btnDatabase.setFocusable(false);
        this.btnDatabase.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/downloadbar/".concat("database.png"))));
        this.btnDatabase.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/downloadbar/".concat("database-disabled.png"))));
        this.toolBarDownload.add(this.btnDatabase);
        this.btnDatabase.setEnabled(false);
        this.btnDatabase.setVisible(false);
        this.btnDownloadOsm = new JButton("");
        this.btnDownloadOsm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.downloadOsm();
            }
        });
        this.btnDownloadOsm.setToolTipText("<html>Download Route from OSM<br>[CTRL+R]</html>");
        this.btnDownloadOsm.setFocusable(false);
        this.btnDownloadOsm.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/downloadbar/".concat("download-osm.png"))));
        this.btnDownloadOsm.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/downloadbar/".concat("download-osm-disabled.png"))));
        String string2 = "CTRL+R";
        this.mapPanel.getInputMap(2).put(KeyStroke.getKeyStroke(82, 128), string2);
        this.mapPanel.getActionMap().put(string2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.downloadOsm();
            }
        });
        this.toolBarDownload.add(this.btnDownloadOsm);
        this.btnDownloadOsm.setEnabled(true);
        this.btnDownloadGpsies = new JButton("");
        this.btnDownloadGpsies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.downloadGpsies();
            }
        });
        this.btnDownloadGpsies.setToolTipText("Download Tracks from www.gpsies.com");
        this.btnDownloadGpsies.setFocusable(false);
        this.btnDownloadGpsies.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/downloadbar/".concat("gpsies-down.png"))));
        this.btnDownloadGpsies.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/downloadbar/".concat("gpsies-down-disabled.png"))));
        this.toolBarDownload.add(this.btnDownloadGpsies);
        this.btnDownloadGpsies.setEnabled(true);
        this.btnUploadGpsies = new JButton("");
        this.btnUploadGpsies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.uploadGpsies();
            }
        });
        this.btnUploadGpsies.setToolTipText("Upload Track to www.gpsies.com");
        this.btnUploadGpsies.setFocusable(false);
        this.btnUploadGpsies.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/downloadbar/".concat("gpsies-up.png"))));
        this.btnUploadGpsies.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/downloadbar/".concat("gpsies-up-disabled.png"))));
        this.toolBarDownload.add(this.btnUploadGpsies);
        this.btnUploadGpsies.setEnabled(false);
        this.btndownloadWiki = new JButton("");
        this.btndownloadWiki.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.downloadWiki();
            }
        });
        this.btndownloadWiki.setToolTipText("<html>Get nearby articles from Wikipedia<br>[CTRL+W]</html>");
        this.btndownloadWiki.setFocusable(false);
        this.btndownloadWiki.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/downloadbar/".concat("wiki-down.png"))));
        this.btndownloadWiki.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/downloadbar/".concat("wiki-down-disabled.png"))));
        String string3 = "CTRL+W";
        this.mapPanel.getInputMap(2).put(KeyStroke.getKeyStroke(87, 128), string3);
        this.mapPanel.getActionMap().put(string2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.downloadWiki();
            }
        });
        this.toolBarDownload.add(this.btndownloadWiki);
        this.btndownloadWiki.setEnabled(true);
        this.setToolbarColor(this.toolBarDownload, this.MENU_BACKGROUND);
        this.menuBarsPanel.add((Component)this.toolBarDownload, "South");
    }

    private void setupCombo() {
    }

    private void setupMenuBar() {
        Object object;
        this.toolBarMain = new JToolBar();
        this.toolBarMain.setLayout(new BoxLayout(this.toolBarMain, 0));
        this.toolBarMain.setFloatable(false);
        this.toolBarMain.setBorder(new EtchedBorder(1, null, null));
        this.btnFileNew = new JButton("");
        this.btnFileNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.fileNew();
            }
        });
        this.btnFileNew.setToolTipText("<html>Create new GPX file<br>[CTRL+N]</html>");
        this.btnFileNew.setFocusable(false);
        this.btnFileNew.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("file-new.png"))));
        this.btnFileNew.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("file-new-disabled.png"))));
        String string = "CTRL+N";
        this.mapPanel.getInputMap(2).put(KeyStroke.getKeyStroke(78, 128), string);
        this.mapPanel.getActionMap().put(string, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.fileNew();
            }
        });
        this.toolBarMain.add(this.btnFileNew);
        this.btnFileOpen = new JButton("");
        this.btnFileOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.fileLoad();
            }
        });
        this.btnFileOpen.setToolTipText("<html>Open GPX file<br>[CTRL+O]</html>");
        this.btnFileOpen.setFocusable(false);
        this.btnFileOpen.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("file-open.png"))));
        this.btnFileOpen.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("file-open-disabled.png"))));
        String string2 = "CTRL+O";
        this.mapPanel.getInputMap(2).put(KeyStroke.getKeyStroke(79, 128), string2);
        this.mapPanel.getActionMap().put(string2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.fileLoad();
            }
        });
        this.btnFileOpen.setBackground(Color.WHITE);
        this.toolBarMain.add(this.btnFileOpen);
        this.tglDownload = new JToggleButton("");
        this.tglDownload.setToolTipText("More Transfer Options");
        this.tglDownload.setFocusable(false);
        this.tglDownload.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("file-open-more.png"))));
        this.tglDownload.setEnabled(true);
        this.toolBarMain.add(this.tglDownload);
        this.tglDownload.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    GpsMaster.this.toolBarDownload.setVisible(true);
                    GpsMaster.this.tglDownload.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("file-open-less.png"))));
                } else {
                    GpsMaster.this.toolBarDownload.setVisible(false);
                    GpsMaster.this.tglDownload.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("file-open-more.png"))));
                }
            }
        });
        this.btnFileSave = new JButton("");
        this.chooserFileSave = new JFileChooser(){

            @Override
            protected JDialog createDialog(Component component) throws HeadlessException {
                JDialog jDialog = super.createDialog(component);
                jDialog.setIconImage(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("file-save.png"))).getImage());
                return jDialog;
            }
        };
        int n = this.frame.getWidth() * 8 / 10;
        int n2 = this.frame.getHeight() * 8 / 10;
        n = Math.min(864, n);
        n2 = Math.min(539, n2);
        this.chooserFileSave.setPreferredSize(new Dimension(n, n2));
        this.btnFileSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.fileSave();
            }
        });
        this.btnFileSave.setToolTipText("<html>Save selected GPX file<br>[CTRL+S]</html>");
        this.btnFileSave.setFocusable(false);
        this.btnFileSave.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("file-save.png"))));
        this.btnFileSave.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("file-save-disabled.png"))));
        String string3 = "CTRL+S";
        this.mapPanel.getInputMap(2).put(KeyStroke.getKeyStroke(83, 128), string3);
        this.mapPanel.getActionMap().put(string3, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.fileSave();
            }
        });
        this.toolBarMain.add(this.btnFileSave);
        this.btnFileSave.setEnabled(false);
        this.btnPrint = new JButton("");
        this.btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.printVisibleMap();
            }
        });
        this.btnPrint.setToolTipText("<html>Print current map view[CTRL+P]</html>");
        this.btnPrint.setFocusable(false);
        this.btnPrint.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("print.png"))));
        this.btnPrint.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("print-disabled.png"))));
        String string4 = "CTRL+P";
        this.mapPanel.getInputMap(2).put(KeyStroke.getKeyStroke(80, 128), string4);
        this.mapPanel.getActionMap().put(string4, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.printVisibleMap();
            }
        });
        this.toolBarMain.add(this.btnPrint);
        this.btnPrint.setEnabled(false);
        this.btnPrint.setVisible(true);
        this.btnUndo = new JButton();
        this.btnUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.undo();
            }
        });
        this.btnUndo.setToolTipText("<html>Undo last operation<br>[CTRL+Z]</html>");
        this.btnUndo.setFocusable(false);
        this.btnUndo.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("undo.png"))));
        this.btnUndo.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("undo-disabled.png"))));
        String string5 = "CTRL+Z";
        this.splitPaneMain.getInputMap(2).put(KeyStroke.getKeyStroke(90, 128), string5);
        this.splitPaneMain.getActionMap().put(string5, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.undo();
            }
        });
        this.btnUndo.setEnabled(false);
        this.btnUndo.setVisible(true);
        this.toolBarMain.add(this.btnUndo);
        this.btnObjectDelete = new JButton("");
        this.btnObjectDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.deleteActiveGPXObject();
            }
        });
        this.btnObjectDelete.setToolTipText("<html>Delete selected object<br>[CTRL+D]</html>");
        this.btnObjectDelete.setFocusable(false);
        this.btnObjectDelete.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("object-delete.png"))));
        this.btnObjectDelete.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("object-delete-disabled.png"))));
        String string6 = "CTRL+D";
        this.mapPanel.getInputMap(2).put(KeyStroke.getKeyStroke(68, 128), string6);
        this.mapPanel.getActionMap().put(string6, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.deleteActiveGPXObject();
            }
        });
        this.toolBarMain.add(this.btnObjectDelete);
        this.toolBarMain.addSeparator();
        this.btnObjectDelete.setEnabled(false);
        this.btnEditProperties = new JButton("");
        this.btnEditProperties.setToolTipText("Edit properties");
        this.btnEditProperties.setFocusable(false);
        this.btnEditProperties.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("edit-properties.png"))));
        this.btnEditProperties.setEnabled(false);
        this.btnEditProperties.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("edit-properties-disabled.png"))));
        this.btnEditProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.editProperties();
            }
        });
        this.toolBarMain.add(this.btnEditProperties);
        this.tglPathFinder = new JToggleButton("");
        this.tglPathFinder.setToolTipText("Find path");
        this.tglPathFinder.setFocusable(false);
        this.tglPathFinder.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("path-find.png"))));
        this.tglPathFinder.setEnabled(false);
        this.tglPathFinder.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("path-find-disabled.png"))));
        this.mapPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (GpsMaster.this.pathFinder != null && active.getGpxObject() != null && !GpsMaster.this.mouseOverLink) {
                    GpsMaster.this.findPath(mouseEvent);
                }
            }
        });
        this.tglPathFinder.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    GpsMaster.this.deselectAllToggles(GpsMaster.this.tglPathFinder);
                    GpsMaster.this.pathFinderOn();
                } else {
                    GpsMaster.this.pathFinderOff();
                }
                GpsMaster.this.frame.revalidate();
                GpsMaster.this.frame.repaint();
            }
        });
        this.toolBarMain.add(this.tglPathFinder);
        this.toggles.add(this.tglPathFinder);
        this.tglAddRoutepoint = new JToggleButton("");
        this.tglAddRoutepoint.setToolTipText("Add Route Points");
        this.tglAddRoutepoint.setFocusable(false);
        this.tglAddRoutepoint.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("add-points.png"))));
        this.tglAddRoutepoint.setEnabled(false);
        this.tglAddRoutepoint.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("add-points-disabled.png"))));
        this.toolBarMain.add(this.tglAddRoutepoint);
        this.toggles.add(this.tglAddRoutepoint);
        this.mapPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Waypoint waypoint = null;
                GPXObject gPXObject = active.getGpxObject();
                if (active.getGpxObject() != null && !GpsMaster.this.mouseOverLink) {
                    WaypointGroup waypointGroup;
                    int n = GpsMaster.this.mapPanel.getZoom();
                    int n2 = mouseEvent.getX();
                    int n3 = mouseEvent.getY();
                    Point point = GpsMaster.this.mapPanel.getCenter();
                    int n4 = point.x - GpsMaster.this.mapPanel.getWidth() / 2;
                    int n5 = point.y - GpsMaster.this.mapPanel.getHeight() / 2;
                    double d = OsmMercator.MERCATOR_256.yToLat(n5 + n3, n);
                    double d2 = OsmMercator.MERCATOR_256.xToLon(n4 + n2, n);
                    GPXFile gPXFile = active.getGpxFile();
                    if (GpsMaster.this.tglAddRoutepoint.isSelected()) {
                        waypoint = new Waypoint(d, d2);
                        waypointGroup = null;
                        if (gPXObject.isGPXFileWithOneRoute()) {
                            waypointGroup = ((GPXFile)gPXObject).getRoutes().get(0).getPath();
                        } else if (gPXObject.isRoute()) {
                            waypointGroup = ((Route)gPXObject).getPath();
                        } else if (gPXObject.isWaypointGroup() && ((WaypointGroup)gPXObject).getWptGrpType() == WaypointGroup.WptGrpType.WAYPOINTS) {
                            waypointGroup = (WaypointGroup)gPXObject;
                        }
                        waypointGroup.addWaypoint(waypoint);
                        active.addUndoOperation(new UndoAddWaypoint(waypoint, waypointGroup));
                    }
                    if (GpsMaster.this.tglAddWaypoint.isSelected()) {
                        waypoint = new WaypointMarker(d, d2);
                        waypointGroup = gPXFile.getWaypointGroup();
                        waypointGroup.addWaypoint(waypoint);
                        active.addUndoOperation(new UndoAddWaypoint(waypoint, waypointGroup));
                        active.refreshTree();
                    }
                    if (waypoint != null) {
                        gPXFile.updateAllProperties();
                        active.repaintMap();
                        active.refresh();
                    }
                }
            }
        });
        this.tglAddRoutepoint.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    GpsMaster.this.deselectAllToggles(GpsMaster.this.tglAddRoutepoint);
                    GpsMaster.this.mapCursor = GpsMaster.this.CROSSHAIR_CURSOR;
                    GPXObject gPXObject = active.getGpxObject();
                    if (gPXObject.isGPXFileWithNoRoutes()) {
                        Route route = ((GPXFile)gPXObject).addRoute();
                        active.refreshTree();
                        GpsMaster.this.updateButtonVisibility();
                    }
                } else {
                    GpsMaster.this.mapCursor = GpsMaster.this.DEFAULT_CURSOR;
                }
            }
        });
        this.tglDelPoints = new JToggleButton("");
        this.tglDelPoints.setToolTipText("Delete points");
        this.tglDelPoints.setFocusable(false);
        this.tglDelPoints.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("delete-points.png"))));
        this.tglDelPoints.setEnabled(false);
        this.tglDelPoints.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("delete-points-disabled.png"))));
        this.toolBarMain.add(this.tglDelPoints);
        this.toggles.add(this.tglDelPoints);
        this.tglDelPoints.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    GpsMaster.this.deselectAllToggles(GpsMaster.this.tglDelPoints);
                    GpsMaster.this.mapCursor = GpsMaster.this.CROSSHAIR_CURSOR;
                } else {
                    GpsMaster.this.mapCursor = GpsMaster.this.DEFAULT_CURSOR;
                }
            }
        });
        this.tglChart = new JToggleButton("");
        this.tglChart.setToolTipText("Show Chart");
        this.tglChart.setFocusable(false);
        this.tglChart.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("chart.png"))));
        this.tglChart.setEnabled(false);
        this.tglChart.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("chart-disabled.png"))));
        this.toolBarMain.add(this.tglChart);
        this.tglChart.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    GpsMaster.this.enableChart();
                } else {
                    GpsMaster.this.disableChart();
                }
            }
        });
        final DirectDistancePainter directDistancePainter = new DirectDistancePainter();
        this.tglMeasure = new JToggleButton("");
        this.tglMeasure.setToolTipText("Measure distance between two waypoints");
        this.tglMeasure.setFocusable(false);
        this.tglMeasure.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("measure.png"))));
        this.tglMeasure.setEnabled(false);
        this.tglMeasure.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("measure-disabled.png"))));
        this.tglMeasure.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    GpsMaster.this.mapCursor = GpsMaster.this.CROSSHAIR_CURSOR;
                    GpsMaster.this.distanceWidget = new DistanceWidget();
                    GpsMaster.this.mapPanel.add(GpsMaster.this.distanceWidget);
                    GpsMaster.this.measure = new MeasureThings(GpsMaster.this.distanceWidget, GpsMaster.this.uc, GpsMaster.this.mapPanel.getMarkerList());
                    GpsMaster.this.measure.setMessageCenter(GpsMaster.this.msg);
                    GpsMaster.this.mapPanel.addPropertyChangeListener(GpsMaster.this.measure.getPropertyChangeListener());
                    GpsMaster.this.addPropertyChangeListener(GpsMaster.this.measure.getPropertyChangeListener());
                    GpsMaster.this.mapPanel.addPainter(directDistancePainter);
                } else {
                    GpsMaster.this.mapPanel.removePropertyChangeListener(GpsMaster.this.measure.getPropertyChangeListener());
                    GpsMaster.this.mapPanel.remove(GpsMaster.this.distanceWidget);
                    GpsMaster.this.removePropertyChangeListener(GpsMaster.this.measure.getPropertyChangeListener());
                    GpsMaster.this.mapCursor = GpsMaster.this.DEFAULT_CURSOR;
                    GpsMaster.this.measure.dispose();
                    GpsMaster.this.measure = null;
                    GpsMaster.this.distanceWidget = null;
                    GpsMaster.this.mapPanel.removePainter(directDistancePainter);
                }
            }
        });
        this.toolBarMain.add(this.tglMeasure);
        this.tglProgress = new JToggleButton("");
        this.tglProgress.setToolTipText("Show progress labels");
        this.tglProgress.setFocusable(false);
        this.tglProgress.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("progress-none.png"))));
        this.tglProgress.setEnabled(false);
        this.tglProgress.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("progress-disabled.png"))));
        this.tglProgress.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) {
                    switch (GpsMaster.this.progressPainter.getProgressType()) {
                        case NONE: {
                            GpsMaster.this.progressPainter.setProgressType(ProgressType.RELATIVE);
                            GpsMaster.this.tglProgress.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("progress-rel.png"))));
                            GpsMaster.this.tglProgress.setSelected(true);
                            break;
                        }
                        case RELATIVE: {
                            GpsMaster.this.progressPainter.setProgressType(ProgressType.ABSOLUTE);
                            GpsMaster.this.tglProgress.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("progress-abs.png"))));
                            GpsMaster.this.tglProgress.setSelected(true);
                            break;
                        }
                        case ABSOLUTE: {
                            GpsMaster.this.progressPainter.setProgressType(ProgressType.NONE);
                            GpsMaster.this.tglProgress.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("progress-none.png"))));
                            GpsMaster.this.tglProgress.setSelected(false);
                        }
                    }
                }
                GpsMaster.this.mapPanel.repaint();
            }
        });
        this.toolBarMain.add(this.tglProgress);
        this.tglArrows = new JToggleButton("");
        this.tglArrows.setToolTipText("Show directional arrows [CTRL-A]");
        this.tglArrows.setFocusable(false);
        this.tglArrows.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("arrows-enabled.png"))));
        this.tglArrows.setEnabled(false);
        this.tglArrows.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("arrows-disabled.png"))));
        this.toolBarMain.add(this.tglArrows);
        this.tglArrows.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 || itemEvent.getStateChange() == 2) {
                    switch (GpsMaster.this.arrowPainter.getArrowType()) {
                        case NONE: {
                            GpsMaster.this.arrowPainter.setArrowType(ArrowType.ONTRACK);
                            GpsMaster.this.tglArrows.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("arrow-ontrack.png"))));
                            GpsMaster.this.tglArrows.setSelected(true);
                            break;
                        }
                        case ONTRACK: {
                            GpsMaster.this.arrowPainter.setArrowType(ArrowType.PARALLEL);
                            GpsMaster.this.tglArrows.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("arrow-parallel.png"))));
                            GpsMaster.this.tglArrows.setSelected(true);
                            break;
                        }
                        case PARALLEL: {
                            GpsMaster.this.arrowPainter.setArrowType(ArrowType.NONE);
                            GpsMaster.this.tglArrows.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("arrows-enabled.png"))));
                            GpsMaster.this.tglArrows.setSelected(false);
                        }
                    }
                }
                GpsMaster.this.mapPanel.repaint();
            }
        });
        this.toolBarMain.add(Box.createHorizontalGlue());
        this.mapPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                GpsMaster.this.updateActiveWpt(mouseEvent);
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                GpsMaster.this.mapPanel.setShownPoint(null);
                GpsMaster.this.mapPanel.repaint();
            }
        });
        this.mapPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                GpsMaster.this.updateActiveWpt(mouseWheelEvent);
            }
        });
        this.mapPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                active.setTrackpoint(null);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Waypoint waypoint = active.getTrackpoint();
                if (waypoint != null && !GpsMaster.this.mouseOverLink) {
                    GPXFile gPXFile = active.getGpxFile();
                    GpsMaster.this.firePropertyChange("1click", null, waypoint);
                    if (GpsMaster.this.tglDelPoints.isSelected()) {
                        WaypointGroup waypointGroup = active.getGroup();
                        if (waypointGroup != null) {
                            active.addUndoOperation(new UndoRemoveWaypoint(waypoint, waypointGroup));
                            waypointGroup.removeWaypoint(waypoint);
                            gPXFile.updateAllProperties();
                        }
                    } else if (GpsMaster.this.tglSplitTrackseg.isSelected()) {
                        GpsMaster.this.splitTrackSeg(gPXFile);
                    }
                    GpsMaster.this.mapPanel.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                GpsMaster.this.updateActiveWpt(mouseEvent);
            }
        });
        this.btnLogWindow = new JButton("");
        this.btnLogWindow.setToolTipText("Display Log");
        this.btnLogWindow.setFocusable(false);
        this.btnLogWindow.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("ok.png"))));
        this.btnLogWindow.setEnabled(true);
        this.btnLogWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.transferStatusDialog.setVisible(!GpsMaster.this.transferStatusDialog.isVisible());
            }
        });
        this.toolBarMain.add(this.btnLogWindow);
        this.tglToolbar = new JToggleButton("");
        this.tglToolbar.setToolTipText("Display Toolbar");
        this.tglToolbar.setFocusable(false);
        this.tglToolbar.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("toolbar-enabled.png"))));
        this.tglToolbar.setEnabled(true);
        this.toolBarMain.add(this.tglToolbar);
        this.tglToolbar.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        GpsMaster.this.contentPane.add((Component)GpsMaster.this.toolBarSide, "West");
                        break;
                    }
                    case 2: {
                        GpsMaster.this.contentPane.remove(GpsMaster.this.toolBarSide);
                    }
                }
                GpsMaster.this.frame.validate();
            }
        });
        this.comboBoxTileSource = new JComboBox();
        this.comboBoxTileSource.setMaximumRowCount(18);
        this.comboBoxTileSource.addItem(new OsmTileSource.Mapnik());
        TileSourceInfo tileSourceInfo = new TileSourceInfo("HikeBikeMap", "http://{switch:a,b,c}.tiles.wmflabs.org/hikebike/{zoom}/{x}/{y}.png", "tmts");
        this.comboBoxTileSource.addItem(new TemplatedTMSTileSource(tileSourceInfo));
        this.comboBoxTileSource.addItem(new BingAerialTileSource());
        for (OnlineTileSource onlineTileSource : this.conf.getOnlineTileSources()) {
            object = new TileSourceInfo(onlineTileSource.getName(), onlineTileSource.getUrl(), Integer.toHexString(onlineTileSource.hashCode()));
            this.comboBoxTileSource.addItem(new TemplatedTMSTileSource((TileSourceInfo)object));
        }
        this.comboBoxTileSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.mapPanel.setTileSource((TileSource)GpsMaster.this.comboBoxTileSource.getSelectedItem());
            }
        });
        this.comboBoxTileSource.setFocusable(false);
        this.toolBarMain.add(this.comboBoxTileSource);
        this.comboBoxTileSource.setMaximumSize(this.comboBoxTileSource.getPreferredSize());
        this.toolBarMain.addSeparator();
        this.lblLat = new JLabel(" Lat ");
        this.lblLat.setFont(new Font("Tahoma", 0, 11));
        this.toolBarMain.add(this.lblLat);
        this.textFieldLat = new JTextField();
        this.textFieldLat.setPreferredSize(new Dimension(80, 24));
        this.textFieldLat.setMinimumSize(new Dimension(25, 24));
        this.textFieldLat.setMaximumSize(new Dimension(80, 24));
        this.textFieldLat.setColumns(9);
        this.textFieldLat.setFocusable(false);
        this.textFieldLat.setFocusTraversalKeysEnabled(false);
        this.textFieldLat.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    GpsMaster.this.textFieldLat.setFocusable(false);
                    GpsMaster.this.textFieldLon.setFocusable(true);
                    GpsMaster.this.textFieldLon.requestFocusInWindow();
                } else if (keyEvent.getKeyCode() == 10) {
                    GpsMaster.this.tglLatLonFocus.setSelected(false);
                    GpsMaster.this.tglLatLonFocus.setSelected(true);
                } else if (keyEvent.getKeyCode() == 27) {
                    GpsMaster.this.tglLatLonFocus.setSelected(false);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (GpsMaster.this.tglLatLonFocus.isSelected()) {
                    GpsMaster.this.tglLatLonFocus.setSelected(false);
                    GpsMaster.this.tglLatLonFocus.setSelected(true);
                }
            }
        });
        this.toolBarMain.add(this.textFieldLat);
        this.lblLon = new JLabel(" Lon ");
        this.lblLon.setFont(new Font("Tahoma", 0, 11));
        this.toolBarMain.add(this.lblLon);
        this.textFieldLon = new JTextField();
        this.textFieldLon.setPreferredSize(new Dimension(80, 24));
        this.textFieldLon.setMinimumSize(new Dimension(25, 24));
        this.textFieldLon.setMaximumSize(new Dimension(80, 24));
        this.textFieldLon.setColumns(9);
        this.textFieldLon.setFocusable(false);
        this.textFieldLon.setFocusTraversalKeysEnabled(false);
        this.textFieldLon.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    GpsMaster.this.textFieldLat.setFocusable(true);
                    GpsMaster.this.textFieldLon.setFocusable(false);
                    GpsMaster.this.textFieldLat.requestFocusInWindow();
                } else if (keyEvent.getKeyCode() == 10) {
                    GpsMaster.this.tglLatLonFocus.setSelected(false);
                    GpsMaster.this.tglLatLonFocus.setSelected(true);
                } else if (keyEvent.getKeyCode() == 27) {
                    GpsMaster.this.tglLatLonFocus.setSelected(false);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (GpsMaster.this.tglLatLonFocus.isSelected()) {
                    GpsMaster.this.tglLatLonFocus.setSelected(false);
                    GpsMaster.this.tglLatLonFocus.setSelected(true);
                }
            }
        });
        this.toolBarMain.add(this.textFieldLon);
        long l = 16L;
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent.getID() == 501) {
                    if (aWTEvent.getSource() == GpsMaster.this.textFieldLat) {
                        GpsMaster.this.textFieldLat.setFocusable(true);
                    } else {
                        GpsMaster.this.textFieldLat.setFocusable(false);
                    }
                    if (aWTEvent.getSource() == GpsMaster.this.textFieldLon) {
                        GpsMaster.this.textFieldLon.setFocusable(true);
                    } else {
                        GpsMaster.this.textFieldLon.setFocusable(false);
                    }
                }
            }
        }, l);
        this.tglLatLonFocus = new JToggleButton("");
        this.tglLatLonFocus.setToolTipText("Focus on latitude/longitude");
        this.tglLatLonFocus.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("crosshair.png"))));
        this.tglLatLonFocus.setFocusable(false);
        this.tglLatLonFocus.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    GpsMaster.this.deselectAllToggles(GpsMaster.this.tglLatLonFocus);
                    GpsMaster.this.mapCursor = GpsMaster.this.CROSSHAIR_CURSOR;
                    String string = GpsMaster.this.textFieldLat.getText();
                    String string2 = GpsMaster.this.textFieldLon.getText();
                    try {
                        double d = Double.parseDouble(string);
                        double d2 = Double.parseDouble(string2);
                        GpsMaster.this.mapPanel.setShowCrosshair(true);
                        GpsMaster.this.mapPanel.setCrosshairLat(d);
                        GpsMaster.this.mapPanel.setCrosshairLon(d2);
                        Point point = new Point(GpsMaster.this.mapPanel.getWidth() / 2, GpsMaster.this.mapPanel.getHeight() / 2);
                        GpsMaster.this.mapPanel.setDisplayPosition(point, new Coordinate(d, d2), GpsMaster.this.mapPanel.getZoom());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GpsMaster.this.mapPanel.repaint();
                } else if (itemEvent.getStateChange() == 2) {
                    GpsMaster.this.mapCursor = GpsMaster.this.DEFAULT_CURSOR;
                    GpsMaster.this.mapPanel.setShowCrosshair(false);
                    GpsMaster.this.mapPanel.repaint();
                }
            }
        });
        object = Box.createHorizontalGlue();
        ((Component)object).setMaximumSize(new Dimension(2, 0));
        ((Component)object).setMinimumSize(new Dimension(2, 0));
        ((Component)object).setPreferredSize(new Dimension(2, 0));
        this.toolBarMain.add((Component)object);
        this.toolBarMain.add(this.tglLatLonFocus);
        this.toggles.add(this.tglLatLonFocus);
        this.tglAutoFit = new JToggleButton();
        this.tglAutoFit.setToolTipText("Resize map msgPanel to fit selected track or segment");
        this.tglAutoFit.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("autofit.png"))));
        this.tglAutoFit.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("autofit-disabled.png"))));
        this.tglAutoFit.setEnabled(this.autoFitToPanel);
        this.tglAutoFit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GpsMaster.this.autoFitToPanel = itemEvent.getStateChange() == 1;
            }
        });
        this.tglAutoFit.setSelected(this.autoFitToPanel);
        this.tglAutoFit.setEnabled(true);
        this.toolBarMain.add(this.tglAutoFit);
        this.btnInfo = new JButton("");
        this.btnInfo.setToolTipText("Show Info");
        this.btnInfo.setFocusable(false);
        this.btnInfo.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("about.png"))));
        this.btnInfo.setEnabled(true);
        this.btnInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.showInfo();
            }
        });
        this.toolBarMain.add(this.btnInfo);
        this.mapPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (GpsMaster.this.tglLatLonFocus.isSelected() && !GpsMaster.this.mouseOverLink) {
                    int n = GpsMaster.this.mapPanel.getZoom();
                    int n2 = mouseEvent.getX();
                    int n3 = mouseEvent.getY();
                    Point point = GpsMaster.this.mapPanel.getCenter();
                    int n4 = point.x - GpsMaster.this.mapPanel.getWidth() / 2;
                    int n5 = point.y - GpsMaster.this.mapPanel.getHeight() / 2;
                    double d = OsmMercator.MERCATOR_256.yToLat(n5 + n3, n);
                    double d2 = OsmMercator.MERCATOR_256.xToLon(n4 + n2, n);
                    GpsMaster.this.textFieldLat.setText(String.format("%.6f", d));
                    GpsMaster.this.textFieldLon.setText(String.format("%.6f", d2));
                    GpsMaster.this.mapPanel.setShowCrosshair(true);
                    GpsMaster.this.mapPanel.setCrosshairLat(d);
                    GpsMaster.this.mapPanel.setCrosshairLon(d2);
                    GpsMaster.this.mapPanel.repaint();
                }
            }
        });
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GpsMaster.this.saveConfig();
                if (GpsMaster.this.db != null) {
                    try {
                        GpsMaster.this.db.disconnect();
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
                System.exit(0);
            }
        });
        JButton jButton = new JButton("debug");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.doDebug();
            }
        });
        jButton.setFocusable(false);
        this.setToolbarColor(this.toolBarMain, this.MENU_BACKGROUND);
        this.menuBarsPanel.add((Component)this.toolBarMain, "North");
    }

    private void setupToolbar() {
        this.toolBarSide = new JToolBar(1);
        this.toolBarSide.setFloatable(true);
        this.toolBarSide.setName("Toolbar");
        this.tglSplitTrackseg = new JToggleButton("");
        this.tglSplitTrackseg.setToolTipText("Split track segment");
        this.tglSplitTrackseg.setFocusable(false);
        this.tglSplitTrackseg.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("trackseg-split.png"))));
        this.tglSplitTrackseg.setEnabled(false);
        this.tglSplitTrackseg.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("trackseg-split-disabled.png"))));
        this.toolBarSide.add(this.tglSplitTrackseg);
        this.toggles.add(this.tglSplitTrackseg);
        this.tglSplitTrackseg.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    GpsMaster.this.deselectAllToggles(GpsMaster.this.tglSplitTrackseg);
                    GpsMaster.this.mapCursor = GpsMaster.this.CROSSHAIR_CURSOR;
                } else {
                    GpsMaster.this.mapCursor = GpsMaster.this.DEFAULT_CURSOR;
                }
            }
        });
        this.tglAddWaypoint = new JToggleButton("");
        this.tglAddWaypoint.setToolTipText("Add new Waypoint");
        this.tglAddWaypoint.setFocusable(false);
        this.tglAddWaypoint.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("add-waypoint.png"))));
        this.tglAddWaypoint.setEnabled(false);
        this.tglAddWaypoint.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("add-waypoint-disabled.png"))));
        this.toolBarSide.add(this.tglAddWaypoint);
        this.toggles.add(this.tglAddWaypoint);
        this.tglAddWaypoint.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    GpsMaster.this.deselectAllToggles(GpsMaster.this.tglAddWaypoint);
                    GpsMaster.this.mapCursor = GpsMaster.this.CROSSHAIR_CURSOR;
                } else {
                    GpsMaster.this.mapCursor = GpsMaster.this.DEFAULT_CURSOR;
                }
            }
        });
        this.toolBarSide.addSeparator();
        this.btnCorrectEle = new JButton("");
        this.btnCorrectEle.setToolTipText("Correct elevation");
        this.btnCorrectEle.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("correct-elevation.png"))));
        this.btnCorrectEle.setEnabled(false);
        this.btnCorrectEle.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("correct-elevation-disabled.png"))));
        this.btnCorrectEle.setFocusable(false);
        this.btnCorrectEle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.correctElevation();
            }
        });
        this.toolBarSide.add(this.btnCorrectEle);
        this.btnCleaning = new JButton("");
        this.btnCleaning.setToolTipText(String.format("Remove waypoints", new Object[0]));
        this.btnCleaning.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("clean-distance.png"))));
        this.btnCleaning.setEnabled(false);
        this.btnCleaning.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("clean-distance-disabled.png"))));
        this.btnCleaning.setFocusable(false);
        this.btnCleaning.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.doCleaning();
            }
        });
        this.toolBarSide.add(this.btnCleaning);
        this.btnTimeShift = new JButton("");
        this.btnTimeShift.setToolTipText("modify GPX timestamps [CTRL-T]");
        this.btnTimeShift.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("timeshift.png"))));
        this.btnTimeShift.setEnabled(false);
        this.btnTimeShift.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("timeshift-disabled.png"))));
        this.btnTimeShift.setFocusable(false);
        this.btnTimeShift.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.doTimeShift();
            }
        });
        String string = "CTRL+T";
        this.mapPanel.getInputMap(2).put(KeyStroke.getKeyStroke(84, 128), string);
        this.mapPanel.getActionMap().put(string, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.doTimeShift();
            }
        });
        this.toolBarSide.add(this.btnTimeShift);
        this.toolBarSide.addSeparator();
        this.btnMergeOneToOne = new JButton("");
        this.btnMergeOneToOne.setToolTipText("Merge visible tracks and segments 1:1 into a new GPX file.");
        this.btnMergeOneToOne.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("merge-tracks.png"))));
        this.btnMergeOneToOne.setEnabled(false);
        this.btnMergeOneToOne.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("merge-tracks-disabled.png"))));
        this.btnMergeOneToOne.setFocusable(false);
        this.btnMergeOneToOne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GPXFile gPXFile = GpsMaster.this.core.mergeIntoMulti(active.getGpxFiles());
                if (gPXFile != null) {
                    active.addGpxFile(gPXFile);
                }
                GpsMaster.this.msg.volatileInfo("Merging completed.");
            }
        });
        this.toolBarSide.add(this.btnMergeOneToOne);
        this.btnMergeToMulti = new JButton("");
        this.btnMergeToMulti.setToolTipText("Merge visible tracks and segments into a single track, keep segments separate.");
        this.btnMergeToMulti.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("merge-multi.png"))));
        this.btnMergeToMulti.setEnabled(false);
        this.btnMergeToMulti.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("merge-multi-disabled.png"))));
        this.btnMergeToMulti.setFocusable(false);
        this.btnMergeToMulti.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GPXFile gPXFile = GpsMaster.this.core.mergeIntoMulti(active.getGpxFiles());
                if (gPXFile != null) {
                    active.addGpxFile(gPXFile);
                }
                GpsMaster.this.msg.volatileInfo("Merging completed.");
            }
        });
        this.toolBarSide.add(this.btnMergeToMulti);
        this.btnMergeToSingle = new JButton("");
        this.btnMergeToSingle.setToolTipText("Merge visible track segments into a new track with a single segment and sort trackpoints by time.");
        this.btnMergeToSingle.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("merge-single.png"))));
        this.btnMergeToSingle.setEnabled(false);
        this.btnMergeToSingle.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("merge-single-disabled.png"))));
        this.btnMergeToSingle.setFocusable(false);
        this.btnMergeToSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GPXFile gPXFile = GpsMaster.this.core.mergeIntoMulti(active.getGpxFiles());
                if (gPXFile != null) {
                    active.addGpxFile(gPXFile);
                }
                GpsMaster.this.msg.volatileInfo("Merging completed.");
            }
        });
        this.toolBarSide.add(this.btnMergeToSingle);
        this.btnMergeParallel = new JButton("");
        this.btnMergeParallel.setToolTipText("Interpolate a new track between two track segments.");
        this.btnMergeParallel.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("merge-parallel.png"))));
        this.btnMergeParallel.setEnabled(false);
        this.btnMergeParallel.setDisabledIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/toolbar/".concat("merge-parallel-disabled.png"))));
        this.btnMergeParallel.setFocusable(false);
        this.btnMergeParallel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsMaster.this.msg.volatileInfo("Merging completed.");
            }
        });
        this.setToolbarColor(this.toolBarSide, this.MENU_BACKGROUND);
    }

    private void setupDatabase() {
        if (!this.conf.getDbConfig().getDSN().isEmpty()) {
            this.db = new DbLayer(this.conf.getDbConfig());
            try {
                this.db.connect();
                this.btnDatabase.setVisible(true);
            }
            catch (SQLException sQLException) {
                this.msg.error("Connection to database failed, check configuration", sQLException);
                this.db = null;
            }
        }
        this.btnDatabase.setEnabled(this.db != null);
    }

    private void setToolbarColor(JToolBar jToolBar, Color color) {
        jToolBar.setBackground(color);
        for (Component component : jToolBar.getComponents()) {
            component.setBackground(color);
        }
    }

    private void updateButtonVisibility() {
        this.btnFileSave.setEnabled(false);
        this.btnObjectDelete.setEnabled(false);
        this.tglAddRoutepoint.setEnabled(false);
        this.tglDelPoints.setEnabled(false);
        this.tglSplitTrackseg.setEnabled(false);
        this.btnEditProperties.setEnabled(false);
        this.tglPathFinder.setEnabled(false);
        this.tglMeasure.setEnabled(false);
        this.tglProgress.setEnabled(false);
        this.tglArrows.setEnabled(false);
        this.btnTimeShift.setEnabled(false);
        this.btnPrint.setEnabled(false);
        this.tglToolbar.setEnabled(true);
        this.tglDownload.setEnabled(true);
        this.btnFileNew.setEnabled(true);
        this.btnFileOpen.setEnabled(true);
        this.tglChart.setEnabled(false);
        this.btndownloadWiki.setEnabled(true);
        this.btnMergeOneToOne.setEnabled(false);
        this.btnMergeToSingle.setEnabled(false);
        this.btnMergeToMulti.setEnabled(false);
        this.btnMergeParallel.setEnabled(false);
        this.btnCleaning.setEnabled(false);
        this.btnCorrectEle.setEnabled(false);
        this.btnTimeShift.setEnabled(true);
        GPXObject gPXObject = active.getGpxObject();
        if (gPXObject != null) {
            this.btnFileSave.setEnabled(true);
            this.btnObjectDelete.setEnabled(true);
            this.btnPrint.setEnabled(true);
            this.tglChart.setEnabled(true);
            this.tglMeasure.setEnabled(true);
            if (gPXObject.isRoute() || gPXObject.isWaypoints() || gPXObject.isGPXFileWithOneRoute() || gPXObject.isGPXFileWithNoRoutes()) {
                this.tglAddRoutepoint.setEnabled(true);
            }
            if (gPXObject.isTrackseg() || gPXObject.isTrackWithOneSeg() || gPXObject.isRoute() || gPXObject.isWaypoints() || gPXObject.isGPXFileWithOneTracksegOnly() || gPXObject.isGPXFileWithOneRouteOnly()) {
                this.tglDelPoints.setEnabled(true);
            }
            if (gPXObject.isTrackseg() || gPXObject.isTrackWithOneSeg() || gPXObject.isGPXFileWithOneTracksegOnly()) {
                this.tglSplitTrackseg.setEnabled(true);
            }
            if (gPXObject.isTrack() || gPXObject.isRoute() || gPXObject.isTrackseg()) {
                this.tglMeasure.setEnabled(true);
            }
            if (gPXObject.isGPXFile() || gPXObject.isRoute() || gPXObject.isTrack()) {
                this.btnEditProperties.setEnabled(true);
                this.btnCorrectEle.setEnabled(true);
                this.tglSplitTrackseg.setEnabled(true);
                this.btnCleaning.setEnabled(true);
            }
            if (gPXObject.isRoute() || gPXObject.isGPXFileWithOneRoute() || gPXObject.isGPXFileWithNoRoutes()) {
                this.tglPathFinder.setEnabled(true);
            }
            if (gPXObject.isTrackseg() || gPXObject.isTrack() || gPXObject.isGPXFile()) {
                this.tglProgress.setEnabled(true);
                this.tglArrows.setEnabled(true);
                this.btnCorrectEle.setEnabled(true);
                this.btnUploadGpsies.setEnabled(true);
            }
            if (gPXObject.isTrackseg()) {
                // empty if block
            }
            if (active.getGpxFiles().size() > 0) {
                this.btnMergeOneToOne.setEnabled(true);
                this.btnMergeToMulti.setEnabled(true);
                this.btnMergeToSingle.setEnabled(true);
                this.tglAddWaypoint.setEnabled(true);
            }
        }
        this.btnUndo.setEnabled(active.getUndoStack().size() > 0);
    }

    private void splitTrackSeg(GPXFile gPXFile) {
        WaypointGroup waypointGroup = active.getGroup();
        List<Waypoint> list = waypointGroup.getWaypoints();
        int n = list.indexOf(active.getTrackpoint());
        ArrayList<Waypoint> arrayList = new ArrayList<Waypoint>(list.subList(0, n + 1));
        ArrayList<Waypoint> arrayList2 = new ArrayList<Waypoint>(list.subList(n, list.size()));
        WaypointGroup waypointGroup2 = new WaypointGroup(waypointGroup.getColor(), WaypointGroup.WptGrpType.TRACKSEG);
        WaypointGroup waypointGroup3 = new WaypointGroup(waypointGroup.getColor(), WaypointGroup.WptGrpType.TRACKSEG);
        waypointGroup2.setWaypoints(arrayList);
        waypointGroup3.setWaypoints(arrayList2);
        Track track = active.getTrackForSegment(waypointGroup);
        track.getTracksegs().remove(waypointGroup);
        track.addTrackseg(waypointGroup3);
        track.addTrackseg(waypointGroup2);
        gPXFile.updateAllProperties();
        active.addUndoOperation(new UndoSplitTrackSeg(track, waypointGroup2, waypointGroup3));
        active.refreshTree(track);
        active.refresh();
        this.tglSplitTrackseg.setSelected(true);
        active.setTrackpoint(null);
    }

    private void fileNew() {
        String string = (String)JOptionPane.showInputDialog(this.frame, "Please type a name for the new route:", "New route", -1, null, null, null);
        if (string != null) {
            GPXFile gPXFile = new GPXFile(string);
            gPXFile.getMetadata().setTime(new Date());
            gPXFile.addRoute();
            gPXFile.updateAllProperties();
            active.addGpxFile(gPXFile);
            active.setGpxObject(gPXFile);
        }
    }

    private void fileSave() {
        GPXFile gPXFile = active.getGpxFile();
        if (gPXFile == null) {
            return;
        }
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            MessagePanel msgSave = null;

            @Override
            public Void doInBackground() {
                this.msgSave = GpsMaster.this.msg.infoOn("Saving file ...", GpsMaster.this.WAIT_CURSOR);
                try {
                    GpsMaster.this.fileSave = GpsMaster.this.chooserFileSave.getSelectedFile();
                    GpsLoader gpsLoader = GpsLoaderFactory.getLoaderByExtension(GpsMaster.this.getFilenameExt(GpsMaster.this.fileSave.getName()));
                    FileOutputStream fileOutputStream = new FileOutputStream(GpsMaster.this.fileSave);
                    gpsLoader.save(active.getGpxFile(), fileOutputStream);
                    fileOutputStream.close();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    GpsMaster.this.msg.error("No writer for this file format available.");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    GpsMaster.this.msg.error(fileNotFoundException);
                }
                catch (Exception exception) {
                    GpsMaster.this.msg.error("unexpected error", exception);
                }
                return null;
            }

            @Override
            protected void done() {
                GpsMaster.this.msg.infoOff(this.msgSave);
            }
        };
        this.chooserFileSave.setCurrentDirectory(new File(this.conf.getLastSaveDirectory()));
        boolean bl = false;
        String string = gPXFile.getMetadata().getName();
        for (String string2 : this.loaderFactory.getExtensions()) {
            if (!string.endsWith(string2)) continue;
            bl = true;
        }
        if (!bl) {
            string = string.concat(".gpx");
        }
        this.chooserFileSave.setSelectedFile(new File(string));
        boolean bl2 = false;
        while (!bl2) {
            int n;
            bl2 = true;
            int n2 = this.chooserFileSave.showSaveDialog(this.frame);
            if (n2 != 0) continue;
            this.fileSave = this.chooserFileSave.getSelectedFile();
            String string3 = this.getFilenameExt(this.fileSave.getName());
            if (bl2 && string3.isEmpty()) {
                JOptionPane.showConfirmDialog(this.frame, "please specify an sourceFmt.", "no sourceFmt", 0, 1);
                bl2 = false;
            }
            if (bl2 && !this.loaderFactory.getExtensions().contains(string3)) {
                JOptionPane.showConfirmDialog(this.frame, "unsupported file format.", "error", 0, 2);
                bl2 = false;
            }
            if (bl2 && this.fileSave.exists() && ((n = JOptionPane.showConfirmDialog(this.frame, "<html>" + this.fileSave.getName() + " already exists.<br>Do you want to replace it?</html>", "Confirm file overwrite", 2, 3)) == 2 || n == -1)) {
                return;
            }
            this.conf.setLastSaveDirectory(this.chooserFileSave.getCurrentDirectory().getPath());
            swingWorker.execute();
        }
    }

    private String getFilenameExt(String string) {
        int n;
        String string2 = "";
        int n2 = string.lastIndexOf(46);
        if (n2 > (n = Math.max(string.lastIndexOf(47), string.lastIndexOf(92)))) {
            string2 = string.substring(n2 + 1);
        }
        return string2;
    }

    private void deleteActiveGPXObject() {
        GPXObject gPXObject = active.getGpxObject();
        GPXFile gPXFile = active.getGpxFile();
        if (gPXObject != null) {
            if (gPXObject.isGPXFile()) {
                active.removeGpxFile(gPXFile);
            } else {
                if (gPXObject.isRoute()) {
                    gPXFile.getRoutes().remove((Route)gPXObject);
                } else if (gPXObject.isTrack()) {
                    gPXFile.getTracks().remove((Track)gPXObject);
                } else if (gPXObject.isWaypointGroup()) {
                    WaypointGroup waypointGroup = (WaypointGroup)gPXObject;
                    if (waypointGroup.getWptGrpType() == WaypointGroup.WptGrpType.TRACKSEG) {
                        for (Track track : gPXFile.getTracks()) {
                            if (!track.getTracksegs().contains(waypointGroup)) continue;
                            track.getTracksegs().remove(waypointGroup);
                            break;
                        }
                    } else {
                        gPXFile.getWaypointGroup().getWaypoints().clear();
                    }
                }
                gPXFile.updateAllProperties();
            }
            active.refreshTree(gPXObject.getParent());
            active.setGpxObject(gPXObject.getParent());
        }
    }

    private void routeToTrack() {
        if (!(active.getGpxObject() instanceof Route)) {
            this.msg.volatileError("not a route");
        }
        Route route = (Route)active.getGpxObject();
        GPXFile gPXFile = active.getGpxFile();
        Track track = new Track(route.getColor());
        track.setName(route.getName().replace("Route", "Track"));
        track.setCmt(route.getCmt());
        track.setDesc(route.getDesc());
        track.setSrc(route.getSrc());
        track.addTrackseg(new WaypointGroup(route.getPath()));
        gPXFile.addTrack(track);
        gPXFile.updateAllProperties();
        active.refresh();
        active.refreshTree();
    }

    private void trackToRoute() {
        Track track;
        if (!(active.getGpxObject() instanceof Track)) {
            this.msg.volatileError("not a track");
        }
        if ((track = (Track)active.getGpxObject()).getTracksegs().size() > 1) {
            this.msg.volatileError("Track contains more than one segment");
        }
        GPXFile gPXFile = active.getGpxFile();
        Route route = gPXFile.addRoute();
        route.setName(track.getName().replace("Track", "Route"));
        route.setCmt(track.getCmt());
        route.setDesc(track.getDesc());
        route.setSrc(track.getSrc());
        for (Waypoint waypoint : track.getTracksegs().get(0).getWaypoints()) {
            route.getPath().addWaypoint(new Waypoint(waypoint));
        }
        gPXFile.updateAllProperties();
        active.refresh();
        active.refreshTree(gPXFile);
    }

    private void addRoute() {
        GPXFile gPXFile = active.getGpxFile();
        Route route = gPXFile.addRoute();
        route.setName("New Route");
        active.getUndoStack().push(new UndoAddRoute(route, gPXFile));
        active.refresh();
        active.refreshTree(route.getParent());
    }

    private void undo() {
        if (active.getUndoStack().size() > 0) {
            try {
                IUndoable iUndoable = active.getUndoStack().pop();
                iUndoable.undo();
                iUndoable = null;
            }
            catch (Exception exception) {
                this.msg.error("Undo failed", exception);
            }
        }
        this.firePropertyChange("undo", null, null);
        active.refresh();
        active.refreshTree();
        active.repaintMap();
    }

    private void handleUndoNotification() {
        if (active.getUndoStack().size() > 0) {
            IUndoable iUndoable = active.getUndoStack().peek();
            this.btnUndo.setToolTipText("Undo: " + iUndoable.getUndoDescription() + " (CTRL-Z)");
        }
        this.updateButtonVisibility();
    }

    private void handleWindowEvent(WindowEvent windowEvent, int n) {
        Object object = windowEvent.getSource();
        if (n == 202 || n == 201) {
            if (object instanceof DownloadGpsies) {
                this.btnDownloadGpsies.setEnabled(true);
            }
            if (object instanceof UploadGpsies) {
                this.btnUploadGpsies.setEnabled(true);
            }
            if (object instanceof DownloadOsm) {
                this.btnDownloadOsm.setEnabled(true);
            }
            if (object instanceof GetWikipedia) {
                this.btndownloadWiki.setEnabled(true);
            }
            if (object instanceof InfoDialog) {
                this.btnInfo.setEnabled(true);
            }
            if (object instanceof CleaningDialog) {
                this.btnCleaning.setEnabled(true);
            }
            if (object instanceof ChartWindow) {
                this.tglChart.setSelected(false);
            }
            if (object instanceof ImageViewer && this.imageViewer != null) {
                this.imageViewer = null;
            }
            if (object instanceof DBDialog) {
                this.btnDatabase.setEnabled(true);
            }
            if (object instanceof TimeshiftDialog) {
                this.btnTimeShift.setEnabled(true);
            }
        }
    }

    private void handlePropertyChangeEvent(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("newGpx")) {
            this.handleNewGpx(propertyChangeEvent);
        } else if (string.equals("activeGpxObject")) {
            if (this.autoFitToPanel) {
                this.mapPanel.fitGPXObjectToPanel(active.getGpxObject());
            }
            this.updateButtonVisibility();
        } else if (string.equals("removeGpx")) {
            this.deleteActiveGPXObject();
        } else if (string.equals("toTrack")) {
            this.routeToTrack();
        } else if (string.equals("toRoute")) {
            this.trackToRoute();
        } else if (string.equals("addRoute")) {
            this.addRoute();
        } else if (string.equals("addRoutept")) {
            if (this.pathFinder != null) {
                Waypoint waypoint = (Waypoint)propertyChangeEvent.getNewValue();
                this.findPath(waypoint);
            }
        } else if (string.equals("logChanged")) {
            this.updateLogDialogButton(this.transferStatusDialog.getItems());
        } else if (string.equals("1click")) {
            this.handle1Click(propertyChangeEvent.getNewValue());
        } else if (string.equals("2click")) {
            this.handle2Click(propertyChangeEvent.getNewValue());
        } else if (string.equals("gpsiesUsername")) {
            this.conf.setGpsiesUsername((String)propertyChangeEvent.getNewValue());
        } else if (string.equals("undo")) {
            this.handleUndoNotification();
        }
    }

    private void handleNewGpx(PropertyChangeEvent propertyChangeEvent) {
        GPXFile gPXFile = (GPXFile)propertyChangeEvent.getNewValue();
        gPXFile.updateAllProperties();
        if (this.conf.useExtensions()) {
            this.postLoad(gPXFile);
        }
        active.addGpxFile(gPXFile);
        active.setGpxObject(gPXFile);
        this.mapPanel.setShownPoint(null);
    }

    private void handle1Click(Object object) {
        if (object instanceof PhotoMarker && this.imageViewer != null) {
            this.imageViewer.showMarker((PhotoMarker)object);
        } else if (object instanceof Marker && this.tglDelPoints.isSelected()) {
            this.mapPanel.getMarkerList().remove(object);
            GPXFile gPXFile = active.getGpxFile();
            if (gPXFile != null) {
                gPXFile.getWaypointGroup().removeWaypoint((Marker)object);
                this.mapPanel.repaint();
            }
        }
    }

    private void handle2Click(Object object) {
        if (object instanceof WikiMarker) {
            WikiMarker wikiMarker = (WikiMarker)object;
            if (wikiMarker.getLink().size() > 0) {
                BrowserLauncher.launchBrowser(wikiMarker.getLink().get(0).getHref());
            }
        } else if (object instanceof PhotoMarker) {
            if (this.imageViewer == null) {
                this.imageViewer = new ImageViewer(this.frame, this.msg);
                this.imageViewer.setAlwaysOnTop(true);
                this.imageViewer.addWindowListener(this.windowListener);
                this.imageViewer.setGpxFiles(active.getGpxFiles());
                this.imageViewer.begin();
            }
            this.imageViewer.showMarker((PhotoMarker)object);
        } else if (object instanceof WaypointMarker) {
            for (LinkType linkType : ((WaypointMarker)object).getLink()) {
                BrowserLauncher.launchBrowser(linkType.getHref());
            }
        }
    }

    private void updateActiveWpt(MouseEvent mouseEvent) {
        if (active.getGpxObject() != null) {
            Waypoint waypoint = null;
            Point point = mouseEvent.getPoint();
            boolean bl = false;
            for (WaypointGroup waypointGroup : active.getGroups()) {
                if (waypointGroup.isVisible()) {
                    int n = 0;
                    int n2 = waypointGroup.getNumPts();
                    double d = Double.MAX_VALUE;
                    if (this.tglSplitTrackseg.isSelected()) {
                        n = 1;
                        n2 = waypointGroup.getNumPts() - 1;
                    }
                    for (int i = n; i < n2; ++i) {
                        Waypoint waypoint2 = waypointGroup.getWaypoints().get(i);
                        Point point2 = this.mapPanel.getMapPosition(waypoint2.getLat(), waypoint2.getLon(), false);
                        int n3 = point2.x - point.x;
                        int n4 = point2.y - point.y;
                        double d2 = Math.sqrt(n3 * n3 + n4 * n4);
                        if (!(d2 < 10.0) || !(d2 < d)) continue;
                        d = d2;
                        waypoint = waypoint2;
                        bl = true;
                    }
                }
                if (!bl) continue;
                active.setGroup(waypointGroup);
                active.setTrackpoint(waypoint, false);
                break;
            }
            if (!bl) {
                active.setGroup(null);
                active.setTrackpoint(null);
                this.mapPanel.setShownPoint(null);
            }
        }
    }

    private void deselectAllToggles(JToggleButton jToggleButton) {
        for (JToggleButton jToggleButton2 : this.toggles) {
            if (jToggleButton2 == jToggleButton || !jToggleButton2.isSelected()) continue;
            jToggleButton2.setSelected(false);
        }
    }

    private void pathFinderOn() {
        this.pathFinder = new PathFinder();
        this.pathFinder.setGpxObject();
        this.pathFinder.setMessageCenter(this.msg);
        this.pathFinderWidget = new PathFinderWidget(this.pathFinder);
        this.pathFinderWidget.setRouteProviders(RouteProviderFactory.getAllProviders());
        this.searchPanel.setRoutepointEnabled(true);
        this.mapPanel.add(this.pathFinderWidget);
        this.mapCursor = this.CROSSHAIR_CURSOR;
        this.routeInfoPanel = this.msg.infoOn("Click on map to add points along the planned route");
    }

    private void pathFinderOff() {
        this.msg.infoOff(this.routeInfoPanel);
        this.mapCursor = this.DEFAULT_CURSOR;
        this.searchPanel.setRoutepointEnabled(false);
        if (this.pathFinderWidget != null) {
            this.mapPanel.remove(this.pathFinderWidget);
            this.pathFinderWidget = null;
        }
        this.pathFinder.clear();
        this.pathFinder = null;
    }

    private void findPath(MouseEvent mouseEvent) {
        int n = this.mapPanel.getZoom();
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        Point point = this.mapPanel.getCenter();
        int n4 = point.x - this.mapPanel.getWidth() / 2;
        int n5 = point.y - this.mapPanel.getHeight() / 2;
        double d = OsmMercator.MERCATOR_256.yToLat(n5 + n3, n);
        double d2 = OsmMercator.MERCATOR_256.xToLon(n4 + n2, n);
        this.findPath(new Waypoint(d, d2));
    }

    private void findPath(Waypoint waypoint) {
        try {
            this.pathFinder.findRoute(waypoint);
        }
        catch (Exception exception) {
            this.msg.error(exception);
        }
    }

    private void enableChart() {
        this.chartWindow = new ChartWindow(this.frame);
        this.chartWindow.addWindowListener(this.windowListener);
        this.chartWindow.setVisible(false);
        this.chartHandler = new ChartHandler(this.uc);
        this.chartHandler.setParentPane(this.splitPaneMap, 0.85f);
        this.splitPaneMap.setResizeWeight(0.85f);
        this.chartHandler.setChartWindow(this.chartWindow);
        active.addPropertyChangeListener(this.chartHandler.getPropertyChangeListener());
        this.chartHandler.setActiveGpxObject(active.getGpxObject());
        this.chartHandler.setInteractive(true);
    }

    private void disableChart() {
        this.chartHandler.setParentPane(null, 0.0);
        active.removePropertyChangeListener(this.chartHandler.getPropertyChangeListener());
        this.chartHandler.terminate();
        this.chartHandler = null;
        this.chartWindow = null;
    }

    private void preloadChart() {
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                ChartHandler chartHandler = new ChartHandler(GpsMaster.this.uc);
                ChartWindow chartWindow = new ChartWindow(GpsMaster.this.frame);
                return null;
            }
        };
        swingWorker.execute();
    }

    private void editProperties() {
        GPXObject gPXObject = active.getGpxObject();
        EditPropsDialog editPropsDialog = new EditPropsDialog((Frame)this.frame, "Edit properties", gPXObject);
        editPropsDialog.setVisible(true);
        if (gPXObject.isGPXFile()) {
            GPXFile gPXFile = (GPXFile)gPXObject;
            if (gPXFile.getExtension().containsKey("gpsm:activity")) {
                gPXFile.getExtension().remove("gpsm:activity");
            }
            if (!editPropsDialog.getActivity().isEmpty()) {
                gPXFile.getExtension().add("gpsm:activity", editPropsDialog.getActivity());
                if (this.activityHandler != null) {
                    this.activityHandler.setActivity(editPropsDialog.getActivity());
                }
            }
            if (editPropsDialog.getName() != null) {
                gPXFile.getMetadata().setName(editPropsDialog.getName());
            }
            if (editPropsDialog.getDesc() != null) {
                gPXFile.getMetadata().setDesc(editPropsDialog.getDesc());
            }
        } else {
            if (editPropsDialog.getName() != null) {
                gPXObject.setName(editPropsDialog.getName());
            }
            if (editPropsDialog.getDesc() != null) {
                gPXObject.setDesc(editPropsDialog.getDesc());
            }
        }
        if (gPXObject.isRoute()) {
            if (editPropsDialog.getGPXType() != null) {
                ((Route)gPXObject).setType(editPropsDialog.getGPXType());
            }
            if (editPropsDialog.getNumber() != null) {
                ((Route)gPXObject).setNumber(editPropsDialog.getNumber());
            }
        }
        if (gPXObject.isTrack()) {
            if (editPropsDialog.getGPXType() != null) {
                ((Track)gPXObject).setType(editPropsDialog.getGPXType());
            }
            if (editPropsDialog.getNumber() != null) {
                ((Track)gPXObject).setNumber(editPropsDialog.getNumber());
            }
        }
    }

    private void adjustColors(GPXFile gPXFile) {
        for (Track track : gPXFile.getTracks()) {
            if (track.getTracksegs().size() <= 1) continue;
            int n = 25;
            int n2 = track.getColor().getRed();
            int n3 = track.getColor().getGreen();
            int n4 = track.getColor().getBlue();
            for (WaypointGroup waypointGroup : track.getTracksegs()) {
                if (waypointGroup.getExtension().containsKey("gpsm:color")) continue;
                n2 = track.getColor().getRed() == 0 ? Math.min(n2 + n, 255) : Math.max(n2 - n, 0);
                n3 = track.getColor().getGreen() == 0 ? Math.min(n3 + n, 255) : Math.max(n3 - n, 0);
                n4 = track.getColor().getBlue() == 0 ? Math.min(n4 + n, 255) : Math.max(n4 - n, 0);
                Color color = new Color(n2, n3, n4);
                waypointGroup.setColor(color);
            }
        }
    }

    private void fileLoad() {
        JFileChooser jFileChooser = null;
        FileOpenDialog fileOpenDialog = new FileOpenDialog(this.frame, this.msg, this.centralFileHub);
        fileOpenDialog.setConfig(this.conf);
        jFileChooser = fileOpenDialog.getFileChooser();
        jFileChooser.setMultiSelectionEnabled(true);
        for (String string : this.loaderFactory.getExtensions()) {
            String string2 = string.toUpperCase() + " files (*." + string + ")";
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(string2, string);
            jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
            if (!string.equals(this.conf.getDefaultExt())) continue;
            jFileChooser.setFileFilter(fileNameExtensionFilter);
        }
        fileOpenDialog.begin();
    }

    private void setupFileHub(final FileHub fileHub, List<IItemTarget> list) {
        final ProgressWidget progressWidget = new ProgressWidget();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("transferStarted")) {
                    progressWidget.setTitle(fileHub.getProgressTitle());
                    GpsMaster.this.mapPanel.add(progressWidget);
                    GpsMaster.this.mapPanel.validate();
                } else if (string.equals("transferFinished")) {
                    GpsMaster.this.mapPanel.remove(progressWidget);
                    if (fileHub.isCancelled()) {
                        GpsMaster.this.msg.volatileWarning("Transfer of files cancelled");
                    }
                    GpsMaster.this.transferStatusDialog.addItems(fileHub.getProcessedItems());
                    GpsMaster.this.showItemTransferStatus(fileHub.getProcessedItems());
                    GpsMaster.this.updateLogDialogButton(GpsMaster.this.transferStatusDialog.getItems());
                    fileHub.getItemSource().getItems().clear();
                    fileHub.getProcessedItems().clear();
                }
            }
        };
        if (list != null) {
            for (IItemTarget iItemTarget : list) {
                fileHub.addItemTarget(iItemTarget);
            }
        }
        fileHub.setProgressReporter(progressWidget);
        fileHub.addChangeListener(propertyChangeListener);
    }

    private void showItemTransferStatus(List<TransferableItem> list) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (TransferableItem transferableItem : list) {
            if (transferableItem.getLog().getFailureState() == 1) {
                ++n;
            }
            if (transferableItem.getLog().getFailureState() == 2) {
                ++n2;
            }
            if (transferableItem.getLog().getFailureState() != 3) continue;
            ++n3;
        }
        if (n > 0) {
            this.msg.volatileInfo(String.format("%d file(s) loaded successfully.", n));
        }
        if (n2 > 0) {
            this.msg.volatileWarning(String.format("%d file(s) loaded with warnings.", n2));
        }
        if (n3 > 0) {
            this.msg.error(String.format("Transfer of %d file(s) failed.", n3));
        }
    }

    private void updateLogDialogButton(List<TransferableItem> list) {
        int n = 0;
        for (TransferableItem transferableItem : list) {
            int n2 = transferableItem.getLog().getFailureState();
            if (n2 <= n) continue;
            n = n2;
        }
        switch (n) {
            case 2: {
                this.btnLogWindow.setBorder(BorderFactory.createLineBorder(this.msg.getWarningColor(), 3));
                this.btnLogWindow.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("warning.png"))));
                break;
            }
            case 3: {
                this.btnLogWindow.setBorder(BorderFactory.createLineBorder(this.msg.getErrorColor(), 3));
                this.btnLogWindow.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("error.png"))));
                break;
            }
            default: {
                this.btnLogWindow.setBorder(null);
                this.btnLogWindow.setIcon(new ImageIcon(GpsMaster.class.getResource("/org/gpsmaster/icons/menubar/".concat("ok.png"))));
            }
        }
    }

    private void downloadGpsies() {
        FileHub fileHub = new FileHub();
        this.setupFileHub(fileHub, this.centralTargets);
        DownloadGpsies downloadGpsies = new DownloadGpsies(this.frame, this.msg, fileHub, this.uc);
        fileHub.setItemSource(downloadGpsies);
        fileHub.setTitle(((GenericDialog)downloadGpsies).getTitle());
        this.btnDownloadGpsies.setEnabled(false);
        downloadGpsies.setGeoBounds(this.mapPanel.getVisibleBounds());
        downloadGpsies.addWindowListener(this.windowListener);
        ((GenericDownloadDialog)downloadGpsies).begin();
    }

    private void uploadGpsies() {
        this.btnUploadGpsies.setEnabled(false);
        UploadGpsies uploadGpsies = new UploadGpsies(active.getGpxFile(), this.frame, this.msg);
        if (this.conf.getGpsiesUsername() != null) {
            uploadGpsies.setUsername(this.conf.getGpsiesUsername());
        }
        uploadGpsies.addWindowListener(this.windowListener);
        uploadGpsies.begin();
    }

    private void downloadOsm() {
        FileHub fileHub = new FileHub();
        this.setupFileHub(fileHub, this.centralTargets);
        DownloadOsm downloadOsm = new DownloadOsm(this.frame, this.msg, fileHub, this.uc);
        fileHub.setItemSource(downloadOsm);
        fileHub.setTitle(((GenericDialog)downloadOsm).getTitle());
        this.btnDownloadOsm.setEnabled(false);
        downloadOsm.setGeoBounds(this.mapPanel.getVisibleBounds());
        downloadOsm.addWindowListener(this.windowListener);
        ((GenericDownloadDialog)downloadOsm).begin();
    }

    private void downloadWiki() {
        FileHub fileHub = new FileHub();
        GetWikipedia getWikipedia = new GetWikipedia(this.frame, this.msg, fileHub, this.uc);
        fileHub.setTitle(((GenericDialog)getWikipedia).getTitle());
        fileHub.setItemSource(getWikipedia);
        fileHub.addItemTarget(this.transferTargetMap);
        this.setupFileHub(fileHub, null);
        this.btndownloadWiki.setEnabled(false);
        getWikipedia.setGeoBounds(this.mapPanel.getVisibleBounds());
        getWikipedia.addWindowListener(this.windowListener);
        ((GenericDownloadDialog)getWikipedia).begin();
    }

    private void openDbDialog() {
        FileHub fileHub = new FileHub();
        DBDialog dBDialog = new DBDialog(this.frame, this.msg, this.db, fileHub);
        fileHub.setItemSource(dBDialog);
        fileHub.setTitle(dBDialog.getTitle());
        this.setupFileHub(fileHub, this.centralTargets);
        this.btnDatabase.setEnabled(false);
        dBDialog.setUnitConverter(this.uc);
        this.addPropertyChangeListener(dBDialog.getChangeListener());
        dBDialog.addWindowListener(this.windowListener);
        dBDialog.begin();
    }

    private void showInfo() {
        this.btnInfo.setEnabled(false);
        InfoDialog infoDialog = new InfoDialog(this.frame, ME);
        infoDialog.addWindowListener(this.windowListener);
        infoDialog.begin();
        infoDialog.setVisible(true);
    }

    private void doTimeShift() {
        this.btnTimeShift.setEnabled(false);
        TimeshiftDialog timeshiftDialog = new TimeshiftDialog(this.frame, this.msg);
        timeshiftDialog.addPropertyChangeListener(this.propertyListener);
        timeshiftDialog.addWindowListener(this.windowListener);
        timeshiftDialog.begin();
    }

    private void doCleaning() {
        this.btnCleaning.setEnabled(false);
        CleaningDialog cleaningDialog = new CleaningDialog(this.frame, this.msg);
        cleaningDialog.setMarkerList(this.mapPanel.getMarkerList());
        cleaningDialog.addPropertyChangeListener(this.propertyListener);
        cleaningDialog.addWindowListener(this.windowListener);
        cleaningDialog.begin();
    }

    private void checkLegacy(GPXObject gPXObject) {
        Color color = null;
        String string = null;
        GPXExtension gPXExtension = null;
        if (gPXObject.getExtension().containsKey("color")) {
            string = gPXObject.getExtension().getSubValue("color");
            gPXObject.getExtension().remove("color");
            try {
                String[] stringArray = string.split(",");
                if (stringArray.length == 4) {
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    int n3 = Integer.parseInt(stringArray[2]);
                    int n4 = Integer.parseInt(stringArray[3]);
                    color = new Color(n, n2, n3, n4);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.msg.volatileWarning("Unsupported color format", numberFormatException);
            }
        }
        if (color != null) {
            gPXObject.setColor(color);
        }
        if ((gPXExtension = gPXObject.getExtension().getExtension("activity")) != null) {
            gPXExtension.setValue("gpsm:activity");
        }
    }

    private void postLoad(GPXFile gPXFile) {
        Object object;
        if (gPXFile.getMetadata().getTime() == null && gPXFile.getTracks().size() > 0 && ((Track)(object = gPXFile.getTracks().get(0))).getTracksegs().size() > 0) {
            gPXFile.getMetadata().setTime(((Track)object).getTracksegs().get(0).getStart().getTime());
        }
        for (Track track : gPXFile.getTracks()) {
            Collections.sort(track.getTracksegs());
        }
        Collections.sort(gPXFile.getTracks());
        Collections.sort(gPXFile.getWaypointGroup().getWaypoints());
    }

    private void printVisibleMap() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setJobName(ME);
        if (printerJob.printDialog()) {
            MapPrinter mapPrinter = new MapPrinter();
            mapPrinter.setMapPanel(this.mapPanel);
            printerJob.setPrintable(mapPrinter);
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                this.msg.error(printerException);
            }
        }
    }

    private void saveMapToImage() {
        int n = this.mapPanel.getWidth();
        int n2 = this.mapPanel.getHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        this.mapPanel.paint(bufferedImage.getGraphics());
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", new File("mapPanel.png"));
        }
        catch (IOException iOException) {
            this.msg.error(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.configFilename);
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Config.class});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            this.conf = (Config)unmarshaller.unmarshal((InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.msg.volatileWarning("Configuration file not found, using defaults.");
        }
        catch (JAXBException jAXBException) {
            this.msg.volatileWarning("Unable to parse configuration file, using defaults. existing file will be overwritten on exit.");
        }
        catch (IOException iOException) {
            this.msg.error(iOException);
        }
        finally {
            if (this.conf == null) {
                this.conf = new Config();
                this.conf.setVersion(VERSION_NUMBER);
            }
        }
        if (this.conf.getPalette().size() == 0) {
            this.initColors(this.conf.getPalette());
        }
    }

    private void saveConfig() {
        Point point = this.mapPanel.getCenter();
        double d = OsmMercator.MERCATOR_256.yToLat(point.y, this.mapPanel.getZoom());
        double d2 = OsmMercator.MERCATOR_256.xToLon(point.x, this.mapPanel.getZoom());
        this.conf.setLon(d2);
        this.conf.setLat(d);
        this.conf.setPositionZoom(this.mapPanel.getZoom());
        LoaderConfig loaderConfig = new LoaderConfig();
        loaderConfig.setClassName("org.gpsmaster.gsploader.FitLoader");
        loaderConfig.getMap().put("version", "2");
        loaderConfig.getMap().put("keeprawdata", "0");
        this.conf.getLoaderConfigs().add(loaderConfig);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.configFilename);
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Config.class});
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.marshal((Object)this.conf, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            this.msg.volatileWarning("Error saving configuration", exception);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void initColors(List<NamedColor> list) {
        list.add(new NamedColor(new Color(247, 186, 11), "RAL 1003 Signal Yellow"));
        list.add(new NamedColor(new Color(212, 101, 47), "RAL 2010 Signal Orange"));
        list.add(new NamedColor(new Color(160, 33, 40), "RAL 3001 Signal Red"));
        list.add(new NamedColor(new Color(144, 70, 132), "RAL 4008 Signal Violet"));
        list.add(new NamedColor(new Color(21, 72, 137), "RAL 5005 Signal Blue"));
        list.add(new NamedColor(new Color(15, 133, 88), "RAL 6032 Signal Green"));
        list.add(new NamedColor(new Color(158, 160, 161), "RAL 7004 Signal Grey"));
        list.add(new NamedColor(new Color(123, 81, 65), "RAL 8002 Signal Brown"));
        list.add(new NamedColor(new Color(244, 248, 244), "RAL 9003 Signal White"));
        list.add(new NamedColor(new Color(240, 202, 0), "RAL 1023 Traffic Yellow"));
        list.add(new NamedColor(new Color(225, 85, 1), "RAL 2009 Traffic Orange"));
        list.add(new NamedColor(new Color(193, 18, 28), "RAL 3020 Traffic Red"));
        list.add(new NamedColor(new Color(153, 37, 114), "RAL 4006 Traffic Purple"));
        list.add(new NamedColor(new Color(14, 81, 141), "RAL 5017 Traffic Blue"));
        list.add(new NamedColor(new Color(0, 135, 84), "RAL 6024 Traffic Green"));
        list.add(new NamedColor(new Color(143, 150, 149), "RAL 7042 Traffic Grey A"));
        list.add(new NamedColor(new Color(78, 84, 81), "RAL 7043 Traffic Grey B"));
        list.add(new NamedColor(new Color(247, 251, 245), "RAL 9016 Traffic White"));
    }

    private void correctElevation() {
        this.btnCorrectEle.setEnabled(false);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("eleFinished")) {
                    GpsMaster.this.btnCorrectEle.setEnabled(true);
                    GpsMaster.this.mapPanel.remove((ProgressWidget)GpsMaster.this.eleCorr.getProgressReporter());
                    if (GpsMaster.this.eleCorr.isCancelled()) {
                        GpsMaster.this.msg.volatileWarning("Elevation correction cancelled");
                    } else {
                        GpsMaster.this.msg.volatileInfo("Elevation correction finished");
                    }
                }
            }
        };
        ProgressWidget progressWidget = new ProgressWidget();
        MapQuestProvider mapQuestProvider = new MapQuestProvider();
        progressWidget.setFooter(mapQuestProvider.getAttribution());
        this.eleCorr = new Corrector(mapQuestProvider);
        this.eleCorr.setProgressReporter(progressWidget);
        this.eleCorr.setChangeListener(propertyChangeListener);
        this.eleCorr.setWaypointGroups(active.getGroups(7));
        this.eleCorr.setRunInBackground(true);
        this.mapPanel.add(progressWidget);
        this.mapPanel.validate();
        this.eleCorr.correct();
    }

    private void getFromDevice() {
        try {
            MoveBikeCompMPT moveBikeCompMPT = new MoveBikeCompMPT();
            moveBikeCompMPT.getConnectionParams().put("DBFILE", "D:\\Projekte\\Touring\\Temp\\bikecomp.db");
            moveBikeCompMPT.connect();
            for (OnlineTrack onlineTrack : moveBikeCompMPT.getTracklist()) {
                if (onlineTrack.getId() <= 200L) continue;
                System.out.println(onlineTrack.getId());
                GPXFile gPXFile = moveBikeCompMPT.load(onlineTrack);
                active.addGpxFile(gPXFile);
            }
            moveBikeCompMPT.disconnect();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doDebug() {
    }

    static {
        active = null;
    }
}

