/*
 * Decompiled with CFR 0.152.
 */
package org.gpsmaster;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import org.gpsmaster.Core;
import org.gpsmaster.gpxpanel.GPXFile;
import org.gpsmaster.gpxpanel.GPXObject;
import org.gpsmaster.gpxpanel.GPXRoot;
import org.gpsmaster.gpxpanel.Track;
import org.gpsmaster.gpxpanel.Waypoint;
import org.gpsmaster.gpxpanel.WaypointGroup;
import org.gpsmaster.marker.Marker;
import org.gpsmaster.tree.GPXTree;
import org.gpsmaster.undo.IUndoable;

public class ActiveGpxObjects {
    private GPXTree tree = null;
    private GPXRoot gpxRoot = new GPXRoot();
    private Core core = null;
    private Waypoint activeTrackpoint = null;
    private Waypoint activeWaypoint = null;
    private WaypointGroup activeGroup = null;
    private GPXObject gpxObject = null;
    private GPXFile gpxFile = null;
    private List<WaypointGroup> allGroups = new ArrayList<WaypointGroup>();
    private PropertyChangeSupport pcs = null;
    private PropertyChangeListener propertyListener = null;
    private Stack<IUndoable> undoStack = null;
    public static final int SEG_TRACK = 0;
    public static final int SEG_ROUTE = 1;
    public static final int SEG_WAYPOINTS = 2;
    public static final int SEG_ROUTE_TRACK = 3;
    public static final int SEG_TRACK_ROUTE_WAYPOINTS = 4;
    public static final int SEG_TRACK_WAYPOINTS = 5;
    public static final int SEG_ROUTE_WAYPOINTS = 6;
    public static final int SEG_ALL = 7;

    public ActiveGpxObjects(GPXTree gPXTree) {
        this.tree = gPXTree;
        this.gpxRoot = (GPXRoot)gPXTree.getModel().getRoot();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)gPXTree.getModel();
        defaultTreeModel.setRoot(this.gpxRoot);
        this.core = new Core();
        this.pcs = new PropertyChangeSupport(this);
        this.makeListeners();
        this.undoStack = new Stack();
    }

    public void addGpxFile(GPXFile gPXFile) {
        this.gpxRoot.addGpxFile(gPXFile);
        this.refreshTree();
    }

    public void removeGpxFile(GPXFile gPXFile) {
        this.gpxRoot.removeGpxFile(gPXFile);
        this.refreshTree();
    }

    public List<GPXFile> getGpxFiles() {
        return this.gpxRoot.getGpxFiles();
    }

    public GPXObject getGpxObject() {
        return this.gpxObject;
    }

    public void setGpxObject(GPXObject gPXObject) {
        this.setActiveGpx(gPXObject);
        this.tree.setSelectedGpxObject(gPXObject);
    }

    public GPXFile getGpxFile() {
        return this.gpxFile;
    }

    public WaypointGroup getGroup() {
        return this.activeGroup;
    }

    public void setGroup(WaypointGroup waypointGroup) {
        if (waypointGroup != null && !this.allGroups.contains(waypointGroup)) {
            throw new IllegalArgumentException();
        }
        this.activeGroup = waypointGroup;
    }

    public List<WaypointGroup> getGroups() {
        return this.allGroups;
    }

    public List<WaypointGroup> getGroups(int n) {
        return this.core.getSegments(this.gpxObject, n);
    }

    public Waypoint getWaypoint() {
        return this.activeWaypoint;
    }

    public void setWaypoint(Waypoint waypoint) {
        this.setActiveWaypoint(waypoint);
    }

    public Waypoint getTrackpoint() {
        return this.activeTrackpoint;
    }

    public void setTrackpoint(Waypoint waypoint) {
        this.setActiveTrackpoint(waypoint, true);
    }

    public void setTrackpoint(Waypoint waypoint, boolean bl) {
        this.setActiveTrackpoint(waypoint, bl);
    }

    public Track getTrackForSegment(WaypointGroup waypointGroup) {
        return (Track)waypointGroup.getParent();
    }

    public int getNumWaypointGroups() {
        return this.allGroups.size();
    }

    public int getNumWaypoints() {
        int n = 0;
        for (WaypointGroup waypointGroup : this.allGroups) {
            n += waypointGroup.getNumPts();
        }
        return n;
    }

    public int getIndexOf(Waypoint waypoint) {
        int n = -1;
        if (this.activeGroup != null && waypoint != null) {
            n = this.activeGroup.getWaypoints().indexOf(waypoint);
        }
        return n;
    }

    public int getTotalIndexOf(Waypoint waypoint) {
        int n = 0;
        if (waypoint != null) {
            for (WaypointGroup waypointGroup : this.allGroups) {
                int n2 = waypointGroup.getWaypoints().indexOf(waypoint);
                if (n2 > -1) {
                    return n + n2;
                }
                n += waypointGroup.getNumPts();
            }
        }
        return -1;
    }

    public void setTrackpoint(int n) {
        Waypoint waypoint = null;
        this.activeGroup = null;
        int n2 = 0;
        int n3 = 0;
        for (WaypointGroup waypointGroup : this.allGroups) {
            if (n <= (n3 += waypointGroup.getNumPts())) {
                int n4 = n - n2;
                waypoint = waypointGroup.getWaypoints().get(n4);
                this.activeGroup = waypointGroup;
                break;
            }
            n2 += waypointGroup.getNumPts();
        }
        this.setActiveTrackpoint(waypoint, false);
    }

    public PropertyChangeListener getPropertyChangeListener() {
        return this.propertyListener;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addUndoOperation(IUndoable iUndoable) {
        if (this.undoStack != null) {
            this.undoStack.push(iUndoable);
        }
        this.pcs.firePropertyChange("undo", null, null);
    }

    public Stack<IUndoable> getUndoStack() {
        return this.undoStack;
    }

    public boolean isUndoEnabled() {
        return this.undoStack != null;
    }

    public void refresh() {
        if (this.gpxObject != null) {
            this.gpxObject.updateAllProperties();
        }
        this.pcs.firePropertyChange("refreshGpx", null, null);
    }

    public void refreshTree() {
        this.refreshTree(this.gpxRoot);
    }

    public void refreshTree(GPXObject gPXObject) {
        if (gPXObject != null) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
            defaultTreeModel.nodeStructureChanged(gPXObject);
            this.tree.refresh(gPXObject);
            this.allGroups = this.core.getSegments(this.gpxObject, 3);
            this.repaintMap();
        }
    }

    public void repaintMap() {
        this.pcs.firePropertyChange("repaintMap", null, null);
    }

    public void addMarker(Marker marker) {
        this.pcs.firePropertyChange("addMarker", null, marker);
    }

    public void removeMarker(Marker marker) {
        this.pcs.firePropertyChange("removeMarker", null, marker);
    }

    public void clear() {
        this.gpxObject = null;
        this.gpxFile = null;
        this.activeTrackpoint = null;
        this.activeGroup = null;
        this.allGroups.clear();
    }

    private void makeListeners() {
        this.propertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("activeGpxObject")) {
                    ActiveGpxObjects.this.setActiveGpx((GPXObject)propertyChangeEvent.getNewValue());
                }
            }
        };
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object = ActiveGpxObjects.this.tree.getLastSelectedPathComponent();
                if (object == null) {
                    ActiveGpxObjects.this.setActiveGpx(null);
                    return;
                }
                if (object instanceof GPXObject) {
                    ActiveGpxObjects.this.setGpxFromTree((GPXObject)object);
                    ActiveGpxObjects.this.setActiveGpx((GPXObject)object);
                }
                if (object instanceof Marker) {
                    ActiveGpxObjects.this.setActiveWaypoint((Marker)object);
                }
            }
        });
    }

    private void setActiveTrackpoint(Waypoint waypoint, boolean bl) {
        boolean bl2 = true;
        if (this.activeTrackpoint == null && waypoint == null) {
            return;
        }
        bl2 = this.activeTrackpoint != null ? this.activeTrackpoint.equals(waypoint) : waypoint.equals(this.activeTrackpoint);
        if (!bl2) {
            this.activeTrackpoint = waypoint;
            if (bl) {
                this.activeGroup = null;
                for (WaypointGroup waypointGroup : this.allGroups) {
                    if (!waypointGroup.getWaypoints().contains(this.activeTrackpoint)) continue;
                    this.activeGroup = waypointGroup;
                    break;
                }
            }
            this.pcs.firePropertyChange("activeTrkPt", null, this.activeTrackpoint);
        }
    }

    private void setActiveWaypoint(Waypoint waypoint) {
        this.activeWaypoint = waypoint;
        this.pcs.firePropertyChange("activeWpt", null, waypoint);
    }

    private void setActiveGpx(GPXObject gPXObject) {
        if (gPXObject == null) {
            this.clear();
        } else {
            this.gpxObject = gPXObject;
            this.gpxObject.setVisible(true);
            this.allGroups = this.core.getSegments(gPXObject, 3);
        }
        this.pcs.firePropertyChange("activeGpxObject", null, this.gpxObject);
    }

    private void setGpxFromTree(GPXObject gPXObject) {
        while (!(gPXObject instanceof GPXFile)) {
            gPXObject = gPXObject.getParent();
        }
        this.gpxFile = (GPXFile)gPXObject;
    }

    public void centerMap(Waypoint waypoint) {
        this.pcs.firePropertyChange("centerMap", null, waypoint);
    }
}

