/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.provider.event;

import net.sf.marineapi.nmea.util.Date;
import net.sf.marineapi.nmea.util.FaaMode;
import net.sf.marineapi.nmea.util.GpsFixQuality;
import net.sf.marineapi.nmea.util.Position;
import net.sf.marineapi.nmea.util.Time;
import net.sf.marineapi.provider.event.ProviderEvent;

public class PositionEvent
extends ProviderEvent
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private Double course;
    private Date date;
    private Position position;
    private Double speed;
    private Time time;
    private FaaMode mode;
    private GpsFixQuality fix;

    public PositionEvent(Object source, Position p, double sog, double cog, Date d, Time t, FaaMode m, GpsFixQuality fq) {
        super(source);
        this.position = p;
        this.speed = sog;
        this.course = cog;
        this.date = d;
        this.time = t;
        this.mode = m;
        this.fix = fq;
    }

    public PositionEvent clone() {
        return new PositionEvent(this.getSource(), this.position, this.speed, this.course, this.date, this.time, this.mode, this.fix);
    }

    public Double getCourse() {
        return this.course;
    }

    public Date getDate() {
        return this.date;
    }

    public GpsFixQuality getFixQuality() {
        return this.fix;
    }

    public FaaMode getMode() {
        return this.mode;
    }

    public Position getPosition() {
        return this.position;
    }

    public Double getSpeed() {
        return this.speed * 1.852;
    }

    public Time getTime() {
        return this.time;
    }

    @Override
    public String toString() {
        String ptr = "t[%s %s] p%s v[%.01f, %.01f]";
        return String.format(ptr, this.date, this.time, this.position, this.speed, this.course);
    }
}

