/*
 * Decompiled with CFR 0.152.
 */
package net.sf.marineapi.nmea.sentence;

import java.util.regex.Pattern;
import net.sf.marineapi.nmea.sentence.Checksum;

public final class SentenceValidator {
    private static final Pattern reChecksum = Pattern.compile("^[$|!]{1}[A-Z0-9]{3,10}[,][\\x20-\\x7F]*[*][A-F0-9]{2}$");
    private static final Pattern reNoChecksum = Pattern.compile("^[$|!]{1}[A-Z0-9]{3,10}[,][\\x20-\\x7F]*$");

    private SentenceValidator() {
    }

    public static boolean isSentence(String nmea) {
        if (nmea == null || "".equals(nmea)) {
            return false;
        }
        if (nmea.indexOf(42) < 0) {
            return reNoChecksum.matcher(nmea).matches();
        }
        return reChecksum.matcher(nmea).matches();
    }

    public static boolean isValid(String nmea) {
        boolean isValid = false;
        if (SentenceValidator.isSentence(nmea)) {
            int i = nmea.indexOf(42);
            if (i > 0) {
                String sum = nmea.substring(++i, nmea.length());
                isValid = sum.equals(Checksum.calculate(nmea));
            } else {
                isValid = true;
            }
        }
        return isValid;
    }
}

