/*
 * Decompiled with CFR 0.152.
 */
package eu.fuegenstein.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ClassUtils {
    public static List<String> getResources(String string) throws IOException, URISyntaxException {
        URL uRL = ClassLoader.getSystemClassLoader().getResource(string);
        if (uRL.toString().startsWith("jar:")) {
            return ClassUtils.getResourcesFromJar(uRL, string);
        }
        if (uRL.toString().startsWith("file:")) {
            return ClassUtils.getResourcesFromFilesystem(uRL, string);
        }
        throw new FileNotFoundException(uRL.toString());
    }

    private static List<String> getResourcesFromFilesystem(URL uRL, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(uRL.getPath());
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                if (!file2.isFile()) continue;
                arrayList.add(file2.getName());
            }
        }
        return arrayList;
    }

    private static List<String> getResourcesFromJar(URL uRL, String string) throws IOException, URISyntaxException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = uRL.toString().replace("jar:", "").replace("file:", "");
        int n = string2.indexOf("!");
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        if (!string.endsWith("/")) {
            string = string.concat("/");
        }
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(string2));
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            String string3 = zipEntry.getName();
            if (string3.startsWith(string) && !string3.equals(string)) {
                arrayList.add(string3.replaceFirst(string, ""));
            }
            zipEntry = zipInputStream.getNextEntry();
        }
        zipInputStream.close();
        return arrayList;
    }
}

