/*
 * Decompiled with CFR 0.152.
 */
package eu.fuegenstein.unit;

import eu.fuegenstein.unit.Unit;
import eu.fuegenstein.unit.UnitSet;

public class UnitConverter {
    private UnitSet sourceSet = null;
    private UnitSet targetSet = null;
    private String symbolPrefix = "";

    public UnitSet getSourceSet() {
        return this.sourceSet;
    }

    public void setSourceSet(UnitSet unitSet) {
        this.sourceSet = unitSet;
    }

    public UnitSet getTargetSet() {
        return this.targetSet;
    }

    public void setTargetSet(UnitSet unitSet) {
        this.targetSet = unitSet;
    }

    public String getSymbolPrefix() {
        return this.symbolPrefix;
    }

    public void setSymbolPrefix(String string) {
        this.symbolPrefix = string;
    }

    public double dist(double d) {
        return this.convert(this.sourceSet.getDistanceUnit(), this.targetSet.getDistanceUnit(), d);
    }

    public String dist(double d, String string) {
        return this.resultString(this.dist(d), string, this.targetSet.getDistanceUnit());
    }

    public double speed(double d) {
        return this.convert(this.sourceSet.getSpeedUnit(), this.targetSet.getSpeedUnit(), d);
    }

    public String speed(double d, String string) {
        return this.resultString(this.speed(d), string, this.targetSet.getSpeedUnit());
    }

    public double ele(double d) {
        return this.convert(this.sourceSet.getElevationUnit(), this.targetSet.getElevationUnit(), d);
    }

    public String ele(double d, String string) {
        return this.resultString(this.ele(d), string, this.targetSet.getElevationUnit());
    }

    public double vertSpeed(double d) {
        return this.convert(this.sourceSet.getVerticalSpeedUnit(), this.targetSet.getVerticalSpeedUnit(), d);
    }

    public String vertSpeed(double d, String string) {
        return this.resultString(this.vertSpeed(d), string, this.targetSet.getVerticalSpeedUnit());
    }

    public double convert(Unit unit, Unit unit2, double d) {
        if (unit.equals(unit2)) {
            return d;
        }
        return 1.0 / unit.getFromStd() * d * unit2.getFromStd();
    }

    private String resultString(double d, String string, Unit unit) {
        return String.format(string + this.getSymbolPrefix() + unit.getSymbol(), d);
    }
}

