/*
 * Decompiled with CFR 0.152.
 */
package eu.fuegenstein.swing;

import eu.fuegenstein.swing.Widget;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class WidgetLayout
implements LayoutManager2 {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private Corner[] corners = new Corner[4];

    public WidgetLayout() {
        this.corners[0] = new Corner(0);
        this.corners[1] = new Corner(1);
        this.corners[2] = new Corner(2);
        this.corners[3] = new Corner(3);
    }

    public void setCornerOrientation(int n, int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Orientation");
        }
        this.corners[n].orientation = n2;
    }

    public void setCornerOffset(int n, Point point) {
        this.checkCorner(n);
        this.corners[n].offset = point;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.checkComp(component);
        Widget widget = (Widget)component;
        if (widget.getSize().height == 0 || widget.getSize().width == 0) {
            widget.setSize(widget.getMaximumSize());
        }
        this.corners[widget.getCorner()].add(widget);
    }

    @Override
    public void layoutContainer(Container container) {
        for (int i = 0; i < 4; ++i) {
            this.corners[i].layout(container);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        System.out.println("minimumLayoutSize");
        return null;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        System.out.println("preferredLayoutSize");
        return null;
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.checkComp(component);
        Widget widget = (Widget)component;
        this.corners[widget.getCorner()].remove(widget);
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        this.addLayoutComponent("", component);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        System.out.println("getLayoutAlignmentX");
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        System.out.println("getLayoutAlignmentY");
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        System.out.println("maximumLayoutSize");
        return null;
    }

    private void checkComp(Component component) {
        if (!(component instanceof Widget)) {
            throw new IllegalArgumentException("Only components of type " + Widget.class.getCanonicalName() + " supported.");
        }
    }

    private void checkCorner(int n) {
        if (n < 0 && n > 3) {
            throw new IllegalArgumentException("Corner");
        }
    }

    private class Corner {
        private int myCorner = 0;
        private Point offset = new Point(0, 0);
        private List<Widget> widgets = new ArrayList<Widget>();
        public int orientation = 0;

        public Corner(int n) {
            this.myCorner = n;
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Corner.Corner");
                }
            }
        }

        private void layoutTopRight(Container container) {
            Point point = new Point(container.getBounds().width, container.getBounds().y);
            point.x += this.offset.x;
            point.y += this.offset.y;
            for (Widget widget : this.widgets) {
                int n = widget.getWidth();
                int n2 = widget.getHeight();
                point.x -= n;
                if (this.orientation == 1) {
                    point.y += n2;
                }
                widget.setBounds(point.x, point.y, n, n2);
            }
        }

        private void layoutTopLeft(Container container) {
            Point point = new Point(container.getBounds().x, container.getBounds().y);
            point.x += this.offset.x;
            point.y += this.offset.y;
            for (Widget widget : this.widgets) {
                int n = widget.getPreferredSize().width;
                int n2 = widget.getPreferredSize().height;
                widget.setBounds(point.x, point.y, n, n2);
                if (this.orientation == 0) {
                    point.x += n;
                    continue;
                }
                point.y += n2;
            }
        }

        private void layoutBottomLeft(Container container) {
            if (this.widgets.size() > 0) {
                Point point = new Point(container.getBounds().x, container.getBounds().height);
                point.x += this.offset.x;
                point.y += this.offset.y;
                point.y -= this.widgets.get((int)0).getPreferredSize().height;
                for (Widget widget : this.widgets) {
                    int n = widget.getPreferredSize().width;
                    int n2 = widget.getPreferredSize().height;
                    widget.setBounds(point.x, point.y, n, n2);
                    if (this.orientation == 0) {
                        point.x += n;
                        continue;
                    }
                    point.y -= n2;
                }
            }
        }

        private void layout(Container container) {
            switch (this.myCorner) {
                case 1: {
                    this.layoutTopRight(container);
                    break;
                }
                case 0: {
                    this.layoutTopLeft(container);
                    break;
                }
                case 2: {
                    this.layoutBottomLeft(container);
                }
            }
        }

        private void add(Widget widget) {
            this.widgets.add(widget);
        }

        private void remove(Widget widget) {
            this.widgets.remove(widget);
        }
    }
}

