/*
 * Decompiled with CFR 0.152.
 */
package eu.fuegenstein.parameter;

import eu.fuegenstein.parameter.CommonParameter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DurationParameter
extends CommonParameter {
    private int hr = 1;
    private int min = 0;
    private int sec = 0;

    public DurationParameter(long l) {
        this.format = "HH:mm:ss";
    }

    public void setValue(long l) {
        this.hr = (int)(l / 3600L);
        this.min = (int)(l % 3600L / 60L);
        this.sec = (int)(l % 60L);
    }

    public long getValue() {
        return 3600 * this.hr + 60 * this.min + this.sec;
    }

    @Override
    public void setValueString(String string) {
    }

    @Override
    protected void valueToString() {
    }

    @Override
    public String getValueString() {
        return String.format("mm:hh:ss", this.hr, this.min, this.sec);
    }

    private void hmsToValue() {
    }

    @Override
    public JPanel getGuiComponent(Dimension dimension) {
        JPanel jPanel = new JPanel();
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(this.hr, 0, 24, 1));
        final JSpinner jSpinner2 = new JSpinner(new SpinnerNumberModel(this.min, 0, 59, 1));
        final JSpinner jSpinner3 = new JSpinner(new SpinnerNumberModel(this.sec, 0, 59, 1));
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                DurationParameter.this.hr = (Integer)jSpinner.getValue();
                DurationParameter.this.min = (Integer)jSpinner2.getValue();
                DurationParameter.this.sec = (Integer)jSpinner3.getValue();
                DurationParameter.this.hmsToValue();
            }
        };
        jPanel.setBackground(Color.WHITE);
        jPanel.setLayout(new FlowLayout(2));
        JLabel jLabel = new JLabel(this.description);
        jLabel.setHorizontalAlignment(4);
        jPanel.add(jLabel);
        jSpinner.setEditor(new JSpinner.NumberEditor(jSpinner, "00"));
        jSpinner.addChangeListener(changeListener);
        jPanel.add(jSpinner);
        jPanel.add(new JLabel("hr"));
        jSpinner2.setEditor(new JSpinner.NumberEditor(jSpinner2, "00"));
        jSpinner2.addChangeListener(changeListener);
        jPanel.add(jSpinner2);
        jPanel.add(new JLabel("min"));
        jSpinner3.setEditor(new JSpinner.NumberEditor(jSpinner3, "00"));
        jSpinner3.addChangeListener(changeListener);
        jPanel.add(jSpinner3);
        jPanel.add(new JLabel("sec"));
        return jPanel;
    }
}

