/*
 * Decompiled with CFR 0.152.
 */
package eu.fuegenstein.messagecenter;

import eu.fuegenstein.messagecenter.MessagePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class MessageCenter {
    private PropertyChangeListener changeListener = null;
    private JFrame frame = null;
    private JPanel glassPane = null;
    private SpringLayout springLayout = new SpringLayout();
    private Color infoColor = new Color(177, 177, 25, 192);
    private Color warningColor = new Color(255, 180, 0, 192);
    private Color errorColor = new Color(177, 25, 25, 208);
    private boolean storing = false;
    private List<MessagePanel> panels = new ArrayList<MessagePanel>();
    private int screenTime = 30;
    private Color foregroundColor = Color.BLACK;

    public MessageCenter(JFrame jFrame) {
        this.frame = jFrame;
        this.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("CLOSE")) {
                    MessageCenter.this.remove((MessagePanel)propertyChangeEvent.getSource());
                    MessageCenter.this.paint();
                }
            }
        };
        this.glassPane = new JPanel();
        this.glassPane.setLayout(this.springLayout);
        this.glassPane.setOpaque(false);
        jFrame.setGlassPane(this.glassPane);
    }

    public Color getInfoColor() {
        return this.infoColor;
    }

    public void setInfoColor(Color color) {
        this.infoColor = color;
    }

    public Color getWarningColor() {
        return this.warningColor;
    }

    public void setWarningColor(Color color) {
        this.warningColor = color;
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void setErrorColor(Color color) {
        this.errorColor = color;
    }

    public int getScreenTime() {
        return this.screenTime;
    }

    public void setScreenTime(int n) {
        this.screenTime = n;
    }

    public boolean isStoring() {
        return this.storing;
    }

    public void setStoring(boolean bl) {
        this.storing = bl;
        if (!bl) {
            this.paint();
        }
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void setFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    public void info(String string) {
        this.makePanel(this.infoColor, string, true, false);
        this.paint();
    }

    public void infoOn(MessagePanel messagePanel) {
        this.panels.add(messagePanel);
        this.paint();
    }

    public MessagePanel infoOn(String string) {
        MessagePanel messagePanel = this.makePanel(this.infoColor, string, false, false);
        this.paint();
        return messagePanel;
    }

    public MessagePanel infoOn(String string, Cursor cursor) {
        MessagePanel messagePanel = this.makePanel(this.infoColor, string, false, false);
        messagePanel.setCursor(cursor);
        this.paint();
        return messagePanel;
    }

    public void infoOff(MessagePanel messagePanel) {
        if (messagePanel != null) {
            this.remove(messagePanel);
            this.paint();
        }
    }

    public void volatileInfo(String string) {
        this.makePanel(this.infoColor, string, true, true);
        this.paint();
    }

    public void warning(String string) {
        this.makePanel(this.warningColor, string, true, false);
    }

    public void volatileWarning(String string) {
        this.makePanel(this.warningColor, string, true, true);
        this.paint();
    }

    public void volatileWarning(String string, Exception exception) {
        this.makePanel(this.warningColor, string + ": " + exception.getMessage(), true, true);
        this.paint();
    }

    public void error(String string) {
        this.makePanel(this.errorColor, string, true, false);
        this.paint();
    }

    public void error(Exception exception) {
        if (exception.getMessage() == null) {
            this.makePanel(this.errorColor, exception.getClass().getName(), true, false);
        } else {
            this.makePanel(this.errorColor, exception.getMessage(), true, false);
        }
        this.paint();
    }

    public void volatileError(String string) {
        this.makePanel(this.errorColor, string, true, true);
        this.paint();
    }

    public void volatileError(Exception exception) {
        this.makePanel(this.errorColor, exception.getMessage(), true, true);
        this.paint();
    }

    public void error(String string, Exception exception) {
        this.makePanel(this.errorColor, string + ": " + exception.getMessage(), true, false);
        this.paint();
    }

    public void volatileError(String string, Exception exception) {
        this.makePanel(this.errorColor, string + ": " + exception.getMessage(), true, false);
        this.paint();
    }

    private synchronized void remove(MessagePanel messagePanel) {
        if (this.panels.contains(messagePanel)) {
            this.panels.remove(messagePanel);
            this.springLayout.removeLayoutComponent(messagePanel);
            this.glassPane.remove(messagePanel);
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void paint() {
        for (MessagePanel object : this.panels) {
            this.springLayout.removeLayoutComponent(object);
            this.glassPane.remove(object);
        }
        if (this.panels.size() > 0 && !this.storing) {
            this.glassPane.setSize(this.frame.getSize());
            MessagePanel messagePanel = this.panels.get(0);
            this.springLayout.putConstraint("West", (Component)messagePanel, 1, "West", (Component)this.glassPane);
            this.springLayout.putConstraint("East", (Component)messagePanel, -1, "East", (Component)this.glassPane);
            this.springLayout.putConstraint("South", (Component)messagePanel, -1, "South", (Component)this.glassPane);
            this.glassPane.add(messagePanel);
            Object object = messagePanel;
            for (int i = 1; i < this.panels.size(); ++i) {
                void var2_4;
                MessagePanel messagePanel2 = this.panels.get(i);
                this.springLayout.putConstraint("West", (Component)messagePanel2, 1, "West", (Component)this.glassPane);
                this.springLayout.putConstraint("East", (Component)messagePanel2, -1, "East", (Component)this.glassPane);
                this.springLayout.putConstraint("South", (Component)messagePanel2, 3, "North", (Component)var2_4);
                this.glassPane.add(messagePanel2);
                MessagePanel messagePanel3 = messagePanel2;
            }
            this.glassPane.revalidate();
            this.glassPane.repaint();
            this.glassPane.setVisible(true);
        } else {
            this.glassPane.setVisible(false);
        }
    }

    private MessagePanel makePanel(Color color, String string, boolean bl, boolean bl2) {
        MessagePanel messagePanel = new MessagePanel();
        messagePanel.setPanelWidth(this.frame.getWidth());
        messagePanel.setForeground(this.foregroundColor);
        messagePanel.setBackground(color);
        messagePanel.setCloseable(bl);
        messagePanel.setText(string);
        messagePanel.addPropertyChangeListener(this.changeListener);
        if (bl2) {
            messagePanel.setScreenTime(this.screenTime);
        }
        this.panels.add(messagePanel);
        return messagePanel;
    }
}

