/*
 * Decompiled with CFR 0.152.
 */
package eu.fuegenstein.gis;

public class GpsCoordinate {
    private double lat = 0.0;
    private double lon = 0.0;
    long r = 6371L;

    public GpsCoordinate(double d, double d2) {
        this.setLat(d);
        this.setLon(d2);
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double d) {
        this.lat = d;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double d) {
        this.lon = d;
    }

    public double distance(GpsCoordinate gpsCoordinate) {
        double d = this.degToRad(this.lat);
        double d2 = this.degToRad(gpsCoordinate.getLat());
        double d3 = this.degToRad(gpsCoordinate.getLat() - this.lat);
        double d4 = this.degToRad(gpsCoordinate.getLon() - this.lon);
        double d5 = Math.sin(d3 / 2.0) * Math.sin(d3 / 2.0) + Math.cos(d) * Math.cos(d2) * Math.sin(d4 / 2.0) * Math.sin(d4 / 2.0);
        double d6 = 2.0 * Math.atan2(Math.sqrt(d5), Math.sqrt(1.0 - d5));
        return (double)this.r * d6;
    }

    public GpsCoordinate destination(double d, double d2) {
        double d3 = this.lat;
        double d4 = this.lon;
        double d5 = this.degToRad(d);
        double d6 = Math.asin(Math.sin(d3) * Math.cos(d2 / (double)this.r) + Math.cos(d3) * Math.sin(d2 / (double)this.r) * Math.cos(d5));
        double d7 = d4 + Math.atan2(Math.sin(d5) * Math.sin(d2 / (double)this.r) * Math.cos(d3), Math.cos(d2 / (double)this.r) - Math.sin(d3) * Math.sin(d6));
        return new GpsCoordinate(d6, d7);
    }

    private double degToRad(double d) {
        return d * Math.PI / 180.0;
    }
}

